//###########################################################################
//
// FILE:   Example_2806xEPwmRealTimeInt.c
//
// TITLE:  ePWM Real-Time Interrupt Example
//
//! \addtogroup f2806x_example_list
//! <h1>ePWM Real-Time Interrupt (epwm_real-time_interrupts)</h1>
//!
//! This example configures the ePWM1 Timer and increments
//! a counter each time an interrupt is taken. ePWM interrupt can
//! be configured as time critical to demonstrate real-time mode 
//! functionality and real-time interrupt capability.
//! ControlCard LED2 (GPIO31) is toggled in main loop
//! ControlCard LED3 (GPIO34) is toggled in ePWM1 Timer Interrupt.
//! FREE_SOFT bits and DBBIER.INT3 bit must be set to enable ePWM1
//! interrupt to be time critical and operational in real time mode
//! after halt command.
//! In this example: 
//!  - ePWM1 is initialized
//!  - ePWM1 is cleared at period match and set at Compare-A match
//!  - Compare A match occurs at half period
//!  - GPIOs for LED2 and LED3 are initialized
//!  - Free_Soft bits and DBGIER are cleared
//!  - An interrupt is taken on a zero event for the ePWM1 timer
//!
//! \b Watch \b Variables \n
//! - EPwm1TimerIntCount
//! - EPwm1Regs.TBCTL.bit.FREE_SOFT
//! - EPwm1Regs.TBCTR
//! - DBGIER.INT3
//
//###########################################################################
// $TI Release: F2806x Support Library v2.02.00.00 $
// $Release Date: Sat Sep 16 15:27:43 CDT 2017 $
// $Copyright:
// Copyright (C) 2009-2017 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################

//
// Included Files
//
#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File

#define ON  1
#define OFF 0
#define ENABLE  1
#define DISABLE 0

extern void Gpio_select(void);
// extern void delay_loop(void);

//
// Defines
//

//
// Configure if ePWM timer interrupt is enabled at the PIE level:
// 1 = enabled,  0 = disabled
//
#define PWM7_INT_ENABLE  1
// #define PWM7_TIMER_TBPRD   0x1FFF       // Configure the period for the timer
#define PWM7_TIMER_TBPRD   0x5FFF           // close to 2 kHz
//
// Function Prototypes
//
__interrupt void epwm7_timer_isr(void);
void InitEPwmTimer(void);

//
// Globals
//
Uint32  EPwm7TimerIntCount;		//counts entries into PWM1 Interrupt
Uint16	LEDcount;				//creates delay for LED3 toggling

//
// Main
//
void main(void)
{
    int i;

    Gpio_select();                          // init GPIO

    EALLOW;

     GpioCtrlRegs.GPBMUX1.bit.GPIO39 = DISABLE;                // Error
     GpioDataRegs.GPBSET.bit.GPIO39 = ENABLE;
     GpioCtrlRegs.GPBDIR.bit.GPIO39 = ENABLE;
   //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
     GpioCtrlRegs.GPBPUD.bit.GPIO39 = ENABLE;

     GpioCtrlRegs.GPAMUX1.bit.GPIO8 = DISABLE;                // ENABLE MEMS OSC - 90 MHz
     GpioDataRegs.GPASET.bit.GPIO8 = ENABLE;
     GpioCtrlRegs.GPADIR.bit.GPIO8 = ENABLE;
   //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
     GpioCtrlRegs.GPAPUD.bit.GPIO8 = ENABLE;

     GpioCtrlRegs.GPAMUX2.bit.GPIO19 = DISABLE;                  // XCLKIN
    // GpioDataRegs.GPASET.bit.GPIO8 = DISABLE;
         GpioCtrlRegs.GPADIR.bit.GPIO19 = DISABLE;
       //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
         GpioCtrlRegs.GPAPUD.bit.GPIO19 = ENABLE;                // this means NO pullup is enabled
         GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

     GpioCtrlRegs.GPBMUX2.bit.GPIO53 = DISABLE;              // OCXO OUT En
     GpioDataRegs.GPBSET.bit.GPIO53 = DISABLE;
     GpioCtrlRegs.GPBDIR.bit.GPIO53 = DISABLE;
     //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
     GpioCtrlRegs.GPBPUD.bit.GPIO53 = ENABLE;                // this means NO pullup is enabled
     // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

     GpioCtrlRegs.GPAMUX1.bit.GPIO9 = ENABLE;              // 10MHz OUT In - ECAP3
        GpioDataRegs.GPASET.bit.GPIO9 = DISABLE;
        GpioCtrlRegs.GPADIR.bit.GPIO9 = DISABLE;
        //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
        GpioCtrlRegs.GPAPUD.bit.GPIO9 = ENABLE;                // this means NO pullup is enabled
        // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

        GpioCtrlRegs.GPBMUX2.bit.GPIO54 = ENABLE;              // clkin hrcap - hrcap1
            GpioDataRegs.GPBSET.bit.GPIO54 = DISABLE;
            GpioCtrlRegs.GPBDIR.bit.GPIO54 = DISABLE;
            //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
            GpioCtrlRegs.GPBPUD.bit.GPIO54 = ENABLE;                // this means NO pullup is enabled
            // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

            GpioCtrlRegs.GPAMUX1.bit.GPIO11 = ENABLE;              // clkin hrcap - ECAP1
                     GpioDataRegs.GPASET.bit.GPIO11 = DISABLE;
                     GpioCtrlRegs.GPADIR.bit.GPIO11 = DISABLE;
                     //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                     GpioCtrlRegs.GPAPUD.bit.GPIO11 = ENABLE;                // this means NO pullup is enabled
                     // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

 //                    GpioCtrlRegs.GPBMUX1.bit.GPIO55 = 1;
                     GpioCtrlRegs.GPBMUX2.bit.GPIO55 = ENABLE;              // clkin hrcap2
                          GpioDataRegs.GPBSET.bit.GPIO55 = DISABLE;
                          GpioCtrlRegs.GPBDIR.bit.GPIO55 = DISABLE;
                          //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                          GpioCtrlRegs.GPBPUD.bit.GPIO55 = ENABLE;                // this means NO pullup is enabled
                          // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

                          GpioCtrlRegs.GPBMUX2.bit.GPIO56 = ENABLE;              // clkin hrcap3
                               GpioDataRegs.GPBSET.bit.GPIO56 = DISABLE;
                               GpioCtrlRegs.GPBDIR.bit.GPIO56 = DISABLE;
                               //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                               GpioCtrlRegs.GPBPUD.bit.GPIO56 = ENABLE;                // this means NO pullup is enabled
                               // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;



        GpioCtrlRegs.GPAMUX1.bit.GPIO0 = DISABLE;                // 1PPS 6T Out En
        GpioDataRegs.GPASET.bit.GPIO0 = ENABLE;                  // active high
        GpioCtrlRegs.GPADIR.bit.GPIO0 = ENABLE;
    //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
        GpioCtrlRegs.GPAPUD.bit.GPIO0 = ENABLE;

         GpioCtrlRegs.GPAMUX1.bit.GPIO2 = DISABLE;                // I2C En
         GpioDataRegs.GPASET.bit.GPIO2 = DISABLE;                  // active high
         GpioCtrlRegs.GPADIR.bit.GPIO2 = ENABLE;
     //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
         GpioCtrlRegs.GPAPUD.bit.GPIO2 = ENABLE;


        GpioCtrlRegs.GPBMUX2.bit.GPIO50 = ENABLE;              // PGA CS
        GpioDataRegs.GPBSET.bit.GPIO50 = ENABLE;
        GpioCtrlRegs.GPBDIR.bit.GPIO50 = ENABLE;
    //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
        GpioCtrlRegs.GPBPUD.bit.GPIO50 = ENABLE;                // this means NO pullup is enabled
    // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;



        GpioCtrlRegs.GPAMUX2.bit.GPIO17 = ENABLE;              // AD SPI CSH
         GpioDataRegs.GPASET.bit.GPIO17 = ENABLE;
         GpioCtrlRegs.GPADIR.bit.GPIO17 = ENABLE;
     //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
         GpioCtrlRegs.GPAPUD.bit.GPIO17 = ENABLE;                // this means NO pullup is enabled
     // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

         GpioCtrlRegs.GPAMUX2.bit.GPIO30 = 0x03;              // PWM for DAC
 //         GpioDataRegs.GPASET.bit.GPIO30 = ENABLE;
 //         GpioCtrlRegs.GPADIR.bit.GPIO30 = ENABLE;
      //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
          GpioCtrlRegs.GPAPUD.bit.GPIO30 = ENABLE;                // this means NO pullup is enabled
      // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

          GpioCtrlRegs.GPBMUX1.bit.GPIO44 = DISABLE;              // PWM for DAC
           GpioDataRegs.GPBSET.bit.GPIO44 = ENABLE;
           GpioCtrlRegs.GPBDIR.bit.GPIO44 = DISABLE;
       //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
           GpioCtrlRegs.GPBPUD.bit.GPIO44 = ENABLE;                // this means NO pullup is enabled
       // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

           GpioCtrlRegs.GPBMUX1.bit.GPIO43 = DISABLE;              // PWM for DAC
             GpioDataRegs.GPBSET.bit.GPIO43 = DISABLE;
             GpioCtrlRegs.GPBDIR.bit.GPIO43 = DISABLE;
         //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
             GpioCtrlRegs.GPBPUD.bit.GPIO43 = ENABLE;                // this means NO pullup is enabled
         // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

             GpioCtrlRegs.GPBMUX1.bit.GPIO42 = DISABLE;              // 1PPS in en
                GpioDataRegs.GPBSET.bit.GPIO42 = ENABLE;
                GpioCtrlRegs.GPBDIR.bit.GPIO42 = ENABLE;
            //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                GpioCtrlRegs.GPBPUD.bit.GPIO42 = ENABLE;                // this means NO pullup is enabled
            // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

                GpioCtrlRegs.GPBMUX1.bit.GPIO34 = DISABLE;              // gpio34
                     GpioDataRegs.GPBSET.bit.GPIO34 = DISABLE;
                     GpioCtrlRegs.GPBDIR.bit.GPIO34 = DISABLE;
                 //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                     GpioCtrlRegs.GPBPUD.bit.GPIO34 = ENABLE;                // this means NO pullup is enabled
                 // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

                     GpioCtrlRegs.GPAMUX2.bit.GPIO28 = 0x02;              // i2c for 6t
                        GpioDataRegs.GPASET.bit.GPIO28 = DISABLE;
                        GpioCtrlRegs.GPADIR.bit.GPIO28 = DISABLE;
                    //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                        GpioCtrlRegs.GPAPUD.bit.GPIO28 = ENABLE;                // this means NO pullup is enabled
                    // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

                        GpioCtrlRegs.GPAMUX2.bit.GPIO29 = 0x02;              // i2c for 6t
                           GpioDataRegs.GPASET.bit.GPIO29 = DISABLE;
                           GpioCtrlRegs.GPADIR.bit.GPIO29 = DISABLE;
                       //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                           GpioCtrlRegs.GPAPUD.bit.GPIO29 = ENABLE;                // this means NO pullup is enabled
                       // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

                           GpioCtrlRegs.GPAMUX2.bit.GPIO25 = ENABLE;              // ocxo out m
                           GpioDataRegs.GPASET.bit.GPIO25 = DISABLE;
                           GpioCtrlRegs.GPADIR.bit.GPIO25 = DISABLE;
                       //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                           GpioCtrlRegs.GPAPUD.bit.GPIO25 = ENABLE;                // this means NO pullup is enabled
                        // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

                           GpioCtrlRegs.GPAMUX2.bit.GPIO24 = ENABLE;              // 1PPS IN
                                          GpioDataRegs.GPASET.bit.GPIO24 = DISABLE;
                                          GpioCtrlRegs.GPADIR.bit.GPIO24 = DISABLE;
                                      //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                                          GpioCtrlRegs.GPAPUD.bit.GPIO24 = ENABLE;                // this means NO pullup is enabled
                                       // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

 // ad spi setup:

                                          GpioCtrlRegs.GPAMUX2.bit.GPIO18 = ENABLE;              // SPI CLK
                                          GpioDataRegs.GPASET.bit.GPIO18 = DISABLE;
                                          GpioCtrlRegs.GPADIR.bit.GPIO18 = ENABLE;
                                      //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                                          GpioCtrlRegs.GPAPUD.bit.GPIO18 = ENABLE;                // this means NO pullup is enabled
                                       // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

                                          GpioCtrlRegs.GPAMUX2.bit.GPIO17 = DISABLE;              // SPI CS
                                          GpioDataRegs.GPASET.bit.GPIO17 = ENABLE;
                                          GpioCtrlRegs.GPADIR.bit.GPIO17 = ENABLE;
                                      //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                                          GpioCtrlRegs.GPAPUD.bit.GPIO17 = ENABLE;                // this means NO pullup is enabled
                                       // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

                                          GpioCtrlRegs.GPBMUX2.bit.GPIO51 = DISABLE;              // AD SPI CSH
                                           GpioDataRegs.GPBSET.bit.GPIO51 = ENABLE;
                                           GpioCtrlRegs.GPBDIR.bit.GPIO51 = ENABLE;
                                       //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                                           GpioCtrlRegs.GPBPUD.bit.GPIO51 = ENABLE;                // this means NO pullup is enabled
                                       // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;


                                          GpioCtrlRegs.GPAMUX2.bit.GPIO16 = ENABLE;              // SPI MOSI
                                          GpioDataRegs.GPASET.bit.GPIO16 = DISABLE;
                                          GpioCtrlRegs.GPADIR.bit.GPIO16 = ENABLE;
                                      //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                                          GpioCtrlRegs.GPAPUD.bit.GPIO16 = ENABLE;                // this means NO pullup is enabled
                                       // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

                                          GpioCtrlRegs.GPAMUX1.bit.GPIO15 = DISABLE;              //
                                          GpioDataRegs.GPASET.bit.GPIO15 = DISABLE;
                                          GpioCtrlRegs.GPADIR.bit.GPIO15 = DISABLE;
                                      //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                                          GpioCtrlRegs.GPAPUD.bit.GPIO15 = ENABLE;                // this means NO pullup is enabled
                                       // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;


                                          GpioCtrlRegs.GPAMUX1.bit.GPIO14 = DISABLE;              //
                                          GpioDataRegs.GPASET.bit.GPIO14 = DISABLE;
                                          GpioCtrlRegs.GPADIR.bit.GPIO14 = DISABLE;
                                      //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                                          GpioCtrlRegs.GPAPUD.bit.GPIO14 = ENABLE;                // this means NO pullup is enabled
                                       // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;

                                          GpioCtrlRegs.GPAMUX1.bit.GPIO10 = DISABLE;              //
                                                               GpioDataRegs.GPASET.bit.GPIO10 = ENABLE;
                                                               GpioCtrlRegs.GPADIR.bit.GPIO10 = ENABLE;
                                                           //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                                                               GpioCtrlRegs.GPAPUD.bit.GPIO10 = ENABLE;                // this means NO pullup is enabled
                                                            // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;


 // Prog Status

                                                               GpioCtrlRegs.GPAMUX1.bit.GPIO3 = DISABLE;              //
                                                               GpioDataRegs.GPASET.bit.GPIO3 = DISABLE;
                                                               GpioCtrlRegs.GPADIR.bit.GPIO3 = ENABLE;
                                                          //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                                                               GpioCtrlRegs.GPAPUD.bit.GPIO3 = ENABLE;                // this means NO pullup is enabled
                                                            // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;


 // TX/RX Wireless

                                                               GpioCtrlRegs.GPAMUX1.bit.GPIO7 = 0x02;              //  RX Wireless - SCIRXDA(I)
                                                               GpioDataRegs.GPASET.bit.GPIO7 = DISABLE;
                                                               GpioCtrlRegs.GPADIR.bit.GPIO7 = DISABLE;
                                                           //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                                                               GpioCtrlRegs.GPAPUD.bit.GPIO7 = ENABLE;                // this means NO pullup is enabled
                                                               GpioCtrlRegs.GPAQSEL1.bit.GPIO7 = ENABLE;


                                                               GpioCtrlRegs.GPAMUX1.bit.GPIO12 = 0x02;              //  TX Wireless - SCITXDA(O)
                                                               GpioDataRegs.GPASET.bit.GPIO12 = DISABLE;
                                                               GpioCtrlRegs.GPADIR.bit.GPIO12 = ENABLE;
                                                           //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                                                               GpioCtrlRegs.GPAPUD.bit.GPIO12 = ENABLE;                // this means NO pullup is enabled
                                                               GpioCtrlRegs.GPAQSEL1.bit.GPIO12 = ENABLE;


                                                               GpioCtrlRegs.GPAMUX1.bit.GPIO6 = 0x02;              //
                                                               GpioDataRegs.GPASET.bit.GPIO6 = DISABLE;
                                                               GpioCtrlRegs.GPADIR.bit.GPIO6 = ENABLE;
                                                           //  GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
                                                               GpioCtrlRegs.GPAPUD.bit.GPIO6 = ENABLE;                // this means NO pullup is enabled
                                                            // GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = ENABLE;



     EDIS;

    //
    // Step 1. Initialize System Control:
    // PLL, WatchDog, enable Peripheral Clocks
    // This example function is found in the F2806x_SysCtrl.c file.
    //
    InitSysCtrl();

    //
    // Step 2. Initalize GPIO:
    // This example function is found in the F2806x_Gpio.c file and
    // illustrates how to set the GPIO to it's default state.
    //
    // InitGpio();  // Skipped for this example - LEDs set up in main code
    EALLOW;

    //
    // GPIO-31 - PIN FUNCTION = LED2 on controlCARD
    //
#if 0
    GpioCtrlRegs.GPAMUX2.bit.GPIO31 = 0;  // 0=GPIO
    GpioCtrlRegs.GPADIR.bit.GPIO31 = 1;	  // 1=OUTput,  0=INput 
    GpioDataRegs.GPACLEAR.bit.GPIO31 = 1; // uncomment if --> Set Low initially
    //GpioDataRegs.GPASET.bit.GPIO31 = 1;// uncomment if --> Set High initially

    //
    // GPIO-34 - PIN FUNCTION = LED3 on controlCARD
    //
    GpioCtrlRegs.GPBMUX1.bit.GPIO34 = 0;	// 0=GPIO
    GpioCtrlRegs.GPBDIR.bit.GPIO34 = 1;		// 1=OUTput,  0=INput 
    //GpioDataRegs.GPBCLEAR.bit.GPIO34 = 1;//uncomment if --> Set Low initially
    GpioDataRegs.GPBSET.bit.GPIO34 = 1;  // uncomment if --> Set High initially
#endif
    EDIS;

    //
    // Step 3. Clear all interrupts and initialize PIE vector table:
    // Disable CPU interrupts
    //
    DINT;

    //
    // Initialize the PIE control registers to their default state.
    // The default state is all PIE interrupts disabled and flags
    // are cleared.
    // This function is found in the F2806x_PieCtrl.c file.
    //
    InitPieCtrl();

    //
    // Disable CPU interrupts and clear all CPU interrupt flags
    //
    IER = 0x0000;
    IFR = 0x0000;

    //
    // Initialize the PIE vector table with pointers to the shell Interrupt
    // Service Routines (ISR).
    // This will populate the entire table, even if the interrupt
    // is not used in this example.  This is useful for debug purposes.
    // The shell ISR routines are found in F2806x_DefaultIsr.c.
    // This function is found in F2806x_PieVect.c.
    //
    InitPieVectTable();

    //
    // Interrupt that is used in this example is re-mapped to
    // ISR function found within this file.
    //
    EALLOW;  // This is needed to write to EALLOW protected registers
    PieVectTable.EPWM7_INT = &epwm7_timer_isr;
    EDIS;    // This is needed to disable write to EALLOW protected registers

    EALLOW;
//    HWREG(USBMODESEL) = USBMODESEL_DEV;
//    HWREG(USB0_BASE + USB_O_GPCS) = USBGPCS_DEV;

    //GpioCtrlRegs.GPAMUX1.bit.GPIO8 = ENABLE;                // ENABLE MEMS OSC - 90 MHz
    //GpioCtrlRegs.GPAPUD.bit.GPIO8 = DISABLE;
    // GpioCtrlRegs.GPADIR.bit.GPIO8 = ENABLE;

//    GpioCtrlRegs.GPAMUX2.bit.GPIO11 = DISABLE;                // ENABLE USB
    GpioCtrlRegs.GPAMUX2.bit.GPIO21 = DISABLE;
    GpioDataRegs.GPASET.bit.GPIO21 = ENABLE;
    GpioCtrlRegs.GPAPUD.bit.GPIO21 = DISABLE;
    GpioCtrlRegs.GPADIR.bit.GPIO21 = ENABLE;
//    GpioCtrlRegs.GPAMUX2.bit.
    GpioCtrlRegs.GPAMUX2.bit.GPIO31 = DISABLE;                // PFLT
    GpioDataRegs.GPASET.bit.GPIO31 = ENABLE;
    GpioCtrlRegs.GPAPUD.bit.GPIO31 = DISABLE;
    GpioCtrlRegs.GPADIR.bit.GPIO31 = DISABLE;

    GpioCtrlRegs.GPBMUX1.bit.GPIO32 = DISABLE;                // ENABLE u-blox
    GpioDataRegs.GPBSET.bit.GPIO32 = ENABLE;
    GpioCtrlRegs.GPBPUD.bit.GPIO32 = DISABLE;
    GpioCtrlRegs.GPBDIR.bit.GPIO32 = ENABLE;

    GpioCtrlRegs.GPBMUX1.bit.GPIO33 = DISABLE;                // USB_ID
    GpioDataRegs.GPBSET.bit.GPIO33 = ENABLE;
    GpioCtrlRegs.GPBPUD.bit.GPIO33 = DISABLE;
    GpioCtrlRegs.GPBDIR.bit.GPIO33 = DISABLE;

    // GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;

    // HWREG(USBMODESEL) = USBMODESEL_DEV;
    // HWREG(USB0_BASE + USB_O_GPCS) = USBGPCS_DEV;
    EDIS;

    EALLOW;
    GpioCtrlRegs.GPAMUX2.bit.GPIO23 = 3;           // rx - tx from ublox
    GpioCtrlRegs.GPAPUD.bit.GPIO23 = DISABLE;
    GpioCtrlRegs.GPAQSEL2.bit.GPIO23 = ENABLE;
    GpioCtrlRegs.GPADIR.bit.GPIO23 = DISABLE;

    GpioCtrlRegs.GPAMUX2.bit.GPIO22 = 3;           // tx - rx to ublox
    GpioCtrlRegs.GPAPUD.bit.GPIO22 = DISABLE;
    GpioCtrlRegs.GPADIR.bit.GPIO22 = ENABLE;

    GpioCtrlRegs.GPAMUX1.bit.GPIO0 = DISABLE;                // 1PPS_OUT6T_EN
    GpioDataRegs.GPASET.bit.GPIO0 = ENABLE;
    GpioCtrlRegs.GPAPUD.bit.GPIO0 = DISABLE;
    GpioCtrlRegs.GPADIR.bit.GPIO0 = ENABLE;                 // active low

    GpioCtrlRegs.GPAMUX1.bit.GPIO1 = DISABLE;                // 10MHZ_6TIN_EN
    GpioDataRegs.GPASET.bit.GPIO1 = ENABLE;
    GpioCtrlRegs.GPAPUD.bit.GPIO1 = DISABLE;
    GpioCtrlRegs.GPADIR.bit.GPIO1 = ENABLE;                 // active low

    GpioCtrlRegs.GPAMUX1.bit.GPIO2 = DISABLE;                // I2C_ENABLE_280
    GpioDataRegs.GPASET.bit.GPIO2 = ENABLE;
    GpioCtrlRegs.GPAPUD.bit.GPIO2 = DISABLE;
    GpioCtrlRegs.GPADIR.bit.GPIO2 = DISABLE;                 // active high



    GpioCtrlRegs.GPBMUX2.bit.GPIO58 = DISABLE;                // 10MHZ_OUT6T_EN
    GpioDataRegs.GPBSET.bit.GPIO58 = DISABLE;
    GpioCtrlRegs.GPBPUD.bit.GPIO58 = DISABLE;
    GpioCtrlRegs.GPBDIR.bit.GPIO58 = DISABLE;                // mux - this selects b

   // GpioDataRegs.GPADAT.bit.GPIO8 = ENABLE;
    EDIS;

    //
    // Step 4. Initialize all the Device Peripherals:
    // This function is found in F2806x_InitPeripherals.c
    //
    // InitPeripherals();  // Not required for this example
    InitEPwmTimer();    // For this example, only initialize the ePWM Timer

    //
    // Step 5. User specific code, enable interrupts
    //

    //
    // Initalize counters
    //
    EPwm7TimerIntCount = 0;

    LEDcount=0;

    //
    // Enable CPU INT3 which is connected to EPWM1-6 INT
    //
    IER |= M_INT3;

    //
    // Enable EPWM INTn in the PIE: Group 3 interrupt 1-6
    //
    PieCtrlRegs.PIEIER3.bit.INTx7 = PWM7_INT_ENABLE;

    //
    // Initially disable time-critical interrupts
    //
    SetDBGIER(0x0000);          // PIE groups time-critical designation

    //
    // Enable global Interrupts and higher priority real-time debug events
    //
    EINT;   // Enable Global interrupt INTM
    ERTM;   // Enable Global realtime interrupt DBGM

    //
    // Step 6. IDLE loop. Just sit and loop forever (optional)
    //
    for(;;)
    {
        __asm("          NOP");
        for(i=1;i<=100;i++) 
        {
            //
            // toggle LED2 on the controlCARD
            // 
//            GpioDataRegs.GPATOGGLE.bit.GPIO31 = 1;
        }
    }
}

//
// InitEPwmTimer - 
//
void
InitEPwmTimer()
{
    EALLOW;
    SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;      // Stop all the TB clocks
    EDIS;

    //
    // Disable Sync
    //
    EPwm7Regs.TBCTL.bit.SYNCOSEL = 11;  // Pass through

    //
    // Initally disable Free/Soft Bits
    //
    EPwm7Regs.TBCTL.bit.FREE_SOFT = 0;

    EPwm7Regs.TBPRD = PWM7_TIMER_TBPRD;			 // Set up PWM1 Period
    EPwm7Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP;   // Count up mode
    EPwm7Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;    // Select INT on Zero event
    EPwm7Regs.ETSEL.bit.INTEN = PWM7_INT_ENABLE; // Enable INT
    EPwm7Regs.ETPS.bit.INTPRD = ET_1ST;          // Generate INT on 1st event
    EPwm7Regs.TBCTR = 0x0000;					 // Clear timer counter
    
    //
    // CompareA event at half of period
    //
    EPwm7Regs.CMPA.half.CMPA = PWM7_TIMER_TBPRD/2;
    
    //
    // Action-qualifiers, Set on CMPA, Clear on PRD
    //
    EPwm7Regs.AQCTLA.all = 0x0024;

    EALLOW;
    SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;       // Start all the timers synced
    EDIS;
}

//
// epwm1_timer_isr - Interrupt routines uses in this example
//
__interrupt void
epwm7_timer_isr(void)
{
    EPwm7TimerIntCount++;
    LEDcount++;

    //
    // Clear INT flag for this timer
    //
    EPwm7Regs.ETCLR.bit.INT = 1;

    if (LEDcount==500)
    {
        //
        // turn on/off LED3 on the controlCARD
        //
//        GpioDataRegs.GPBTOGGLE.bit.GPIO34 = 1;
        LEDcount=0;
    }

    //
    // Acknowledge this interrupt to receive more interrupts from group 3
    //
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;
}

//
// End of File
//

