// TI File $Revision: /main/4 $
// Checkin $Date: August 2, 2006   16:58:50 $
//########################################################################### 
//
// FILE:   AIC23.h
//
// TITLE:  AIC23 Codec Defines
//
// DECRIPTION: 	AIC23B op-code definitions.
//
//###########################################################################
// $TI Release: AIC23 Defines
// $Release Date: September 23, 2008 $
//###########################################################################


#define MIC 0       // Set to 1 if using microphone as input
/* Useful Definitions */
// Sample Rates:
#define SRUSB44_1    0x0022 //44.1 kHz, BOSR set
#define SRUSB48      0x0000 //48 kHz, BOSR clear
#define SR44_1       0x0020 //44.1 kHz normal - 11.2896 MHz MCLK, BOSR clear

// Volume Control:
#define LIV         0x0017 // Left line input volume control
                           // 11111=12 dB down to 00000= -34.5 dB
						   // at 1.5 dB per step
						   // Default = 10111 = 0dB
#define RIV         0x0017 // Right line input volume control
                           // 11111=12 dB down to 00000= -34.5 dB
						   // at 1.5 dB per step
						   // Default = 10111 = 0dB
#define LHV         0x007F // Left Channel Headphone Volume Control
                           // 1111111 = 6 dB, 79 steps between +6 and -73 dB (mute)
						   // 0000000 = -73 dB (mute)
						   // Currently set at 1110000 = -9 dB
#define RHV         0x007F // Right Channel Headphone Volume Control
                           // 1111111 = 6 dB, 79 steps between +6 and -73 dB (mute)
						   // 0000000 = -73 dB (mute)
						   // Currently set at 1110000 = -9 dB
#ifndef _AIC_23_H
#define _AIC_23_H
/* TLV320AIC23B Register Map */
#define LLINVCTL    0x0000 // Left line input channel volume control 
#define RLINVCTL    0x0200 // Right line input channel volume control
#define LHVCTL      0x0400 // Left channel headphone volume control
#define RHVCTL      0x0600 // Right channel headphone volume control
#define AAUDCTL     0x0800 // Analog audio path control
#define DAUDCTL     0x0A00 // Digital audio path control
#define POWDCTL     0x0C00 // Power down control
#define DAUDINTF    0x0E00 // Digital audio interface format
#define SMPLRCTL    0x1000 // Sample rate control
#define DIGINTFACT  0x1200 // Digital interface activation
#define RESETREG    0x1E00 // Reset register

/* Left line input channel volume control */
// To be filled in later...
#define LIM         0x0080 // Left line input mute
//#define LIV         0x0017 // Left line input volume control
                           // 11111=12 dB down to 00000= -34.5 dB
						   // at 1.5 dB per step
						   // Default = 10111 = 0dB
 
/* Right line input channel volume control */
// To be filled in later...
#define RIM         0x0080 // Right line input mute
//#define RIV         0x0017 // Right line input volume control
                           // 11111=12 dB down to 00000= -34.5 dB
						   // at 1.5 dB per step
						   // Default = 10111 = 0dB

/* Left channel headphone volume control */
// To be filled in later...
#define LZC         0x0080 // Right channel Zero-cross detect
//#define LHV         0x007B // Left Channel Headphone Volume Control
                           // 1111111 = 6 dB, 79 steps between +6 and -73 dB (mute)
						   // 0000000 = -73 dB (mute)
						   // Currently set at 1111011 = 3 dB

/* Right channel headphone volume control */
// To be filled in later...
#define RZC         0x0080 // Left channel Zero-cross detect
//#define RHV         0x007B // Right Channel Headphone Volume Control
                           // 1111111 = 6 dB, 79 steps between +6 and -73 dB (mute)
						   // 0000000 = -73 dB (mute)
						   // Currently set at 1111011 = 3 dB


/* Analog audio path control - default 0x0010 */
#define DB_0_ST      0x0120 //  0  dB Added Sidetone
#define DB_N6_ST     0x0020 // -6  dB Added Sidetone
#define DB_N9_ST     0x0060 // -9  dB Added Sidetone
#define DB_N12_ST    0x00A0 // -12 dB Added Sidetone
#define DB_N18_ST    0x00E0 // -18 dB Added Sidetone
#define STDIS        0x0000 // Added Sidetone Disabled
#define DAC          0x0010 // 1
#define BYPASS       0x0008 // 0
#define MICINSEL     0x0004 // 0
#define MICMUTE      0x0002 // 0
#define MICBOOST     0x0001 // 0

/* Digital audio path control - default 0x0008 */
#define DACM         0x0008 // DAC soft mute enabled
#define DEEMP48      0x0006 // 48 kHz de-emphasis control
#define DEEMP44_1    0x0004 // 44.1 kHz de-emphasis control
#define DEEMP32      0x0002 // 32 kHz de-emphasis control
#define ADCHP        0x0001 // Disables ADC high-pass filter


/* Power down control - default 0x0007 */
#define AIC23OFF     0x0080
#define AIC23CLK     0x0040
#define AIC23OSC     0x0020
#define AIC23OUT     0x0010
#define AIC23DAC     0x0008 // 0
#define AIC23ADC     0x0004 // 0
#define AIC23MIC     0x0002 // 1
#define AIC23LINE    0x0001 // 0

/* Digital audio interface format */
#define AIC23MS      0x0040
#define LRSWAP       0x0020
#define LRP          0x0010
#define FORMSBFRA    0x0000
#define FORMSBFLA    0x0001
#define FORI2S       0x0002
#define FORDSP       0x0003
#define IWL16B       0x0000
#define IWL20B       0x0004
#define IWL24B       0x0008
#define IWL32B       0x000C


/* Sample rate control */
#define AIC23CLKIND  0x0040
#define AIC23CLKOUTD 0x0080
#define BOSR         0x0002  
#define USB          0x0001

/* Digital interface activation */
#define ACT          0x0001

/* Reset register */
#define RES          0x0000

// AIC23.c Function Prototypes
extern Uint16 softpowerdown (void);
extern Uint16 fullpowerup (void);   
extern Uint16 nomicpowerup (void); 
extern Uint16 linput_volctl (Uint16 volume); 
extern Uint16 rinput_volctl (Uint16 volume);
extern Uint16 lhp_volctl (Uint16 volume);
extern Uint16 rhp_volctl (Uint16 volume);
extern Uint16 nomicaaudpath (void);
extern Uint16 aaudpath (void);
extern Uint16 digaudiopath (void);
extern Uint16 DSPdigaudinterface (void);
extern Uint16 I2Sdigaudinterface (void);
extern Uint16 USBsampleratecontrol (Uint16 ratecontrol);
extern Uint16 CLKsampleratecontrol (Uint16 ratecontrol);

extern Uint16 digact (void);
extern Uint16 reset (void);

#endif
