/*
 * i2c_library.h
 *
 *  Created on: 07.03.2018
 *      Author: Dawid Balcerzak
 */

#ifndef I2C_LIBRARY_H_
#define I2C_LIBRARY_H_

// DEFINES
// Buffer size defines
#define I2CM_WRITE_BUFFER_SIZE  10
#define I2CM_READ_BUFFER_SIZE   10

// TYPEDEFS
typedef unsigned char uint8_t;

// Transaction result enumeration
typedef enum I2CM_RESULT_enum {
    I2CM_RESULT_UNKNOWN          = (0x00<<0),
    I2CM_RESULT_OK               = (0x01<<0),
    I2CM_RESULT_BUFFER_OVERFLOW  = (0x02<<0),
    I2CM_RESULT_ARBITRATION_LOST = (0x03<<0),
    I2CM_RESULT_BUS_ERROR        = (0x04<<0),
    I2CM_RESULT_NACK_RECEIVED    = (0x05<<0),
    I2CM_RESULT_FAIL             = (0x06<<0),
} I2CM_RESULT_t;
typedef enum I2CM_STATUS_enum {
    I2CM_STATUS_READY = 0,
    I2CM_STATUS_BUSY
} I2CM_STATUS_t;
typedef struct I2C_Master {
    // variables
    uint32_t I2C_BASE;                                  // I2C base
    uint16_t/*uint8_t*/ address;                                    // Slave address
    uint16_t/*uint8_t*/ writeData[I2CM_WRITE_BUFFER_SIZE];          // Data to write
    uint16_t/*uint8_t*/ readData[I2CM_READ_BUFFER_SIZE];            // Read data
    uint16_t bytesToWrite;                              // Number of bytes to write
    uint16_t bytesToRead;                               // Number of bytes to read
    uint16_t bytesWritten;                              // Number of bytes written
    uint16_t bytesRead;                                 // Number of bytes read
    I2CM_STATUS_t status;                               // Status of transaction
    I2CM_RESULT_t result;                               // Result of transaction
    //--------------------------------------------------------------------------------

    // pointers to API functions
    void (*SendStartCondition)(uint32_t I2cBase);
    void (*SendStopCondition)(uint32_t I2cBase);
    void (*SetSlaveAddress)(uint32_t I2cBase, uint16_t SlaveAddress);
    void (*SetDataCount)(uint32_t I2cBase, uint16_t DataCount);
    void (*SetConfig)(uint32_t I2cBase, uint16_t Config);
    void (*PutData)(uint32_t I2cBase, uint16_t Data);
    uint16_t (*GetData)(uint32_t I2cBase);
    I2C_RxFIFOLevel (*GetRxFIFOStatus)(uint32_t I2cBase);
    I2C_InterruptSource (*GetInterruptSource)(uint32_t I2cBase);
    //--------------------------------------------------------------------------------
}I2C_Master_t;
//************************************************************************************

// Global functions prototypes
void I2C_lib_init(uint32_t I2C_BASE, I2C_Master_t *i2c);
void I2C_lib_MasterWriteRead(I2C_Master_t *i2c,
                             uint16_t /*uint8_t*/ address,
                             uint16_t /*uint8_t*/ *writeData,
                         uint16_t bytesToWrite,
                         uint16_t bytesToRead);
void I2C_lib_InterruptHandler(I2C_Master_t *i2c);
//************************************************************************************

#endif /* I2C_LIBRARY_H_ */
