#include "driverlib.h"
#include "device.h"
#include "i2c_library.h"

#define SLAVE_ADDRESS               0x20
#define BMP280_SLAVE_ADDRESS        0x76 // SDO to GND
#define EEPROM_ADDRESS              0x50

I2C_Master_t I2cMaster;
uint32_t counter = 0;
uint32_t stop = 0;

__interrupt void i2cAISR(void);
I2CM_RESULT_t result = I2CM_RESULT_UNKNOWN;
I2CM_STATUS_t status = I2CM_STATUS_READY;
void main(void)
{
    Device_init();
    Device_initGPIO();

    // PINOUT CONFIGURATION
    GPIO_setPinConfig(GPIO_104_SDAA);
    GPIO_setPadConfig(104, GPIO_PIN_TYPE_PULLUP);
    GPIO_setQualificationMode(104, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(GPIO_105_SCLA);
    GPIO_setPadConfig(105, GPIO_PIN_TYPE_PULLUP);
    GPIO_setQualificationMode(105, GPIO_QUAL_ASYNC);
    // *********************************************

    Interrupt_initModule();
    Interrupt_initVectorTable();
    Interrupt_register(INT_I2CA, &i2cAISR);

    I2C_lib_init(I2CA_BASE, &I2cMaster);

    Interrupt_enable(INT_I2CA);

    EINT;
    ERTM;

    while(1)
    {
        counter++;
        // przykadowe dane do wysyki
        uint16_t /*uint8_t*/ data[] = {0x0F, 0x1F, 0x2F, 0x3F, 0x4F};

        // wywoanie funkcji - zapis 5 danych i odczyt 9
        I2C_lib_MasterWriteRead(&I2cMaster, SLAVE_ADDRESS, data, 5, 0);

        // odczekanie na zakoczenie transakcji
        while (I2cMaster.status != I2CM_STATUS_READY);

        I2C_lib_MasterWriteRead(&I2cMaster, SLAVE_ADDRESS, data, 0, 5);
        while (I2cMaster.status != I2CM_STATUS_READY);

        I2C_lib_MasterWriteRead(&I2cMaster, EEPROM_ADDRESS, data, 2, 1);
        while (I2cMaster.status != I2CM_STATUS_READY);

    }
}

__interrupt void i2cAISR(void)
{
    I2C_lib_InterruptHandler(&I2cMaster);
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP8);
}
// End of File


