/*
 * main.c
 *
 *  Created on: 2018321
 *      Author: njc
 */

#include<F28x_Project.h>
#include<math.h>
#include"cla_inverter_shared.h"

//Ԥֵ
#define fswitch 200000 //忪Ƶ

//
void InitInvtPwmCfg(void);
void EPwmDutyUpdate(float inputdata);
void InitAdcCfg(void);
void InitClaMemCfg(void);
void InitClaCfg(void);

//CLAжϺ
__interrupt void claIsr1(void);
__interrupt void claIsr2(void);
__interrupt void claIsr3(void);
__interrupt void claIsr4(void);
__interrupt void claIsr5(void);
__interrupt void claIsr6(void);
__interrupt void claIsr7(void);
__interrupt void claIsr8(void);

//
#pragma DATA_SECTION(sinref,"CpuToCla1MsgRAM");
float sinref;

#pragma DATA_SECTION(uo,"Cla1ToCpuMsgRAM");
float uo;
#pragma DATA_SECTION(il,"Cla1ToCpuMsgRAM");
float il;
#pragma DATA_SECTION(io,"Cla1ToCpuMsgRAM");
float io;

float fsin = 1000.0;//Ƶ
int sinnum;
float sincont = 0;//ÿҵҼֵ
float phi;//λֵΪ2piֵ
float sinposamp=1.0,sinnegamp=0.3;//ֵܷҸֵܷ
float tempsindata;//м
float sinoutdata;

void main()
{
    EALLOW;
    ClkCfgRegs.PERCLKDIVSEL.bit.EPWMCLKDIV = 0;//޸pwmʱӷƵǿֱ
    EDIS;
    //ʼϵͳ
    InitSysCtrl();

    //PIECLAжϳʼ
    DINT;
    InitPieCtrl();
    IFR = 0x0000;
    IER = 0x0000;
    InitPieVectTable();

    InitClaMemCfg();
    InitClaCfg();
    EINT;
    ERTM;

    //EPWMʼ
    //

    EALLOW;
    CpuSysRegs.PCLKCR2.bit.EPWM6 = 1;//ʼpwmʱ
    CpuSysRegs.PCLKCR2.bit.EPWM2 = 1;
    EDIS;

    InitGpio();//ʼIO
    InitEPwm6Gpio();
    InitEPwm2Gpio();

    EALLOW;
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 0;
    EDIS;
    InitInvtPwmCfg();//epwm
    EALLOW;
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;
    EDIS;

    //ADCʼ
    InitAdcCfg();
    CalAdcINL(ADC_ADCA);

    EPwmDutyUpdate(0.5);
    while(1);

}
//ʼpwm
void InitInvtPwmCfg(void)
{

    //λͬ·
    EPwm1Regs.TBCTL.bit.CTRMODE = 2;
    EPwm1Regs.TBPRD = 500;
    EPwm1Regs.TBCTL.bit.PHSEN = 0;
    EPwm1Regs.TBPHS.bit.TBPHS = 0x0000;
    EPwm1Regs.TBCTL.bit.HSPCLKDIV = 0;
    EPwm1Regs.TBCTL.bit.CLKDIV = 0;
    EPwm1Regs.TBCTL.bit.SYNCOSEL = 1;
    EALLOW;
    SyncSocRegs.SYNCSELECT.bit.EPWM4SYNCIN = 0;
    EDIS;
    EPwm4Regs.TBCTL.bit.CTRMODE = 2;
    EPwm4Regs.TBPRD = 500;
    EPwm4Regs.TBCTL.bit.PHSEN = 1;
    EPwm4Regs.TBCTL.bit.PHSDIR = 1;//λͬΪ
    EPwm4Regs.TBPHS.bit.TBPHS = 0x0000;
    EPwm4Regs.TBCTL.bit.HSPCLKDIV = 0;
    EPwm4Regs.TBCTL.bit.CLKDIV = 0;
    EPwm4Regs.TBCTL.bit.SYNCOSEL = 0;
    EPwm5Regs.TBCTL.bit.CTRMODE = 2;
    EPwm5Regs.TBPRD = 500;
    EPwm5Regs.TBCTL.bit.PHSEN = 1;
    EPwm5Regs.TBCTL.bit.PHSDIR = 1;
    EPwm5Regs.TBPHS.bit.TBPHS = 0x0000;
    EPwm5Regs.TBCTL.bit.HSPCLKDIV = 0;
    EPwm5Regs.TBCTL.bit.CLKDIV = 0;
    EPwm5Regs.TBCTL.bit.SYNCOSEL = 0;

    //ȫĹpwm
    EPwm2Regs.TBCTL.bit.CTRMODE = 2;//ģʽ
    EPwm2Regs.TBPRD = 500;//200khzƵ

    EPwm2Regs.TBCTL.bit.PHSDIR = 1;
    EPwm2Regs.TBCTL.bit.PHSEN = 1;
    EPwm2Regs.TBPHS.bit.TBPHS = 0x0000;
    EPwm2Regs.TBCTR = 0x0000;
    EPwm2Regs.TBCTL.bit.HSPCLKDIV = 0;
    EPwm2Regs.TBCTL.bit.CLKDIV = 0;

    EPwm2Regs.CMPCTL.bit.SHDWAMODE = 0;
    EPwm2Regs.CMPCTL.bit.LOADAMODE = 0;

    EPwm2Regs.CMPA.bit.CMPA = 250;
    EPwm2Regs.AQCTLA.bit.CAD = 0x2;//ø
    EPwm2Regs.AQCTLA.bit.CAU = 0x1;//õ
    EPwm2Regs.AQCTLA.bit.ZRO = 0x2;

    EPwm2Regs.DBCTL.bit.IN_MODE = 0;
    EPwm2Regs.DBCTL.bit.SHDWDBFEDMODE = 0x1;
    EPwm2Regs.DBCTL.bit.SHDWDBREDMODE = 0x1;
    EPwm2Regs.DBCTL.bit.SHDWDBFEDMODE = 0x1;
    EPwm2Regs.DBCTL.bit.SHDWDBREDMODE = 0x1;
    EPwm2Regs.DBCTL.bit.OUT_MODE = 0x3;
    EPwm2Regs.DBCTL.bit.POLSEL = 0x2;
    EPwm2Regs.DBFED.bit.DBFED = 40;//ʱ200ns
    EPwm2Regs.DBRED.bit.DBRED = 40;

    EPwm2Regs.TBCTL.bit.SYNCOSEL = 0;//ͬźͬź

    EPwm6Regs.TBCTL.bit.CTRMODE = 2;//ģʽ
    EPwm6Regs.TBPRD = 500;//200khzƵ

    EPwm6Regs.TBCTL.bit.PHSDIR = 1;
    EPwm6Regs.TBCTL.bit.PHSEN = 1;
    EPwm6Regs.TBPHS.bit.TBPHS = 0x0000;
    EPwm6Regs.TBCTR = 0x0000;
    EPwm6Regs.TBCTL.bit.HSPCLKDIV = 0;
    EPwm6Regs.TBCTL.bit.CLKDIV = 0;

    EPwm6Regs.CMPCTL.bit.SHDWAMODE = 0;
    EPwm6Regs.CMPCTL.bit.LOADAMODE = 0;

    EPwm6Regs.CMPA.bit.CMPA = 380;
    EPwm6Regs.AQCTLA.bit.CAD = 0x2;//ø
    EPwm6Regs.AQCTLA.bit.CAU = 0x1;//õ
    EPwm6Regs.AQCTLA.bit.ZRO = 0x2;

    EPwm6Regs.DBCTL.bit.IN_MODE = 0;
    EPwm6Regs.DBCTL.bit.SHDWDBFEDMODE = 0x1;
    EPwm6Regs.DBCTL.bit.SHDWDBREDMODE = 0x1;
    EPwm6Regs.DBCTL.bit.SHDWDBFEDMODE = 0x1;
    EPwm6Regs.DBCTL.bit.SHDWDBREDMODE = 0x1;
    EPwm6Regs.DBCTL.bit.OUT_MODE = 0x3;
    EPwm6Regs.DBCTL.bit.POLSEL = 0x2;
    EPwm6Regs.DBFED.bit.DBFED = 40;
    EPwm6Regs.DBRED.bit.DBRED = 40;

    EPwm6Regs.ETSEL.bit.SOCAEN = 0x1;
    EPwm6Regs.ETSEL.bit.SOCASEL = 0x1;//0ʱռձĲ
    EPwm6Regs.ETPS.bit.SOCAPRD = 0x1;

    EPwm6Regs.TBCTL.bit.SYNCOSEL = 0;//ͬźֱӲͬź
}


//PWMģռձȸº
//TMUʱ˺Ҫ39cyc
//ʹFPUʱ˺Ҫ39cyc
void EPwmDutyUpdate(float inputdata)
{
    //ռձȼм
    float dutymiddata1,dutymiddata2;
    float halfinputdata;
    halfinputdata = 0.5 * inputdata;
    dutymiddata1 = halfinputdata + 0.5;
    dutymiddata2 = 0.5 - halfinputdata;
    EPwm6Regs.CMPA.bit.CMPA = (int)(dutymiddata2*500);
    EPwm2Regs.CMPA.bit.CMPA = (int)(dutymiddata1*500);
}

//ADCʼ
//12λģʽADCA0-VOADCA1-ILADCA2-IO˳
void InitAdcCfg(void)
{
    EALLOW;
    AdcaRegs.ADCCTL2.bit.PRESCALE = 0x8;//40MHZ
    AdcaRegs.ADCCTL2.bit.SIGNALMODE = 0;
    AdcaRegs.ADCCTL2.bit.RESOLUTION = 0;
    AdcaRegs.ADCSOC0CTL.bit.TRIGSEL = 0x0f;
    AdcaRegs.ADCSOC0CTL.bit.CHSEL = 0;
    AdcaRegs.ADCSOC0CTL.bit.ACQPS = 19;
    AdcaRegs.ADCSOC1CTL.bit.TRIGSEL = 0x0f;
    AdcaRegs.ADCSOC1CTL.bit.CHSEL = 1;
    AdcaRegs.ADCSOC1CTL.bit.ACQPS = 19;
    AdcaRegs.ADCSOC2CTL.bit.TRIGSEL = 0x0f;
    AdcaRegs.ADCSOC2CTL.bit.CHSEL = 2;
    AdcaRegs.ADCSOC2CTL.bit.ACQPS = 19;
    // ṩжź
    AdcaRegs.ADCSOC3CTL.bit.TRIGSEL = 0x0f;
    AdcaRegs.ADCSOC3CTL.bit.CHSEL = 3;
    AdcaRegs.ADCSOC3CTL.bit.ACQPS = 1;

    AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 0;//ֽж ʹCLAʱ
    AdcaRegs.ADCINTSEL1N2.bit.INT1CONT = 0;
    AdcaRegs.ADCINTSEL1N2.bit.INT1E = 1;
    AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = 0;
    AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;

    //ж
    AdcaRegs.ADCINTSEL1N2.bit.INT2CONT = 0;
    AdcaRegs.ADCINTSEL1N2.bit.INT2E = 1;
    AdcaRegs.ADCINTSEL1N2.bit.INT2SEL = 3;
    AdcaRegs.ADCINTFLGCLR.bit.ADCINT2 = 1;
    AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 0x1;
    DELAY_US(1000);

    EDIS;
}

//CLAڴַʼ
void InitClaMemCfg(void)
{
    extern uint32_t Cla1funcsRunStart, Cla1funcsLoadStart, Cla1funcsLoadSize;
    EALLOW;

    Cla1Regs.MIER.all = 0x0;
    MemCfgRegs.MSGxINIT.bit.INIT_CLA1TOCPU = 1;
    while(MemCfgRegs.MSGxINITDONE.bit.INITDONE_CLA1TOCPU!=1){};

    MemCfgRegs.MSGxINIT.bit.INIT_CPUTOCLA1 = 1;
    while(MemCfgRegs.MSGxINITDONE.bit.INITDONE_CPUTOCLA1!=1){};

    MemCfgRegs.LSxMSEL.bit.MSEL_LS5 = 1;
    MemCfgRegs.LSxCLAPGM.bit.CLAPGM_LS5 = 1;
    MemCfgRegs.LSxMSEL.bit.MSEL_LS4 = 1;
    MemCfgRegs.LSxCLAPGM.bit.CLAPGM_LS4 = 1;

    MemCfgRegs.LSxMSEL.bit.MSEL_LS1 = 1;
    MemCfgRegs.LSxCLAPGM.bit.CLAPGM_LS1 = 0;
    MemCfgRegs.LSxMSEL.bit.MSEL_LS0 = 1;
    MemCfgRegs.LSxCLAPGM.bit.CLAPGM_LS0 = 0;
    EDIS;
}

//CLAóʼ
void InitClaCfg(void)
{
    EALLOW;
    Cla1Regs.MIER.all = 0x0;
    CpuSysRegs.PCLKCR0.bit.CLA1 = 1;
    Cla1Regs.MCTL.bit.IACKE = 1;

    Cla1Regs.MVECT1 = (uint16_t)(&claTask1);
    Cla1Regs.MVECT2 = (uint16_t)(&claTask2);
    Cla1Regs.MVECT3 = (uint16_t)(&claTask3);
    Cla1Regs.MVECT4 = (uint16_t)(&claTask4);
    Cla1Regs.MVECT5 = (uint16_t)(&claTask5);
    Cla1Regs.MVECT6 = (uint16_t)(&claTask6);
    Cla1Regs.MVECT7 = (uint16_t)(&claTask7);
    Cla1Regs.MVECT8 = (uint16_t)(&claTask8);

    DmaClaSrcSelRegs.CLA1TASKSRCSEL1.bit.TASK1 = 1;//ADCINT1
    DmaClaSrcSelRegs.CLA1TASKSRCSEL1.bit.TASK2 = 0;
        //Init Pie
    PieVectTable.CLA1_1_INT = &claIsr1;
    PieVectTable.CLA1_2_INT = &claIsr2;
    PieVectTable.CLA1_3_INT = &claIsr3;
    PieVectTable.CLA1_4_INT = &claIsr4;
    PieVectTable.CLA1_5_INT = &claIsr5;
    PieVectTable.CLA1_6_INT = &claIsr6;
    PieVectTable.CLA1_7_INT = &claIsr7;
    PieVectTable.CLA1_8_INT = &claIsr8;

    PieCtrlRegs.PIEIER11.bit.INTx1 = 1; //enable cla pie
    PieCtrlRegs.PIEIER11.bit.INTx2 = 1;
    Cla1Regs.MIER.bit.INT1 = 1;
    Cla1Regs.MIER.bit.INT2 = 1;
    IER |= (M_INT11);
    EDIS;
}


__interrupt void claIsr1(void)
{
    sinnum = (int)(fswitch/fsin)-1;
    tempsindata = sincont/sinnum + phi;
    if(tempsindata>1.0)
    {
        sincont = sincont - sinnum - 1;
        tempsindata = sincont/sinnum + phi;
    }
    if(tempsindata<0.0)
    {
        sincont = sincont + sinnum + 1;
        tempsindata = sincont/sinnum + phi;
    }

    sinoutdata = __sinpuf32(tempsindata);
    if(sinoutdata>=0.0)
        sinref = sinoutdata * sinposamp;
    if(sinoutdata<0.0)
        sinref = sinoutdata * sinnegamp;
    sincont = sincont + 1;

    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP11;
    AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;
    asm("  IACK  #0x0002");

}

__interrupt void claIsr2(void)
{
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP11;
    AdcaRegs.ADCINTFLGCLR.bit.ADCINT2 = 1;
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}

__interrupt void claIsr3(void)
{
    asm(" ESTOP0");
}

__interrupt void claIsr4(void)
{
    asm(" ESTOP0");
}

__interrupt void claIsr5(void)
{
    asm(" ESTOP0");
}

__interrupt void claIsr6(void)
{
    asm(" ESTOP0");
}

__interrupt void claIsr7(void)
{
    asm(" ESTOP0");
}

__interrupt void claIsr8(void)
{
    asm(" ESTOP0");
}
