//==============================================================================================//
//              LINKER FILE                                                                  	//
//=============================================================================================c//

MEMORY
{
	PAGE 0 :
		
		BEGIN         	: origin = 0x000000, length = 0x000002		/* Part of M0, BEGIN is used for the "boot to SARAM" bootloader mode */
		RAMM0        	: origin = 0x000122, length = 0x0002DE		/* M0 is divided to BEGIN + BOOT_RSVD + RAMM0 */
		
		RAMD0        	: origin = 0x00B000, length = 0x000800
		RAMD1           : origin = 0x00B800, length = 0x000800

		RAMGS_10_15		: origin = 0x016000, length = 0x006000

		RAMLS0       	: origin = 0x008000, length = 0x000800
		RAMLS1       	: origin = 0x008800, length = 0x000800
		RAMLS2      	: origin = 0x009000, length = 0x000800
		RAMLS3      	: origin = 0x009800, length = 0x000800
		RAMLS4      	: origin = 0x00A000, length = 0x000800
		RAMLS5      	: origin = 0x00A800, length = 0x000800
/*
		RAMLS_0_5		: origin = 0x008000, length = 0x003000
*/
		RESET        	: origin = 0x3FFFC0, length = 0x000002		/* Part of VECTORS at 0x003FFFC0-0x003FFFFF */

		FLASHA        	: origin = 0x080000, length = 0x002000
		FLASHB        	: origin = 0x082000, length = 0x002000
		FLASHC        	: origin = 0x084000, length = 0x002000
		FLASHD        	: origin = 0x086000, length = 0x002000
		FLASHE       	: origin = 0x088000, length = 0x008000
		FLASHF        	: origin = 0x090000, length = 0x008000
		FLASHG         	: origin = 0x098000, length = 0x008000
		FLASHH         	: origin = 0x0A0000, length = 0x008000
		FLASHI        	: origin = 0x0A8000, length = 0x008000
		FLASHJ        	: origin = 0x0B0000, length = 0x008000
		FLASHK        	: origin = 0x0B8000, length = 0x002000
		FLASHL        	: origin = 0x0BA000, length = 0x002000
		FLASHM         	: origin = 0x0BC000, length = 0x002000
		FLASHN        	: origin = 0x0BE000, length = 0x002000

	PAGE 1 :

		BOOT_RSVD       : origin = 0x000002, length = 0x000120		/* Part of M0, BOOT rom will use this for stack */
		RAMM1           : origin = 0x000400, length = 0x000400  	/* on-chip RAM block M1 */
/*
		RAMGS0      	: origin = 0x00C000, length = 0x001000
		RAMGS1      	: origin = 0x00D000, length = 0x001000
		RAMGS2      	: origin = 0x00E000, length = 0x001000
		RAMGS3      	: origin = 0x00F000, length = 0x001000
		RAMGS4      	: origin = 0x010000, length = 0x001000
		RAMGS5      	: origin = 0x011000, length = 0x001000
		RAMGS6      	: origin = 0x012000, length = 0x001000
		RAMGS7      	: origin = 0x013000, length = 0x001000
		RAMGS8      	: origin = 0x014000, length = 0x001000
		RAMGS9      	: origin = 0x015000, length = 0x001000
		RAMGS10     	: origin = 0x016000, length = 0x001000
		RAMGS11     	: origin = 0x017000, length = 0x001000
		RAMGS12     	: origin = 0x018000, length = 0x001000
		RAMGS13     	: origin = 0x019000, length = 0x001000
		RAMGS14     	: origin = 0x01A000, length = 0x001000
		RAMGS15     	: origin = 0x01B000, length = 0x001000
*/
		RAMGS_0_9		: origin = 0x00C000, length = 0x00A000
/*
		CPU2TOCPU1RAM   : origin = 0x03F800, length = 0x000400
		CPU1TOCPU2RAM	: origin = 0x03FC00, length = 0x000400

		CANA_MSG_RAM  	: origin = 0x049000, length = 0x000800
		CANB_MSG_RAM   	: origin = 0x04B000, length = 0x000800
*/
}


SECTIONS
{
	codestart		: > BEGIN,    		PAGE = 0
	ramfuncs		: > RAMD1,			PAGE = 0

	.text			: > RAMGS_10_15,	PAGE = 0
	.cinit			: > RAMLS0,			PAGE = 0
	.pinit			: > RAMLS1,			PAGE = 0
	.switch			: > RAMLS2,			PAGE = 0
/*
	.cinit			: > RAMM0,			PAGE = 0
	.pinit			: > RAMM0,			PAGE = 0
	.switch			: > RAMD0,			PAGE = 0
*/
	.reset			: > RESET,			PAGE = 0,	TYPE = DSECT	/* not used */

	.stack      	: > RAMM1,     		PAGE = 1
	.ebss			: > RAMGS_0_9,		PAGE = 1
	.econst       	: > RAMGS_0_9,   	PAGE = 1
	.esysmem     	: > RAMGS_0_9,    	PAGE = 1

#ifdef __TI_COMPILER_VERSION__
	#if __TI_COMPILER_VERSION__ >= 15009000
//		.TI.ramfunc : {} > RAMM0,      	PAGE = 0
		.TI.ramfunc : {} > RAMD1,   	PAGE = 0
	#endif
#endif
}

//==============================================================================================//
//              END OF FILE                                                                   	//
//=============================================================================================c//
