//==============================================================================================//
//              AC3PH.C                                                                         //
//=============================================================================================c//

#ifndef ac3ph_C_
#define ac3ph_C_

#include "ac3ph.h"

//==============================================================================================//
//              PHASE-LOCKED LOOP                                                               //
//=============================================================================================c//

_Bool AC3PH_pllInit(volatile AC3PH_pll_S *pll)
{
    // Check PLL parameters
    if (pll->WN==0 || pll->ZETA==0 || pll->NORM==0 || pll->W_NOM==0 || (pll->Q_MAX<=0.0f || pll->Q_MAX>=1.0f) || pll->TMR==0 || pll->TS==0)
        return ERR_SET;

    // Reset PLL structure
    AC3PH_pllReset(pll);

    // PI controller parameters
    pll->pi_w_err = (CTRL_pi_S)
    {
        .DTYPE = CTRL_DTYPE_TUSTIN,
        .KP  = 2.0f*pll->ZETA*pll->WN,
        .TI  = 2.0f*pll->ZETA/pll->WN,
        .KI  = 0,
        .TS  = pll->TS,
        .ULO = -0.10f*pll->W_NOM,
        .UHI = +0.10f*pll->W_NOM
    };

    // Initialize PI controller
    return CTRL_piInit(&pll->pi_w_err);
}

void AC3PH_pllReset(volatile AC3PH_pll_S *pll)
{
    // Reset estimated phase and frequency
    pll->phase.theta = 0.0f;
    pll->phase._sin  = 0.0f;
    pll->phase._cos  = 1.0f;
    pll->w_est = pll->W_NOM;

    // Reset in-lock software timer and flag
    pll->timer = 0;
    pll->in_lock = AC3PH_PLL_INLOCK_NO;

    // Reset PI controller
    CTRL_piReset(&pll->pi_w_err);
}

#endif /* AC3PH_C_ */

//==============================================================================================//
//              END OF FILE                                                                     //
//=============================================================================================c//
