//==============================================================================================//
//              ERROR.H                                                                         //
//=============================================================================================c//

#ifndef ERROR_H_
#define ERROR_H_

#include "utils.h"

//==============================================================================================//
//              ERROR STRUCTURE DEFINITION                                                      //
//=============================================================================================c//

union ERR_CFG
{
    uint32_t all;
    struct
    {
        uint32_t                    :20;
        _Bool GLOBAL                :1;
        _Bool CRITICAL              :1;
        _Bool FPGA                  :1;
        _Bool UNEXPECTED_STATE      :1;
        _Bool UNEXPECTED_SUBSTATE   :1;
        _Bool UNEXPECTED_SWITCH     :1;
        _Bool PHASE_ORDER_GRID_CODE :1;
        _Bool PHASE_ORDER_SEC_CODE  :1;
        _Bool PHASE_ORDER_GRID      :1;
        _Bool PHASE_ORDER_SEC       :1;
        _Bool SVM_TYPE              :1;
        _Bool SVM_SECTOR            :1;
    } bit;
};

union ERR_INIT
{
    uint32_t all;
    struct
    {
        _Bool PI_V_DC               :1;
        _Bool PI_I_INV_D            :1;
        _Bool PI_I_INV_Q            :1;
        _Bool MAV_V_GRID_D          :1;
        _Bool MAV_V_GRID_Q          :1;
        _Bool MAV_V_SEC_D           :1;
        _Bool MAV_V_SEC_Q           :1;
        _Bool BW2_V_GRID_D          :1;
        _Bool BW2_V_GRID_Q          :1;
        _Bool BW2_V_SEC_D           :1;
        _Bool BW2_V_SEC_Q           :1;
        _Bool STAT_V_GRID_AN        :1;
        _Bool STAT_V_GRID_BN        :1;
        _Bool STAT_V_GRID_CN        :1;
        _Bool STAT_V_SEC_AB         :1;
        _Bool STAT_V_SEC_BC         :1;
        _Bool STAT_V_SEC_CA         :1;
        _Bool STAT_I_SEC_AN         :1;
        _Bool STAT_I_SEC_BN         :1;
        _Bool STAT_I_SEC_CN         :1;
        _Bool PLL_GRID              :1;
        _Bool PLL_SEC               :1;
        _Bool PI_V_OUT_TOP          :1;
        _Bool PI_I_OUT              :1;
        _Bool PI_V_OUT              :1;
        _Bool PI_I_L1               :1;
        _Bool PI_I_L2               :1;
        _Bool RLIM_V_OUT_REF        :1;
        _Bool RLIM_I_OUT_REF        :1;
        _Bool STAT_I_L1             :1;
        _Bool STAT_I_L2             :1;
        _Bool STAT_I_OUT            :1;
    } bit;
};

union ERR_TMO
{
    uint32_t all;
    struct
    {
        uint32_t                    :20;
        _Bool ADC_EPWM2             :1;
        _Bool ADC_EPWM4             :1;
        _Bool DISCHARGE_DC_LINK     :1;
        _Bool DISCHARGE_OUTPUT      :1;
        _Bool PRECHARGE_PASSIVE_I   :1;
        _Bool PRECHARGE_PASSIVE_II  :1;
        _Bool PRECHARGE_ACTIVE      :1;
        _Bool SOFT_START            :1;
        _Bool PHASE_ORDER_GRID      :1;
        _Bool PHASE_ORDER_SEC       :1;
        _Bool PLL_LOCK_GRID         :1;
        _Bool PLL_LOCK_SEC          :1;
    } bit;
};

union ERR_MEAS
{
    uint32_t all;
    struct
    {
        uint32_t                    :10;
        _Bool V_GRID_AN             :1;
        _Bool V_GRID_BN             :1;
        _Bool V_GRID_CN             :1;
        _Bool V_SEC_AB              :1;
        _Bool V_SEC_BC              :1;
        _Bool V_SEC_CA              :1;
        _Bool I_SEC_AN              :1;
        _Bool I_SEC_BN              :1;
        _Bool I_SEC_CN              :1;
        _Bool V_DC                  :1;
        _Bool V_OUT                 :1;
        _Bool V_BAT                 :1;
        _Bool V_REM                 :1;
        _Bool I_L1                  :1;
        _Bool I_L2                  :1;
        _Bool I_OUT                 :1;
        _Bool TEMP_AC               :1;
        _Bool TEMP_DC               :1;
        _Bool FREQ_GRID             :1;
        _Bool FREQ_SEC              :1;
        _Bool V_OUT_REF             :1;
        _Bool I_OUT_REF             :1;
    } bit;
};

union ERR_STAT
{
    uint32_t all;
    struct
    {
        uint32_t                    :8;
        _Bool MEAN_V_GRID_AN        :1;
        _Bool MEAN_V_GRID_BN        :1;
        _Bool MEAN_V_GRID_CN        :1;
        _Bool MEAN_V_SEC_AB         :1;
        _Bool MEAN_V_SEC_BC         :1;
        _Bool MEAN_V_SEC_CA         :1;
        _Bool MEAN_I_SEC_AN         :1;
        _Bool MEAN_I_SEC_BN         :1;
        _Bool MEAN_I_SEC_CN         :1;
        _Bool MEAN_I_L1             :1;
        _Bool MEAN_I_L2             :1;
        _Bool MEAN_I_OUT            :1;
        _Bool STD_V_GRID_AN         :1;
        _Bool STD_V_GRID_BN         :1;
        _Bool STD_V_GRID_CN         :1;
        _Bool STD_V_SEC_AB          :1;
        _Bool STD_V_SEC_BC          :1;
        _Bool STD_V_SEC_CA          :1;
        _Bool STD_I_SEC_AN          :1;
        _Bool STD_I_SEC_BN          :1;
        _Bool STD_I_SEC_CN          :1;
        _Bool STD_I_L1              :1;
        _Bool STD_I_L2              :1;
        _Bool STD_I_OUT             :1;
    } bit;
};

typedef struct ERR_pack_STRUCT
{
    union ERR_CFG  CONFIG;
    union ERR_INIT INIT;
    union ERR_TMO  TIMEOUT;
    union ERR_MEAS MEAS_LOW;
    union ERR_MEAS MEAS_HIGH;
    union ERR_STAT STAT_LOW;
    union ERR_STAT STAT_HIGH;
} ERR_pack_S;

//==============================================================================================//
//              FUNCTION-LIKE MACROS                                                            //
//=============================================================================================c//

//
// ERROR SET AND CLEAR FLAGS
//

#define ERR_CLEAR       0
#define ERR_SET         1

#define ERR_REGISTER_GET(_REG)      err->_REG.all
#define ERR_FIELD_GET(_REG, _FLD)   err->_REG.bit._FLD

// TODO
#define ERR_FIELD_SET(_REG, _FLD)               \
    ERR_FIELD_GET(_REG, _FLD) = ERR_SET

// TODO
#define ERR_CHECK_LIMITS(VAR, LIM, REG, FLD)                            \
    if (VAR < LIM##_LOW )   { ERR_FIELD_SET(REG##_LOW,  FLD); }         \
    if (VAR > LIM##_HIGH)   { ERR_FIELD_SET(REG##_HIGH, FLD); }

// TODO
#define ERR_CHECK_OFFSET(VAR, LIM, FLD)                                 \
    if (VAR < LIM##_LOW )   { ERR_FIELD_SET(STAT_LOW,  MEAN_##FLD); }   \
    if (VAR > LIM##_HIGH)   { ERR_FIELD_SET(STAT_HIGH, MEAN_##FLD); }

// TODO
#define ERR_CHECK_RMS(VAR, LIM, FLD)                                    \
    if (VAR < LIM##_LOW )   { ERR_FIELD_SET(STAT_LOW,  STD_##FLD); }    \
    if (VAR > LIM##_HIGH)   { ERR_FIELD_SET(STAT_HIGH, STD_##FLD); }

#endif /* ERROR_H_ */

//==============================================================================================//
//              END OF FILE                                                                     //
//=============================================================================================c//
