//==============================================================================================//
//              HANDLER.C                                                                       //
//=============================================================================================c//

#ifndef handler_C_
#define handler_C_

#include "handler.h"

//==============================================================================================//
//              HANDLER DEFINITION AND INITIALIZATION                                           //
//=============================================================================================c//

volatile HDLR_pack_S HDLR_PACK =
{
//---------- MEASUREMENT PACKS -----------------------------------------------------------------//

    .MEAS = (SYS_meas_S)
    {
        .v_grid_abcn = (AC3PH_abcn_S)
        {
            .an = 0.0f,
            .bn = 0.0f,
            .cn = 0.0f,
        },

        .v_sec_abc = (AC3PH_abc_S)
        {
            .ab = 0.0f,
            .bc = 0.0f,
            .ca = 0.0f,
        },

        .i_sec_abcn = (AC3PH_abcn_S)
        {
            .an = 0.0f,
            .bn = 0.0f,
            .cn = 0.0f,
        },

        .v_dc  = 0.0f,
        .v_out = 0.0f,
        .v_bat = 0.0f,
        .v_rem = 0.0f,

        .i_L1  = 0.0f,
        .i_L2  = 0.0f,
        .i_out = 0.0f,

        .temp_ac = 0.0f,
        .temp_dc = 0.0f,
    },

    .RAW = (SYS_meas_S)
    {
        .v_grid_abcn = (AC3PH_abcn_S)
        {
            .an = 0.0f,
            .bn = 0.0f,
            .cn = 0.0f,
        },

        .v_sec_abc = (AC3PH_abc_S)
        {
            .ab = 0.0f,
            .bc = 0.0f,
            .ca = 0.0f,
        },

        .i_sec_abcn = (AC3PH_abcn_S)
        {
            .an = 0.0f,
            .bn = 0.0f,
            .cn = 0.0f,
        },

        .v_dc  = 0.0f,
        .v_out = 0.0f,
        .v_bat = 0.0f,
        .v_rem = 0.0f,

        .i_L1  = 0.0f,
        .i_L2  = 0.0f,
        .i_out = 0.0f,

        .temp_ac = 2101.0f, // 20 C
        .temp_dc = 2101.0f, // 20 C
    },

//---------- DUTY-CYCLE PACKS ------------------------------------------------------------------//

    .INV_DUTY = (SYS_pwm3_S)
    {
        .d1 = 0.0f,
        .d2 = 0.0f,
        .d3 = 0.0f,
    },

    .BUB_DUTY = (SYS_pwm2_S)
    {
        .d1 = 0.0f,
        .d2 = 0.0f,
    },

//---------- INVERTER PACK ---------------------------------------------------------------------//

    .INV_PACK = (INV_pack_S)
    {
        // STATE MACHINE

        .state_machine = (CTRL_sm_S)
        {
            .command    = CTRL_SM_COMMAND_STOP,
            .mode       = CTRL_SM_MODE_STOPPING,
            .state      = CTRL_SM_STATE_RESET,
            .substate   = 0,
            .timer      = 1,
            .flag_1     = INV_ISR_COMMAND_DEFAULT_STATE,
            .flag_2     = CONST_MEAS_CALIBRATED_NO,
        },

        // COMMAND INTERFACE

        .usr_command    = CTRL_SM_COMMAND_STOP,
        .isr_command    = INV_ISR_COMMAND_DEFAULT_STATE,

        // SPACE-VECTOR MODULATION TYPE

        .svm_type = INV_SVM_SYMMETRICAL,

        // RMS MEASUREMENTS

        .v_grid_rms = (AC3PH_abcn_S)
        {
            .an = 0.0f,
            .bn = 0.0f,
            .cn = 0.0f,
        },

        .v_sec_rms = (AC3PH_abc_S)
        {
            .ab = 0.0f,
            .bc = 0.0f,
            .ca = 0.0f,
        },

        // PHASE ORDER DETECTION

        .v_phase_order = (AC3PH_abcn_S)
        {
            .an = 0.0f,
            .bn = 0.0f,
            .cn = 0.0f,
        },

        .sector1 = 0,
        .sector2 = 0,

        // DIGITAL PI CONTROLLERS

        .pi_v_dc = (CTRL_pi_S)
        {
            .DTYPE = CTRL_DTYPE_TUSTIN,
            .KP  = CONST_PI_V_DC_KP,
            .TI  = CONST_PI_V_DC_TI,
            .TS  = CONST_INV_TS,
            .ULO = CONST_PI_V_DC_ULO,
            .UHI = CONST_PI_V_DC_UHI,
        },

        .pi_i_inv_d = (CTRL_pi_S)
        {
            .DTYPE = CTRL_DTYPE_TUSTIN,
            .KP  = CONST_PI_I_INV_DQ_KP,
            .TI  = CONST_PI_I_INV_DQ_TI,
            .TS  = CONST_INV_TS,
            .ULO = CONST_PI_I_INV_DQ_ULO,
            .UHI = CONST_PI_I_INV_DQ_UHI,
        },

        .pi_i_inv_q = (CTRL_pi_S)
        {
            .DTYPE = CTRL_DTYPE_TUSTIN,
            .KP  = CONST_PI_I_INV_DQ_KP,
            .TI  = CONST_PI_I_INV_DQ_TI,
            .TS  = CONST_INV_TS,
            .ULO = CONST_PI_I_INV_DQ_ULO,
            .UHI = CONST_PI_I_INV_DQ_UHI,
        },

#ifdef CONST_MAV_BUFFER_SIZE
        // MOVING AVERAGE FILTER

        .mav_v_grid_d.bufferSize = CONST_MAV_BUFFER_SIZE,
        .mav_v_grid_q.bufferSize = CONST_MAV_BUFFER_SIZE,
        .mav_v_sec_d .bufferSize = CONST_MAV_BUFFER_SIZE,
        .mav_v_sec_q .bufferSize = CONST_MAV_BUFFER_SIZE,
#else
        // SECOND-ORDER BUTTERWORTH FILTER

        .bw2_v_grid_d = (DSP_bw2_S)
        {
            .DTYPE = DSP_DTYPE_TUSTIN,
            .K  = CONST_BW2_K,
            .WC = CONST_BW2_WC,
            .TS = CONST_INV_TS,
        },

        .bw2_v_grid_q = (DSP_bw2_S)
        {
            .DTYPE = DSP_DTYPE_TUSTIN,
            .K  = CONST_BW2_K,
            .WC = CONST_BW2_WC,
            .TS = CONST_INV_TS,
        },

        .bw2_v_sec_d = (DSP_bw2_S)
        {
            .DTYPE = DSP_DTYPE_TUSTIN,
            .K  = CONST_BW2_K,
            .WC = CONST_BW2_WC,
            .TS = CONST_INV_TS,
        },

        .bw2_v_sec_q = (DSP_bw2_S)
        {
            .DTYPE = DSP_DTYPE_TUSTIN,
            .K  = CONST_BW2_K,
            .WC = CONST_BW2_WC,
            .TS = CONST_INV_TS,
        },
#endif //#ifdef CONST_MAV_BUFFER_SIZE

        // CALIBRATION STRUCTURES

        .stat_v_grid_an.N = CONST_TMR_INV_CALIBRATION,
        .stat_v_grid_bn.N = CONST_TMR_INV_CALIBRATION,
        .stat_v_grid_cn.N = CONST_TMR_INV_CALIBRATION,
        .stat_v_sec_ab .N = CONST_TMR_INV_CALIBRATION,
        .stat_v_sec_bc .N = CONST_TMR_INV_CALIBRATION,
        .stat_v_sec_ca .N = CONST_TMR_INV_CALIBRATION,
        .stat_i_sec_an .N = CONST_TMR_INV_CALIBRATION,
        .stat_i_sec_bn .N = CONST_TMR_INV_CALIBRATION,
        .stat_i_sec_cn .N = CONST_TMR_INV_CALIBRATION,

        // PLL ALGORITHMS

        .pll_grid_abcn = (AC3PH_pll_S)
        {
            .WN     = CONST_PLL_WN,
            .ZETA   = CONST_PLL_ZETA,
            .NORM   = CONST_PLL_NORM_GRID,
            .W_NOM  = CONST_PLL_W_NOM,
            .Q_MAX  = CONST_PLL_Q_MAX,
            .TMR    = CONST_TMR_INV_PLL_LOCK,
            .TS     = CONST_INV_TS,
        },

        .pll_sec_abc = (AC3PH_pll_S)
        {
            .WN     = CONST_PLL_WN,
            .ZETA   = CONST_PLL_ZETA,
            .NORM   = CONST_PLL_NORM_SEC,
            .W_NOM  = CONST_PLL_W_NOM,
            .Q_MAX  = CONST_PLL_Q_MAX,
            .TMR    = CONST_TMR_INV_PLL_LOCK,
            .TS     = CONST_INV_TS,
        },

        // ALPHA-BETA FRAME VARIABLES

        .v_grid_ab = (AC3PH_ab_S)
        {
            .alpha = 0.0f,
            .beta  = 0.0f,
        },

        .v_sec_ab = (AC3PH_ab_S)
        {
            .alpha = 0.0f,
            .beta  = 0.0f,
        },

        .i_sec_ab = (AC3PH_ab_S)
        {
            .alpha = 0.0f,
            .beta  = 0.0f,
        },

        // DQ FRAME VARIABLES

        .v_grid_dq = (AC3PH_dq_S)
        {
            .d = 0.0f,
            .q = 0.0f,
        },

        .v_sec_dq = (AC3PH_dq_S)
        {
            .d = 0.0f,
            .q = 0.0f,
        },

        .i_sec_dq = (AC3PH_dq_S)
        {
            .d = 0.0f,
            .q = 0.0f,
        },

        // INVERTER CURRENT REFERENCE

        .i_inv_ref_dq = (AC3PH_dq_S)
        {
            .d = 0.0f,
            .q = 0.0f,
        },

        // STOPWATCH

        .stopwatch = (SWC_tictoc_S)
        {
            .PERIOD_US    = 0.0f,
            .TICKS_PER_US = 0.0f,
        },

        // POINTERS ARE INITIALIZED IN HDLR_init() FUNCTION

//      .raw = ,
//      .meas = ,
//      .duty = ,
//      .error = ,
//      .meas_cal = ,

    },

//---------- BUCK-BOOST PACK -------------------------------------------------------------------//

    .BUB_PACK = (BUB_pack_S)
    {
        // STATE MACHINE

        .state_machine = (CTRL_sm_S)
        {
            .command    = CTRL_SM_COMMAND_STOP,
            .mode       = CTRL_SM_MODE_STOPPING,
            .state      = CTRL_SM_STATE_RESET,
            .substate   = 0,
            .timer      = 1,
            .flag_1     = BUB_ISR_COMMAND_DEFAULT_STATE,
            .flag_2     = CONST_MEAS_CALIBRATED_NO,
        },

        // COMMAND INTERFACE

        .usr_command    = CTRL_SM_COMMAND_STOP,
        .isr_command    = INV_ISR_COMMAND_DEFAULT_STATE,

        // OUTPUT VOLTAGE REFERENCE

        .v_out_usr      = 0.0f,
        .v_out_ref      = 0.0f,
        .v_out_ref_rlim = 0.0f,

        // OUTPUT CURRENT REFERENCE

        .i_out_usr      = 0.0f,
        .i_out_ref      = 0.0f,
        .i_out_ref_rlim = 0.0f,

        // AUTOMATIC STARTUP VARIABLES

        .auto_err   = 0.0f,
        .auto_timer = 0,

        // DIGITAL PI CONTROLLERS

        .pi_v_out_top = (CTRL_pi_S)
        {
            .DTYPE = CTRL_DTYPE_TUSTIN,
            .KP  = CONST_PI_V_OUT_TOP_KP,
            .TI  = CONST_PI_V_OUT_TOP_TI,
            .TS  = CONST_BUB_TS,
            .ULO = 0.0f,    // TODO explain
            .UHI = 0.0f,    // TODO explain
        },

        .pi_i_out = (CTRL_pi_S)
        {
            .DTYPE = CTRL_DTYPE_TUSTIN,
            .KP  = CONST_PI_I_OUT_KP,
            .TI  = CONST_PI_I_OUT_TI,
            .TS  = CONST_BUB_TS,
            .ULO = CONST_PI_I_OUT_ULO,
            .UHI = CONST_PI_I_OUT_UHI,
        },

        .pi_v_out = (CTRL_pi_S)
        {
            .DTYPE = CTRL_DTYPE_TUSTIN,
            .KP  = CONST_PI_V_OUT_KP,
            .TI  = CONST_PI_V_OUT_TI,
            .TS  = CONST_BUB_TS,
            .ULO = CONST_PI_V_OUT_ULO,
            .UHI = CONST_PI_V_OUT_UHI,
        },

        .pi_i_L1 = (CTRL_pi_S)
        {
            .DTYPE = CTRL_DTYPE_TUSTIN,
            .KP  = CONST_PI_I_L_KP,
            .TI  = CONST_PI_I_L_TI,
            .TS  = CONST_BUB_TS,
            .ULO = CONST_PI_I_L_ULO,
            .UHI = CONST_PI_I_L_UHI,
        },

        .pi_i_L2 = (CTRL_pi_S)
        {
            .DTYPE = CTRL_DTYPE_TUSTIN,
            .KP  = CONST_PI_I_L_KP,
            .TI  = CONST_PI_I_L_TI,
            .TS  = CONST_BUB_TS,
            .ULO = CONST_PI_I_L_ULO,
            .UHI = CONST_PI_I_L_UHI,
        },

        // RATE-LIMITER FILTERS

        .rlim_v_out_ref = (DSP_rlim_S)
        {
            .RATE_POS   = CONST_RLIM_V_OUT_REF,
            .RATE_NEG   = CONST_RLIM_V_OUT_REF,
            .TS         = CONST_BUB_TS,
        },

        .rlim_i_out_ref = (DSP_rlim_S)
        {
            .RATE_POS   = CONST_RLIM_I_OUT_REF,
            .RATE_NEG   = CONST_RLIM_I_OUT_REF,
            .TS         = CONST_BUB_TS,
        },

        // CALIBRATION STRUCTURES

        .stat_i_L1 .N   = CONST_TMR_BUB_CALIBRATION,
        .stat_i_L2 .N   = CONST_TMR_BUB_CALIBRATION,
        .stat_i_out.N   = CONST_TMR_BUB_CALIBRATION,

        // STOPWATCH

        .stopwatch = (SWC_tictoc_S)
        {
            .PERIOD_US    = 0.0f,
            .TICKS_PER_US = 0.0f,
        },

        // POINTERS ARE INITIALIZED IN HDLR_init() FUNCTION

//      .raw = ,
//      .meas = ,
//      .duty = ,
//      .error = ,
//      .inv_state_machine = ,

    },

//---------- TASK SCHEDULER PACK ---------------------------------------------------------------//

    .TASK_PACK = (TASK_pack_S)
    {
        // CPU TICK COUNTER

        .cpu_tick = 1,

        // FPGA COMMANDS

        .fpga_screen = 0,
        .fpga_reset  = 0,

        // POINTERS ARE INITIALIZED IN HDLR_init() FUNCTION

//      .raw = ,
//      .meas = ,
//      .error = ,

    },

//---------- ERROR PACK ------------------------------------------------------------------------//

    .ERR_PACK = (ERR_pack_S)
    {
        .CONFIG.all    = 0,
        .INIT.all      = 0,
        .TIMEOUT.all   = 0,
        .MEAS_LOW.all  = 0,
        .MEAS_HIGH.all = 0,
        .STAT_LOW.all  = 0,
        .STAT_HIGH.all = 0,
    },

#ifdef CONST_CALIBRATION_BUFFER_SIZE
//---------- MEASUREMENTS CALIBRATION ----------------------------------------------------------//
    .MEAS_CAL = (SYS_cal_S)
    {
        .indOldest     = 0,
        .channel       = 0,
        .numOfChannels = sizeof(SYS_meas_S)/sizeof(volatile fp32_t),
        .stats.N       = CONST_CALIBRATION_BUFFER_SIZE,
    },
#endif //#ifdef CONST_CALIBRATION_BUFFER_SIZE
};

//==============================================================================================//
//              INITIALIZATION FUNCTION DEFINITION                                              //
//=============================================================================================c//

void HDLR_init(void)
{
    // Initialize inverter pointers
    HDLR_PACK.INV_PACK.raw   = &HDLR_PACK.RAW;
    HDLR_PACK.INV_PACK.meas  = &HDLR_PACK.MEAS;
    HDLR_PACK.INV_PACK.duty  = &HDLR_PACK.INV_DUTY;
    HDLR_PACK.INV_PACK.error = &HDLR_PACK.ERR_PACK;

    // Initialize buck-boost pointers
    HDLR_PACK.BUB_PACK.raw   = &HDLR_PACK.RAW;
    HDLR_PACK.BUB_PACK.meas  = &HDLR_PACK.MEAS;
    HDLR_PACK.BUB_PACK.duty  = &HDLR_PACK.BUB_DUTY;
    HDLR_PACK.BUB_PACK.error = &HDLR_PACK.ERR_PACK;

    // Buck-boost needs to read inverter state-machine state
    HDLR_PACK.BUB_PACK.inv_state_machine = &HDLR_PACK.INV_PACK.state_machine;

    // Initialize task scheduler pointers
    HDLR_PACK.TASK_PACK.raw   = &HDLR_PACK.RAW;
    HDLR_PACK.TASK_PACK.meas  = &HDLR_PACK.MEAS;
    HDLR_PACK.TASK_PACK.error = &HDLR_PACK.ERR_PACK;

#ifdef CONST_MAV_BUFFER_SIZE
    // Set pointers to moving-average filter circular buffer
    HDLR_PACK.INV_PACK.mav_v_grid_d.buffer = &HDLR_PACK.INV_PACK.buffer[0][0];
    HDLR_PACK.INV_PACK.mav_v_grid_q.buffer = &HDLR_PACK.INV_PACK.buffer[1][0];
    HDLR_PACK.INV_PACK.mav_v_sec_d .buffer = &HDLR_PACK.INV_PACK.buffer[2][0];
    HDLR_PACK.INV_PACK.mav_v_sec_q .buffer = &HDLR_PACK.INV_PACK.buffer[3][0];
#endif

#ifdef CONST_CALIBRATION_BUFFER_SIZE
    // Set pointer in the inverter structure
    HDLR_PACK.INV_PACK.meas_cal = &HDLR_PACK.MEAS_CAL;

    // Set pointer to input measurement channels:
    //  ---------------------------------------------------
    //  INDEX   CHANNEL     VARIABLE        NOTE
    //  ---------------------------------------------------
    //  0       B5          v_grid_an
    //  1       C5          v_grid_bn
    //  2       D3          v_grid_cn
    //  3       B2          v_sec_ab
    //  4       C2          v_sec_bc
    //  5       D0          v_sec_ca
    //  6       B4          i_sec_an
    //  7       C4          i_sec_bn
    //  8       D2          i_sec_cn
    //  9       D1          v_dc
    //  10      A0          v_out
    //  11      A2          v_bat
    //  12      A3          v_rem
    //  13      A4          i_L1
    //  14      A5          i_L2
    //  15      A1          i_out
    //  16      B3          temp_ac
    //  17      C3          temp_dc
    //  ---------------------------------------------------
    HDLR_PACK.MEAS_CAL.inputs = (fp32_t *) &HDLR_PACK.RAW.v_grid_abcn.an;

    // Reset statistics structure
    DSP_statReset(&HDLR_PACK.MEAS_CAL.stats);
#endif //#ifdef CONST_CALIBRATION_BUFFER_SIZE
}

#endif /* HANDLER_C_ */

//==============================================================================================//
//              END OF FILE                                                                     //
//=============================================================================================c//
