//==============================================================================================//
//              HANDLER.H                                                                       //
//=============================================================================================c//

#ifndef HANDLER_H_
#define HANDLER_H_

#include "system.h"
#include "stopwatch.h"
#include "inverter.h"
#include "buckboost.h"
#include "task.h"
#include "error.h"

#include "constants.h"

//==============================================================================================//
//              HANDLER STRUCTURE DECLARATION                                                   //
//=============================================================================================c//

typedef struct HDLR_pack_STRUCT
{
SYS_meas_S MEAS;
SYS_meas_S RAW;

    SYS_pwm3_S INV_DUTY;
    SYS_pwm2_S BUB_DUTY;

    INV_pack_S  INV_PACK;
    BUB_pack_S  BUB_PACK;
    TASK_pack_S TASK_PACK;

ERR_pack_S ERR_PACK;

#ifdef CONST_CALIBRATION_BUFFER_SIZE
SYS_cal_S  MEAS_CAL;
#endif //#ifdef CONST_CALIBRATION_BUFFER_SIZE

} HDLR_pack_S;

extern volatile HDLR_pack_S HDLR_PACK;

//==============================================================================================//
//              FUNCTION DECLARATIONS                                                           //
//=============================================================================================c//

void HDLR_init(void);

#endif /* HANDLER_H_ */

//==============================================================================================//
//              END OF FILE                                                                     //
//=============================================================================================c//
