//==============================================================================================//
//              MAINCPU1.C                                                                      //
//=============================================================================================c//

#ifndef mainCpu1_C_
#define mainCpu1_C_

// See related discussions on Texas Instruments forum:
//  Possible errors in the TMS320F28379D datasheet memory map
//  - https://e2e.ti.com/support/microcontrollers/c2000/f/171/t/670133
//  How to configure PWM generators for 3-phase inverter application:
//  - https://e2e.ti.com/support/microcontrollers/c2000/f/171/t/667602
//  Internal synchronization of ePWM time base:
//  - https://e2e.ti.com/support/microcontrollers/c2000/f/171/t/726606

#include "handler.h"
#include "constants.h"

#include "mcu.h"

#include "inverter.h"
#include "buckboost.h"
#include "task.h"

//==============================================================================================//
//              MAIN FUNCTION                                                                   //
//=============================================================================================c//

void main(void)
{
    // Initialize all handlers
    HDLR_init();

    // Initialize inverter controller
    INV_init(&HDLR_PACK.INV_PACK);

    // Initialize buck-boost controller
    BUB_init(&HDLR_PACK.BUB_PACK);

    // Initialize task scheduler
    TASK_init(&HDLR_PACK.TASK_PACK);

    // Configure system:
    //  - clock, GPIO, TMR, SCI, ADC, ePWM, PIE
    //  - all interrupts are disabled until system is fully initialized
    MCU_initSys(&HDLR_PACK.ERR_PACK);

    // Wait 1 ms for everything to settle
    DELAY_US(1000);

    // Enable inverter and buck-boost interrupts only if there is no INIT error
    if (HDLR_PACK.ERR_PACK.INIT.all == 0)
    {
        PieCtrlRegs.PIEIER1.bit.INTx1 = 1;      // ADCA1 on EOC15
        PieCtrlRegs.PIEIER3.bit.INTx2 = 1;      // ePWM2 on TBCTR=0x00
        PieCtrlRegs.PIEIER3.bit.INTx4 = 1;      // ePWM4 on TBCTR=0x00
    }

    // Infinite while loop
    while (1);
}

#endif /* MAINCPU1_C_ */

//==============================================================================================//
//              END OF FILE                                                                     //
//=============================================================================================c//
