//==============================================================================================//
//              MCU.H                                                                           //
//=============================================================================================c//

#ifndef MCU_H_
#define MCU_H_

#include "utils.h"

#ifndef PLECS
#include "F28x_Project.h"
#endif

#include "error.h"

//==============================================================================================//
//              FUNCTION PROTOTYPES                                                             //
//=============================================================================================c//

void MCU_initSys(volatile ERR_pack_S *err);

//==============================================================================================//
//              INLINE FUNCTIONS - EPWM                                                         //
//=============================================================================================c//

#define MCU_EPWM_OUTPUT_ENABLE      1
#define MCU_EPWM_OUTPUT_DISABLE     2

UTILS_INLINE void MCU_epwmSetDutyCycle(volatile struct EPWM_REGS *EPwmRegs, fp32_t dutyCycle_pu);
UTILS_INLINE void MCU_epwmEnableOutputs(volatile struct EPWM_REGS *EPwmRegs, uint16_t ENABLE);
UTILS_INLINE void MCU_epwmEnableOutput(volatile struct EPWM_REGS *EPwmRegs, uint16_t ENABLE_A, uint16_t ENABLE_B);

// TODO Duty cycle is defined in per-unit relative to PWM period, i.e., in range from 0..1
UTILS_INLINE void MCU_epwmSetDutyCycle(volatile struct EPWM_REGS *EPwmRegs, fp32_t dutyCycle_pu)
{
    EPwmRegs->CMPA.bit.CMPA = (uint16_t)(dutyCycle_pu*EPwmRegs->TBPRD+0.5f);
}

UTILS_INLINE void MCU_epwmEnableOutputs(volatile struct EPWM_REGS *EPwmRegs, uint16_t ENABLE)
{
    // ePWM module should control output pins
    if (ENABLE == MCU_EPWM_OUTPUT_ENABLE)
    {
        EPwmRegs->AQCSFRC.bit.CSFA = 0U;
        EPwmRegs->AQCSFRC.bit.CSFB = 0U;
    }

    // Output pins are forced to low state
    else // MCU_EPWM_OUTPUT_DISABLE
    {
        EPwmRegs->AQCSFRC.bit.CSFA = 1U;
        EPwmRegs->AQCSFRC.bit.CSFB = 2U; // [inverted high state]
    }
}

UTILS_INLINE void MCU_epwmEnableOutput(volatile struct EPWM_REGS *EPwmRegs, uint16_t ENABLE_A, uint16_t ENABLE_B)
{
    // Enable or disable ePWM output A
    EPwmRegs->AQCSFRC.bit.CSFA = (ENABLE_A==MCU_EPWM_OUTPUT_ENABLE) ? 0U : 1U;

    // Enable or disable ePWM output B
    EPwmRegs->AQCSFRC.bit.CSFB = (ENABLE_B==MCU_EPWM_OUTPUT_ENABLE) ? 0U : 2U;
}

#endif /* MCU_H_ */

//==============================================================================================//
//              END OF FILE                                                                     //
//=============================================================================================c//
