//==============================================================================================//
//              NTC.C                                                                           //
//=============================================================================================c//

#ifndef ntc_C_
#define ntc_C_

#include "ntc.h"

//==============================================================================================//
//              NTC LOOKUP TABLE                                                                //
//=============================================================================================c//

// Lookup table for NTC B57703M (8016)
const int16_t NTC_B57703M_8016[43][2] =
{
    // ADC  TEMP
    {   69,  -55 },
    {   98,  -50 },
    {  138,  -45 },
    {  191,  -40 },
    {  259,  -35 },
    {  346,  -30 },
    {  453,  -25 },
    {  583,  -20 },
    {  734,  -15 },
    {  906,  -10 },
    { 1095,   -5 },
    { 1296,    0 },
    { 1504,    5 },
    { 1710,   10 },
    { 1911,   15 },
    { 2101,   20 },
    { 2275,   25 },
    { 2433,   30 },
    { 2573,   35 },
    { 2695,   40 },
    { 2801,   45 },
    { 2892,   50 },
    { 2969,   55 },
    { 3035,   60 },
    { 3091,   65 },
    { 3138,   70 },
    { 3178,   75 },
    { 3211,   80 },
    { 3239,   85 },
    { 3263,   90 },
    { 3283,   95 },
    { 3301,  100 },
    { 3315,  105 },
    { 3328,  110 },
    { 3338,  115 },
    { 3348,  120 },
    { 3355,  125 },
    { 3362,  130 },
    { 3368,  135 },
    { 3373,  140 },
    { 3378,  145 },
    { 3381,  150 },
    { 3385,  155 }
};

//==============================================================================================//
//              NTC FUNCTIONS                                                                   //
//=============================================================================================c//

// TODO
#define NTC_SET_LOOKUP_TABLE(_LUT)                              \
    const int16_t *lut = &_LUT[0][0];                           \
    int16_t lutSize = sizeof(_LUT)/(2*sizeof(const int16_t))

int16_t NTC_calcTemperature(uint16_t adcValue)
{
    // Check input value range
    if (adcValue > 0x0FFF)
        return 0x8000;

    // Initialize pointer to NTC lookup table
    NTC_SET_LOOKUP_TABLE(NTC_B57703M_8016);

    // Check lookup table size
    if (lutSize <= 1)
        return 0x8000;

    // Find lookup table index
    // TODO this could be implemented in a smarter way (see binary search)
    uint16_t i;
    for (i=0; i<lutSize-1 && adcValue>*(lut+2*i+0); i++);
    if (i>0) i--;

    // Get lookup table entries
    // D - digital value, T - temperature
    int16_t D1 = *(lut+2*i+0), T1 = *(lut+2*i+1);
    int16_t D2 = *(lut+2*i+2), T2 = *(lut+2*i+3);

    // Return temperature
    return ((D1==D2) ? 0x8000 : // (int16_t) 0x8000 is -32768
            100U*((int32_t)(T2-T1)*(adcValue-D1) + (int32_t)T1*(D2-D1)) / (D2-D1));
}

#endif /* NTC_C_ */

//==============================================================================================//
//              END OF FILE                                                                     //
//=============================================================================================c//
