//==============================================================================================//
//              STOPWATCH.C                                                                     //
//=============================================================================================c//

#ifndef stopwatch_C_
#define stopwatch_C_

#include "stopwatch.h"

//==============================================================================================//
//              FUNCTION DEFINITIONS                                                            //
//=============================================================================================c//

_Bool SWC_init(volatile SWC_tictoc_S *stopwatch, volatile uint32_t *timer, uint32_t PERIOD_REG, fp32_t PERIOD_US)
{
    if (timer==0 || PERIOD_REG==0 || PERIOD_US<=0)
        return ERR_SET;

    stopwatch->tim = timer;
    stopwatch->PERIOD_US = PERIOD_US;
    stopwatch->TICKS_PER_US = (PERIOD_REG+1) / PERIOD_US;

    return ERR_CLEAR;
}

#endif /* STOPWATCH_C_ */

//==============================================================================================//
//              END OF FILE                                                                     //
//=============================================================================================c//
