//==============================================================================================//
//              SYSTEM.H                                                                        //
//=============================================================================================c//

#ifndef SYSTEM_H_
#define SYSTEM_H_

#include "utils.h"
#include "ac3ph.h"

//==============================================================================================//
//              MACRO FLAGS                                                                     //
//=============================================================================================c//

//
// LED CONTROL
//

#define SYS_LED_ON          0
#define SYS_LED_OFF         1

//
// RELAY CONTROL
//

#define SYS_RELAY_OFF       0
#define SYS_RELAY_ON        1

//==============================================================================================//
//              MICROCONTROLLER PIN INTERFACE                                                   //
//=============================================================================================c//

//
// LAUNCHPAD LED INTERFACE
//

// Note that user LED D1 on LaunchPad is not controlled by any GPIO pin.

#define SYS_LED9            34      // LED D9  on controlCard
#define SYS_LED10           31      // LED D10 on controlCard

//
// RELAY INTERFACE
//

// Note that RELAY1 is controlled by FPGA in CONTROL BOARD V1.0, and in CONTROL BOARD V2.0 it is
// controlled by LP_DB1 together with RELAY2, i.e., RELAY1 and RELAY2 are short-circuited in V2.0.
// The R2-R6 labels on the EXPANSION BOARD V1.0L correspond to RELAY2-RELAY6 macros, respectively.

//#define SYS_RELAY1
#define SYS_RELAY2          67      // RELAY CONTROL pin 10 is R2 controlled by LP_DB1
#define SYS_RELAY3          111     // RELAY CONTROL pin 7  is R3 controlled by LP_DB2
#define SYS_RELAY4          22      // RELAY CONTROL pin 8  is R4 controlled by LP_DB3
#define SYS_RELAY5          97      // RELAY CONTROL pin 5  is R5 controlled by LP_DB4
#define SYS_RELAY6          94      // RELAY CONTROL pin 6  is R6 controlled by LP_DB5
#define SYS_RELAY7          52      // RELAY CONTROL pin 3  is -- controlled by LP_DB6

//
// FPGA INTERFACE
//

// Note that SPIB pins are used as digital outputs, to enable or disable PWM generators on FPGA.
// Make sure that SPIB_SOMI is configured as a digital input on FPGA!
// TODO revise this, we need one input pin for error detection!

#define SYS_SPIB_CLK        65      // SPI clock
#define SYS_SPIB_CS         66      // Slave select
#define SYS_SPIB_SIMO       63      // Slave input, Master output
#define SYS_SPIB_SOMI       64      // Slave output, Master input

//==============================================================================================//
//              SYSTEM INTERFACE                                                                //
//=============================================================================================c//

//
// RELAY INTERFACE
//

#define SYS_RELAY_CONTACTOR_AC              SYS_RELAY3
#define SYS_RELAY_CONTACTOR_DC              SYS_RELAY6
#define SYS_RELAY_PRECHARGE_DC_LINK         SYS_RELAY5
#define SYS_RELAY_DISCHARGE_DC_LINK         SYS_RELAY2
#define SYS_RELAY_DISCHARGE_OUTPUT          SYS_RELAY4

//
// RELAY CONTROL
//

// Note that two CONTACTOR and two DISCHARGE relays are SPST with 1 NO contact, while PRECHARGE
// relay is SPDT with 1 NO and 1 NC contact, whereas grid is connected to the NC contact, and
// precharge resistors are connected to the NO contact. In other words, in order to connect
// the precharge resistors, the PRECHARGE relay needs to be POWERED ON.

#define SYS_RELAY_CONTACTOR_AC_DISCONNECT   SYS_RELAY_OFF
#define SYS_RELAY_CONTACTOR_AC_CONNECT      SYS_RELAY_ON

#define SYS_RELAY_CONTACTOR_DC_DISCONNECT   SYS_RELAY_OFF
#define SYS_RELAY_CONTACTOR_DC_CONNECT      SYS_RELAY_ON

#define SYS_RELAY_PRECHARGE_DC_LINK_OFF     SYS_RELAY_OFF
#define SYS_RELAY_PRECHARGE_DC_LINK_ON      SYS_RELAY_ON

#define SYS_RELAY_DISCHARGE_DC_LINK_OFF     SYS_RELAY_OFF
#define SYS_RELAY_DISCHARGE_DC_LINK_ON      SYS_RELAY_ON

#define SYS_RELAY_DISCHARGE_OUTPUT_OFF      SYS_RELAY_OFF
#define SYS_RELAY_DISCHARGE_OUTPUT_ON       SYS_RELAY_ON

//
// PWM INTERFACE
//

// Note that ePWM3 is not used in IVA5000 project.

#define SYS_PWM_BUB_L1      &EPwm2Regs
#define SYS_PWM_BUB_L2      &EPwm1Regs
#define SYS_PWM_INV_L1      &EPwm4Regs
#define SYS_PWM_INV_L2      &EPwm5Regs
#define SYS_PWM_INV_L3      &EPwm6Regs

//==============================================================================================//
//              MEASUREMENTS PACK AND DUTY CYCLES                                               //
//=============================================================================================c//

// Pack with all measurements
typedef struct SYS_meas_STRUCT
{
    AC3PH_abcn_S v_grid_abcn;
    AC3PH_abc_S v_sec_abc;
    AC3PH_abcn_S i_sec_abcn;
    fp32_t v_dc;
    fp32_t v_out;
    fp32_t v_bat;
    fp32_t v_rem;
    fp32_t i_L1;
    fp32_t i_L2;
    fp32_t i_out;
    fp32_t temp_ac;
    fp32_t temp_dc;
} SYS_meas_S;

// Pack with duty cycles for buck-boost control
typedef struct SYS_pwm2_STRUCT
{
    fp32_t d1;
    fp32_t d2;
} SYS_pwm2_S;

// Pack with duty cycles for inverter control
typedef struct SYS_pwm3_STRUCT
{
    fp32_t d1;
    fp32_t d2;
    fp32_t d3;
} SYS_pwm3_S;

//==============================================================================================//
//              MEASUREMENTS CALIBRATION                                                        //
//=============================================================================================c//

// CONST_CALIBRATION_BUFFER_SIZE macro constant
#include "constants.h"

// Calibration structure cannot be defined if buffer size is not set
#ifdef CONST_CALIBRATION_BUFFER_SIZE

// Declaration for DSP_stat_S structure
#include "dsp.h"

typedef struct SYS_cal_STRUCT
{
    int16_t buffer[CONST_CALIBRATION_BUFFER_SIZE];
    uint16_t indOldest;
    fp32_t *inputs;
    uint16_t channel;
    uint16_t numOfChannels;
    DSP_stat_S stats;
} SYS_cal_S;

#endif //#ifdef CONST_CALIBRATION_BUFFER_SIZE

#endif /* SYSTEM_H_ */

//==============================================================================================//
//              END OF FILE                                                                     //
//=============================================================================================c//
