//==============================================================================================//
//              TASK.C                                                                          //
//=============================================================================================c//

#ifndef task_C_
#define task_C_

#include "task.h"

#include "constants.h"

#include "mcu.h"
#include "ntc.h"

// Task scheduler handler
volatile TASK_pack_S *TASK;

//==============================================================================================//
//              CPUTIMER2 INTERRUPT FUNCTION DEFINITION                                         //
//=============================================================================================c//

interrupt void TASK_isrCpuTimer2(void)
{
    //
    // GET ERROR HANDLER
    //

    // Pointer to error structure
    volatile ERR_pack_S *err = TASK->error;

    //
    // UPDATE CPU TICK COUNTER
    //

    // The cpuTick goes from 1 to CONST_CPU_TICK_MAX, and then overflows back to 1
    TASK->cpu_tick = (TASK->cpu_tick==CONST_CPU_TICK_MAX) ? 1 : (TASK->cpu_tick+1);

    //
    // DETERMINISTIC TASK SCHEDULER
    //

    // FPGA control

    // Switch FPGA screen
    switch (TASK->fpga_screen)
    {
        case 0 :
            GPIO_WritePin(SYS_SPIB_CS, 0);
            break;

        default :
            GPIO_WritePin(SYS_SPIB_CS, 1);
            TASK->fpga_screen = 0;
            break;
    }

    // Reset FPGA error
    switch (TASK->fpga_reset)
    {
        case 0 :
            GPIO_WritePin(SYS_SPIB_CLK,  0);
            GPIO_WritePin(SYS_SPIB_SOMI, 0);
            GPIO_WritePin(SYS_SPIB_SIMO, 0);
            break;

        default :
            GPIO_WritePin(SYS_SPIB_CLK,  1);
            GPIO_WritePin(SYS_SPIB_SOMI, 0);
            GPIO_WritePin(SYS_SPIB_SIMO, 1);
            TASK->fpga_reset = 0;
            break;
    }

    // Calculate coldplate temperature
    //  [ O 0ms     P 1000ms ]
    if (TASK->cpu_tick % 100 == 0)
    {
        // Calculate AC- and DC-side coldplate temperatures from raw measurements
        TASK->meas->temp_ac = 0.01f * NTC_calcTemperature((uint16_t) TASK->raw->temp_ac);
        TASK->meas->temp_dc = 0.01f * NTC_calcTemperature((uint16_t) TASK->raw->temp_dc);

        // Check temperature measurements limits
        ERR_CHECK_LIMITS(TASK->meas->temp_ac, CONST_PROT_TEMP, MEAS, TEMP_AC);
        ERR_CHECK_LIMITS(TASK->meas->temp_dc, CONST_PROT_TEMP, MEAS, TEMP_DC);
    }

    // State-machine error indicator
    //  [ O 10ms    P 500ms ]
    if ((TASK->cpu_tick-1) % 50 == 0)
    {
        // There is no error, LED9 and LED10 are ON
        if (0)//ERR_FIELD_GET(CONFIG, GLOBAL) == ERR_CLEAR)
        {
            GPIO_WritePin(SYS_LED9,  SYS_LED_ON);
            GPIO_WritePin(SYS_LED10, SYS_LED_ON);
        }

        // Blink LED9 and LED10
        // TODO IMPLEMENT INDEPENDET BLINK
        else
        {
            GPIO_WritePin(SYS_LED9,  !GPIO_ReadPin(SYS_LED9 ));
            GPIO_WritePin(SYS_LED10, !GPIO_ReadPin(SYS_LED10));
        }
    }

    //
    // RETURN FROM INTERRUPT SERVICE ROUTINE
    //

    // Note that there are no interrupt-related flags that need to be cleared in order to enable
    // new interrupts, i.e., CpuTimer2 interrupt flag is wired directly to the CPU INT14.
    return;
}

//==============================================================================================//
//              INITIALIZATION FUNCTION DEFINITION                                              //
//=============================================================================================c//

_Bool TASK_init(volatile TASK_pack_S *TASK_PACK)
{
    // Initialize handler
    TASK = TASK_PACK;

    return ERR_CLEAR;
}


#endif /* TASK_C_ */

//==============================================================================================//
//              END OF FILE                                                                     //
//=============================================================================================c//
