//==============================================================================================//
//              TASK.H                                                                          //
//=============================================================================================c//

#ifndef TASK_H_
#define TASK_H_

#include "utils.h"

#include "system.h"
#include "error.h"

//==============================================================================================//
//              HANDLER DECLARATION                                                             //
//=============================================================================================c//

typedef struct TASK_pack_STRUCT
{
    // CPU tick counter
    uint32_t cpu_tick;

    // FPGA commands
    uint16_t fpga_screen;
    uint16_t fpga_reset;

    // Pointer to measurement structures
    volatile SYS_meas_S *raw;       // Structure with raw measurements
    volatile SYS_meas_S *meas;      // Structure with physical values

    // Pointer to error structure
    volatile ERR_pack_S *error;

} TASK_pack_S;

//==============================================================================================//
//              FUNCTION DECLARATIONS                                                           //
//=============================================================================================c//

interrupt void TASK_isrCpuTimer2(void);

_Bool TASK_init(volatile TASK_pack_S *TASK_PACK);

#endif /* TASK_H_ */

//==============================================================================================//
//              END OF FILE                                                                     //
//=============================================================================================c//
