//==============================================================================================//
//              UTILS.H                                                                         //
//=============================================================================================c//

#ifndef UTILS_H_
#define UTILS_H_

// Definition for int32_t, uint32_t etc. data types
#include <stdint.h>

// Definition for _Bool data type
#include <stdbool.h>

typedef float fp32_t;

#define UTILS_INLINE        static inline

//==============================================================================================//
//              MATHEMATICAL CONSTANTS                                                          //
//=============================================================================================c//

#define UTILS_PI            ((fp32_t) 3.1415926535897932384626433832795)
#define UTILS_SQRT2         ((fp32_t) 1.4142135623730950488016887242097)
#define UTILS_SQRT3         ((fp32_t) 1.7320508075688772935274463415059)

#define UTILS_1BY4          ((fp32_t) 1.0 / 4.0)
#define UTILS_1BY3          ((fp32_t) 1.0 / 3.0)
#define UTILS_1BY2          ((fp32_t) 1.0 / 2.0)
#define UTILS_2BY3          ((fp32_t) 2.0 / 3.0)
#define UTILS_4BY3          ((fp32_t) 4.0 / 3.0)
#define UTILS_3BY2          ((fp32_t) 3.0 / 2.0)

#define UTILS_SQRT2BY2      ((fp32_t) UTILS_SQRT2 * UTILS_1BY2)
#define UTILS_SQRT3BY2      ((fp32_t) UTILS_SQRT3 * UTILS_1BY2)
#define UTILS_SQRT3BY3      ((fp32_t) UTILS_SQRT3 * UTILS_1BY3)

#define UTILS_PIBY4         ((fp32_t) UTILS_PI * UTILS_1BY4)
#define UTILS_PIBY3         ((fp32_t) UTILS_PI * UTILS_1BY3)
#define UTILS_PIBY2         ((fp32_t) UTILS_PI * UTILS_1BY2)
#define UTILS_2PIBY3        ((fp32_t) UTILS_PI * UTILS_2BY3)
#define UTILS_4PIBY3        ((fp32_t) UTILS_PI * UTILS_4BY3)
#define UTILS_3PIBY2        ((fp32_t) UTILS_PI * UTILS_3BY2)
#define UTILS_2PI           ((fp32_t) UTILS_PI * 2.0)

#define UTILS_RAD2DEG       ((fp32_t) 180.0 / UTILS_PI)
#define UTILS_DEG2RAD       ((fp32_t) UTILS_PI / 180.0)

//==============================================================================================//
//              ADC DIGITAL VALUE NORMALIZATION                                                 //
//=============================================================================================c//

// TODO Transform 12-bit unsigned number (raw measurement) to actual physical value
#define UTILS_ADC_NORM(ADC, MULT, OFFSET)   \
        (ADC - (OFFSET)) * (MULT)

//==============================================================================================//
//              TRIGONOMETRIC FUNCTIONS                                                         //
//=============================================================================================c//

// Definition for sinf and cosf functions
#include <math.h>

typedef struct UTILS_angle_STRUCT
{
    fp32_t theta;   // Angle (rad)
    fp32_t _sin;
    fp32_t _cos;
} UTILS_angle_S;

UTILS_INLINE void UTILS_calcSinAndCos(volatile UTILS_angle_S *angle);

UTILS_INLINE void UTILS_calcSinAndCos(volatile UTILS_angle_S *angle)
{
    angle->_sin = sinf(angle->theta);
    angle->_cos = cosf(angle->theta);
}

#endif /* UTILS_H_ */

//==============================================================================================//
//              END OF FILE                                                                     //
//=============================================================================================c//
