********************************************************************************
*  FILENAME:   Pgm_alg.asm                                                     *
*  FILETYPE:   TMS320C2Xlp Assembly Language (Texas Instruments)               *
*                                                                              *
*  Date: 08/97                                                                 *
********************************************************************************
* Revision History
*
*       April 7, 2000:  Changed the instruction LACC FL_SECST to LACC #0 to fix
*                       issue in flash programming. (Line 344).
*
********************************************************************************
** PERFORMS THE FOLLOWING:                                                    **
*	- PROGRAMS DATA LOCATED IN B1 (0X0300@DATA)                           **					                       	                                   **
* 	     INTO CONSECUTIVE FLASH MEMORY                                    **                                                     
*       - FIRST WORD OF FLASH PROGRAMMED IS DETERMINED                        **
*	     BY VALUE LOADED INTO FL_SECST (0X0068@DATA)                      **
*       - NUMBER OF WORDS PROGRAMMED IS DETERMINED BY                         **
*            VALUE LOADED INTO FL_SECEND (256 MAX)                            **
*                                                                             **
*                                                                             **
*                                                                             **
*                                                                             **
*   NOTES: - DATA MUST BE PRELOADED INTO B1                                   ** 
*                 				                              **
*                                                                             **
*                                                                             **
********************************************************************************

********************************************************************************
** THE FOLLOWING VARIABLES CAN BE CHANGED IF THERE IS A SPEC CHANGE.          **
** THE FL_SEGST,FL_SEGEND,ARRAY AND SECTOR VARIABLES DETERMINE WHICH ARRAY    **
** AND SECTOR                                                                 **
**   IS BEING WORK ON.                                                        **
**						                              **
REGACC	.SET	0000h	;ARRAY 0 (ARRAY 1 :(4000h) ARRAY 2 :(8000h)           **
ARRAY	.SET	0001h	;ARRAY 0 (ARRAY 1 - (2) ARRAY 2 - (4))                **
			;						      **
	.INCLUDE	..\include\VAR.h		;CONTAINS VARIABLES		      **
********************************************************************************
; Define macros to set the Flash Mode.
; ACCESS_REGS gives access to the Flash Registers in the Pgm Mem Space
; and ACCESS_ARRAY  gives access to the Flash ARRAY in Pgm Mem Space.
;
********************************************************************************


ACCESS_REGS	.macro	
;		SPLK	#ARRAY,REG_ACC
		OUT	07fh,0ff0fh		
		.endm

ACCESS_ARRAY	.macro	
;		SPLK	#0,REG_ACC
		IN	07fh,0ff0fh
		.endm

********************************************************************************
* PUBLIC DECLERATIONS                                                          *
********************************************************************************
	
*********LABELS********

	.DEF READWORD,CLRCMD,DELAY,PROGRAM;	
	.DEF CLR,ERROR1,PPW,NEXTWORD,COMPARE,PGCNT

*********DELAYS********
*
********************************************************************************
*  FLASH PRECONDITION ERASE ROUTINE (ARRAY - Program Space)                    *
********************************************************************************
*
	.TEXT

********************************************************************************
; Define Short DELAY loop macro. 
;  This will be used to generate a short delay less than (255 * 50ns) 12.75 us 
********************************************************************************

SDELAY  .macro  COUNT
        RPT     COUNT
        NOP
	.endm
	
********************************************************************************
** THE FOLLOWING PROGRAM WILL PRECONDITION A SECTOR                           **
**  - INCLUDE FILE, VARx_x.h, DETERMINES WHICH ARRAY AND SECTOR               **
**                                                                            **
********************************************************************************

PROGRAM
	LDP	#0		;DP => 0
	MAR	*,AR1

*******************************************************************************
** SUBROUTINE: ENABL						             **
**	- PLACE FLASH IN REGISTER MODE                                       **
**	- ENABLES SECTOR 					             **
**	- WRITES A ONE TO THE APPROPRIATE "ENABLE" REG		             **
**								             **
*******************************************************************************
ENABL	ACCESS_REGS

	LACC	#SECT		;ENABLE SECTOR
	BLDD	#SECTOR,PAD
	TBLW	PAD	

	LACC	#ENAB		;ENABLE CORE  
	SPLK	#0001h,PAD	
	TBLW	PAD
********************************************************************************
	SPLK	#0000,FL_CMD	;
	BLDD	DATA0,#DATA	;LOAD FIRST DATA VALUE TO BE PROG
********************************************************************************
** SUBROUTINE: CLR	          				              **
**	- READS FLASH ONE WORD AT A TIME IN PROGVER MODE	              **
**		- BRANCHES TO NEXTWORD IF FLASH WORD IS PROGRAMMED            **
**		- ENTERS BITMASK IF WORD NEEDS TO BE PROGRAMMED               **
**								              **
********************************************************************************
CLR
	SPLK	#MX_PCNT,PLS_CNT ;INITIALIZE PROGRAM_COUNT
	.loop 11
	nop
	.endloop

	.def	PGVERON
PGVERON
	LACC	#WADDR		;LOAD ADDRESS TO BE PROG
	
	.def	WR_WADDR1

WR_WADDR1:
	TBLW	ADDR		
*				
	LACC	FL_CMD			
	XOR	#0004h		;PROGVER CMND
	SACL	PAD
*
	LACC	#CTRL		;INIT PROGVER MODE 
	TBLW	PAD
	SDELAY	#T_pvsu		;Wait for T_pvsu(P)
*
	LACC	#PMPC		;PROGVER EXECUTE
	SPLK	#0005h,PAD	
	TBLW	PAD

	SDELAY	#T_pva_e	;Wait T_pva(E) 

	CALL READWORD
	
PGVEROFF
	SPLK	#0000h,PAD1	;CLEAR PMPC
	CALL	CLRCMD
********************************************************************************
** SUBROUTINE: COMPARE					                      **
**  	- XOR DATA READ DURING VERIFY WITH			              **
**	    DESIRED VALUE TO OBTAIN BITS THAT NEED 		              **
**	    TO BE PROG						              **
**	- IF FLASH = DESIRED BRANCH TO NEXT WORD		              **
**		ELSE BUILD MASK (STORE IN READ)			              **
********************************************************************************
COMPARE
	LACL	READ		;ACC=>VALUE READ DURING VERIFY
	LAR 	AR1,DATA0	;LOAD AR1 WITH ADDRESS OF DATA
	BLDD	*,#0064h	;LOAD DATA WITH DATA TO BE LOADED
	XOR	DATA		;XOR WITH DESIRED DATA
	BCND	NEXTWORD,EQ	;IF = 0 THEN PROGRAMMING DONE	
	SACL	READ		;STORE MASK IN READ
	
********************************************************************************
** SUBROUTINE: BITMASK	  	             		                      **
**								              **
**   THIS SECTION ENSURES A MAX OF 8 BITS ARE PROGRAMMED AT A TIME.           **
**      - READ CONTAINS MASK 					              **
**      - CALLS PROG ONCE BITMASK IS BUILT		                      **
********************************************************************************


	XOR	#0ffffh		;acc => lower bits to be prog
	SACL	DATA,0		;store acc in DATA
	CALL	PROG		;branch to prog 

********************************************************************************
** SUBROUTINE: PGCNT                                                          **
**	- ENTERED FROM HIBYTE			                              **
**      - CHECKS THAT THE MAX PROGRAM PULSE COUNT HAS                         **
**         NOT BEEN EXCEEDED                                                  **
**      - DECREMENTS PROGRAM PULSE COUNT                                      **
**					 	                              **
**	     			                                              **
**                                                                            **
********************************************************************************
PGCNT	
	LACC	PLS_CNT		;ACC=># OF PULSE 
	SUB	#1		;DECREMENT PROGRAM COUNT
	SACL	PLS_CNT		;PLS_CNT=># OF PULSES REMAINING
	BCND	ERROR,EQ	;IF ACC=0 THEN ERROR	
	B	PGVERON		;verify word programmed
********************************************************************************
** SUBROUTINE: PROG                                                           **
** 	  - CALLED BY LOBYTE OR HIBYTE				              **
**	  - APPLIES PROGRAM PULSE TO (REQUIRED) BITS                          **
**	  - "DATA" CONTAINS BITS TO BE PROG                                   **
**	  - WILL PROGRAM BITS IN MAIN ARRAY OR REDUNDANT ROWS                 **
**		DEPENTING ON THE STATUS OF "FL_CMD"                           **
**			- FL_CMD = 0080h (NOROWRED)                           **
**			- FL_CMD = 0100h THEN PROGRAMS ROWREDs                **
********************************************************************************
PROG	LACC	#WDATA		;Load data to be prog
	TBLW	DATA		
*
	LACC	FL_CMD
	XOR	#0003h		;PROG CMND
	SACL	PAD
*
	LACC	#CTRL		;Init prog mode 
	TBLW	PAD
	SDELAY	#T_psu_p	;Wait T_psu(P)
*
	LACC	#PMPC		;Turn on prog voltages
	SPLK	#0005h,PAD	
	TBLW	PAD
*
PPW	SDELAY	#T_prog_e1	;PROG PULSE WIDTH PART 1
	SDELAY	#T_prog_e2	;PROG PULSE WIDTH PART 2

				;T_prog(E)=10,000 nsec


	SPLK	#0000h,PAD	;TURN OFF PROG VOLTAGES
	TBLW	PAD
*
	SDELAY	#Tph_P		;Wait T_ph(P) 	(HOLD TIME).
*
	SPLK	#0001h,PAD1	;CLEAR PMPC AND CNTL
	CALL	CLRCMD
	RET
********************************************************************************
** SUBROUTINE: NEXTWORD                                                       **
**       -CHECKS IF ADDR IS AT LAST ADDR IN SECTOR                            **
**       -INCREMENTS ADDRESS                                                  **
**       -REINITIALIZES PROGRAM PULSE COUNT, FOR                              **
**          PROGRAMMING OF NEXT WORD                                          **
********************************************************************************
NEXTWORD		
	LACC	FL_SECEND
	SUB	#1
	SACL	FL_SECEND	
;	LACC	ADDR		;ACC=>ADDR OF CURRENT WORD
;	SUB	FL_SECEND	;IF CURRENT WORD END OF DATA, DONE
;	SUB	FL_SECST	;START OF FLASH
	BCND	NW,NEQ		;   WITH THIS DATA BLOCK
	B	END1		;ELSE NEXT WORD
	
NW	LACC	ADDR
	ADD	#1		;INCREMENT ADDR
	SACL	ADDR		;STORE ADDR OF NEXT WORD

	SPLK	#MX_PCNT,PLS_CNT ;Initialize PROGRAM PULSE COUNT 

	LACC	DATA0
	ADD	#1
	SACL	DATA0
	BLDD	DATA0,#0064h	;LOAD NEXT DATA VALUE TO BE PROG
	B	PGVERON		;begin prog of next word
ERROR	
	SPLK	#0005h,PAD1
	CALL	CLRCMD
ERROR1	B	err1		;failed due to exceeding max prgm pulses
*
********************************************************************************
** SUBROUTINE: READWORD                                                       **
**      - READS WORD AT LOCATION "ADDR"                                       **
**	- STORES WORD AT "READ"                                               **
**	- RETURNS TO CALLING ROUTINE IN REGISTER MODE                         **
**                                                                            **
********************************************************************************
READWORD

	ACCESS_ARRAY
	
	LACC	ADDR		;Read word flash 
	TBLR	READ		;-store word in READ (data space)

	ACCESS_REGS
	RET
END1
	LACC	ADDR
	ADD	#1		;INCREMENT ADDR
	SACL	ADDR		;STORE ADDR OF NEXT WORD
	SPLK	#0006h,PAD1	;CLEAR ALL SIX 
	CALL	CLRCMD

	ACCESS_ARRAY

	RET

	
;			
;------------------------------------------------------------------------------
;  SUBROUTINE: Delay
;
; DESCRIPTION:
;  This routine executes a delay approximately
;    (DLOOP + 8) + AR7 * (DLOOP + 6) * 1/freq = nsec
;    if AR7  = 0  Delay = 108 cycles
;    if AR7 != 0  Delay = 108 + AR6 * 106 cycles
;
;  A typical call to this subroutine is as follow:
;
;     lar     ar7,delay_param         1 cycles reg/#k, 2 cycles if #lk
;     call    Delay,*,ar7             4 cycles
;
;       minimum delay is when delay_parm=0
;       minimum delay = 113 cycles ( 108 + 5 )
;       for a cycle time of 50 nsec,
;         minimum delay = 5.65 usec   ( 113 cycles * 50 nsec)
;         delay time    = 5.65 usec + AR7 * 106 * 50 nsec
;                       = 5.65 usec + AR7 * 5.3 usec
;
; INPUTS:
;   AR7 = Passed on to this routine to set delay time as required
;   ARP => AR7    
; OUTPUTS:
;       none
;------------------------------------------------------------------------------

DELAY
        RPT     #DLOOP                  ;1 cycles
        NOP                             ;1+DLOOP = 101 CYCLES (FOR DLOOP = 100)
        BANZ    DELAY,*-,ar7            ;   4/2 (True/False)
        RET                             ;   4 cycles
                                        ; for delay_parm = 0
                                        ;   (1+101+2+4 = 108) cycles
                                        ; for delay_parm != 0
                                        ;   108 + AR7 * (1+101+4 = 106) cycles
;
********************************************************************************
** SUBROUTINE: CLRCMD                                                         **
**      - PLACES FLASH IN NORMAL READ MODE BY:                                **
**	- WRITING 0000 TO THE FIRST TWO LOCATIONS OF                          **
**	    THE FLASH CONTROL REGISTER (0X00040)                              **                                        
**	    (PMPC,CNTL=>0000)                                                 **
**	- RETURNS TO CALLING ROUTINE IN REGISTER MODE                         **
********************************************************************************

CLRCMD
	
	ACCESS_REGS
	
	SPLK 	#0,PAD
	LACC 	#0
 	RPT 	PAD1
 	TBLW 	PAD

	RET







	
