;*****************************************************************************
; File Name:	Kernel.ASM  Build 4.
;
; Project:	F24XX Serial Boot Loader 
; Originator:	DSP Digital Control Systems Group, Houston (Texas Instruments)
;
; Target Sys:	F240x.
;*****************************************************************************
		.include	..\include\svar.h
		.include	..\include\x24x.h 
		

ALGO_START	.set  0fe00h
	    	.def		ALGO_START

;Miscellaneous
BUF_SADDR       .set    0328h           ;Start address for Data buffer
VBR_MAX 	.set	09h		;# times valid char needs to be received
CRC_MAX		.set	03h		;# retries at each PLL setting before giving up.
B0_SADDR        .set    00200h          ;Block B0 start address

;-----------------------------------------------------------------------------
; M A C R O - Definitions
;-----------------------------------------------------------------------------
SBIT0		.macro	DMA, MASK	;Clear bit Macro
		LACC	DMA
		AND	#(0FFFFh-MASK)
		SACL	DMA
		.endm

SBIT1		.macro	DMA, MASK	;Set bit Macro
		LACC	DMA
		OR	#MASK
		SACL	DMA
		.endm


KICK_DOG	.macro			;Watchdog reset macro
		LDP	#00E0h
                SPLK    #05555h, WDKEY
                SPLK    #0AAAAh, WDKEY
		LDP	#0h
                .endm



POINT_0 	.macro
		LDP	#00h
		.endm

POINT_B0	.macro
		LDP	#04h
		.endm

POINT_B1	.macro
		LDP	#06h
		.endm

POINT_PF1	.macro
		LDP	#0E0h
		.endm

;==============================================================================
; This is the entry point and will be at 0x8000.
;==============================================================================
		.text
START:		LDP	#WDCR>>7
		SPLK	#006Fh,WDCR	;Disable WD

        .COPY	"..\unlock\unlock.asm"	;CLEAR ROUTINE


;==============================================================================
;Init Kernel
;==============================================================================
FLSH_INIT	POINT_B1
		SPLK	#0,ERROR_FLAG
;==============================================================================
		LACC	ERROR_FLAG	;Send Zero error to host to indicate to
		CALL	SEND_CHAR	;host kernel succesfully initialized.  
		
	
;==============================================================================
;Load & Execute CLEAR
M00		CALL	XFER_SCI_2_PROG




		CALL	RUN_ALGO
;==============================================================================
	;Load & Execute ERASE
M01		CALL	XFER_SCI_2_PROG
		CALL	RUN_ALGO
;==============================================================================
		;Load & Execute PROG
M02		CALL	XFER_SCI_2_PROG

M03		CALL	FETCH_HEADER		;Get info on Data block
		LACC	dest_addr
		SACL	PRG_paddr		;Pass Flash dest addr
		LACC	length
		ADD	#01h			;adjust for actual length
		SACL	PRG_length		;Pass Data block length
		SPLK	#BUF_SADDR, PRG_bufaddr ;Pass Data buffer start addr

M04		CALL	XFER_SCI_2_DATA		;Transfer Data block to B1
		CALL	RUN_ALGO
;==============================================================================
		CALL	FETCH_SCI_WORD		;Check if more blocks to come.
		LACC	data_buf		;If non-zero, then loop
		BCND	M03, NEQ		;If zero then finish up.

DEND		B	DEND			;
;===========================================================================
; Routine Name: F E T C H _ H E A D E R	       Routine Type: SR
;===========================================================================
FETCH_HEADER:	CALL	FETCH_SCI_WORD
		LACC	data_buf
		SACL	dest_addr
		CALL	FETCH_SCI_WORD
		LACC	data_buf
		SACL	length
		RET

;===========================================================================
; Routine Name: X F E R _ S C I _ 2 _ P R O G	       Routine Type: SR
;===========================================================================
XFER_SCI_2_PROG:SETC	CNF
		CALL	FETCH_HEADER
		MAR	*, AR0
		LAR	AR0, length
		LACC	#ALGO_START		;ACC=dest address

XSP0		CALL	FETCH_SCI_WORD
		TBLW	data_buf		;data_buff-->[ACC]
		ADD	#01h			;ACC++
		BANZ	XSP0			;loop "length" times
		RET
		
;===========================================================================
; Routine Name: X F E R _ S C I _ 2 _ D A T A	       Routine Type: SR
;===========================================================================
XFER_SCI_2_DATA:
		MAR	*, AR1
		LAR	AR0, length		;AR0 is loop counter
		LAR	AR1, #BUF_SADDR 	;Dest --> B1 RAM

XSD0		CALL	FETCH_SCI_WORD
		LACC	data_buf
		SACL	*+, AR0
		BANZ	XSD0, AR1
		RET

;===========================================================================
; Routine Name: F E T C H _ S C I _ W O R D	       Routine Type: SR
;
; Description: Version which expects Lo byte / Hi byte sequence from Host &
;              also echos byte
;===========================================================================
FETCH_SCI_WORD:	POINT_B1
		SACL	stk0
		LDP	#SCIRXST>>7
FSW0		BIT   SCIRXST,BIT6  		;Test RXRDY bit
		BCND  FSW0, NTC	      		;If RXRDY=0,then repeat loop 
		LACC	SCIRXBUF		;First byte is Lo byte
		SACL	SCITXBUF		;Echo byte back
		AND	#0FFh			;Clear upper byte
	
FSW1		BIT   SCIRXST,BIT6  		;Test RXRDY bit
		BCND  FSW1, NTC	    		;If RXRDY=0,then repeat loop
		ADD	SCIRXBUF,8		;Concatenate Hi byte to Lo
		SFL				;used because 7 is max in SACH
		SACH	SCITXBUF,7		;Echo byte back (after SFL 8)

		POINT_B1
		SFR				;restore ACC as before
		SACL	data_buf		;Save received word
		LACC	stk0
		RET

;==============================================================================
; Transmit char to host subroutine.
;==============================================================================
SEND_CHAR	LDP	#SCITXBUF>>7
		SACL	SCITXBUF		;Transmit byte to host.
		POINT_B1
		RET


RUN_ALGO	CALL	ALGO_START
		LACC	ERROR_FLAG
		CALL	SEND_CHAR	;Indicate to host Clear finished.
		RET
;==============================================================================
		.end



