// TI Release: 28xx eCAN programming example
// Release Date: Fri Aug 4 2017
// Copyright:
// Copyright (C) 2017 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/*********************************************************************
* Filename: DLCTX_A.c                                                
*                                                                    
* Description: Illustrates the operation of DLC field for a Transmit mailbox. 	
* 
* Various values of DLC field are tried for mailbox 22
*          
* 
*********************************************************************/

//
// Included Files
//
#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File

void error(int);

int     j;			// j is used to store the incrementing DLC values..
long	i;

main() 
{

/* Create a shadow register structure for the CAN control registers. This is
 needed, since, only 32-bit access is allowed to these registers. 16-bit access
 to these registers could potentially corrupt the register contents. This is
 especially true while writing to a bit (or group of bits) among bits 16 - 31 */

struct ECAN_REGS ECanaShadow;

/* Kill Watchdog, Init PLL, Enable peripheral clocks */

	InitSysCtrl();
	
/* Initialize the CAN module */

	InitECan();
	InitECanGpio();
		
	EALLOW;
    
/* Write to the MSGID field  */
    
    ECanaMboxes.MBOX22.MSGID.all = 0x80000022; // Ext Identifier (ID = 22)
    
/* Configure Mailbox under test as a Transmit mailbox */

	ECanaShadow.CANMD.all = ECanaRegs.CANMD.all;	
	ECanaShadow.CANMD.bit.MD22 = 0;
	ECanaRegs.CANMD.all = ECanaShadow.CANMD.all; 
	
/* Enable Mailbox under test */
	
	ECanaShadow.CANME.all = ECanaRegs.CANME.all;	
	ECanaShadow.CANME.bit.ME22 = 1;	
	ECanaRegs.CANME.all = ECanaShadow.CANME.all; 
	
/* Write to the mailbox RAM field */
    
     ECanaMboxes.MBOX22.MDL.all = 0x01234567;
	 ECanaMboxes.MBOX22.MDH.all = 0x89ABCDEF;		 
	 
/* Begin transmitting */

    for(j=0; j < 9; j++)				// The DLC value is incremented every time     												  	
    {									// the loop is run
     ECanaMboxes.MBOX22.MSGCTRL.bit.DLC = j;
     ECanaShadow.CANTRS.all = 0;			// Set TRS bit 
     ECanaShadow.CANTRS.bit.TRS22 = 1;    
     ECanaRegs.CANTRS.all = ECanaShadow.CANTRS.all;
                  
     while(ECanaRegs.CANTA.bit.TA22 == 0 ) {}  // Wait for TA22 bit to be set..
     
     ECanaShadow.CANTA.all = 0; 			  // See Note 1
     ECanaShadow.CANTA.bit.TA22 = 1;		  // Clear TA22     
     ECanaRegs.CANTA.all = ECanaShadow.CANTA.all;
     
     asm (" NOP");        
    }   
    
asm("     ESTOP0");
}

void error(int ErrorFlag)
{
    asm("     ESTOP0");
    for (;;);
}

/* 

Note 1: Initialize the "shadow-TA register" to zero before setting any bit(s)
in order to clear it (them) in the TA register. Otherwise, some other TAn bit(s) that is (are)
set could be inadvertently cleared.

Note 2: If DLC values > than 8 are written, those values do get stored in
the DLC field. However, only a DLC value of 8 (and hence 8 bytes) are
transmited on the bus.

A total of nine transmissions progressing from 0 to 8 bytes can be monitored
on the CAN bus.

 DLC for a receive mailbox is irrelevant. The DLC field of the received
 frame is copied in the DLC field of the receive mailbox.
*/ 
