// TI Release: 28xx eCAN programming example
// Release Date: Fri Aug 4 2017
// Copyright:
// Copyright (C) 2017 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/*********************************************************************
* Filename: MBXRAMRW_B.c (for CAN-B)                                            *
*                                                                    *
* Description: This code checks if the data-bits of the mailbox RAM  *
*              are able to assume the values of 1 and 0              *
*                                                                    *
* This test writes patterns such as 0000h, FFFFh, 5555h, AAAAh to all
* the 32 mailboxes and reads them back for verification.             *
* Any error is flagged.  
*                                            
*********************************************************************/

//
// Included Files
//
#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File

#define COUNT  100000  // Mailbox RAM test will take place (COUNT) times..
long     i;
long	 d;
long	 loopcount = 0; // Counts the # of times the loop actually ran
long   	 errorcount = 0;

unsigned long TestMbox1 = 0;

void MBXrd(long d);  	/* This function reads from all 32 MBOXes */
void MBXwr(long d);		/* This function writes to all 32 MBOXes */  

main() 
{
/* Kill Watchdog, Init PLL, Enable peripheral clocks */

	InitSysCtrl();
	
/* Initialize the CAN module */

	InitECan();	
	InitECanGpio();
	
	EALLOW;

/* Write to the mailbox RAM field of MBOX0 - 31 */
    /* while(1) */		              // Uncomment this line for infinite iterations
    for(i=0; i < COUNT; i++)		  // Uncomment this line for finite iterations			  	
    {
     d = 0xFFFFFFFF; 
     MBXwr(d);         
     MBXrd(d);
     d = 0x00000000; 
     MBXwr(d);         
     MBXrd(d);
     d = 0x55555555; 
     MBXwr(d);         
     MBXrd(d);
     d = 0xAAAAAAAA; 
     MBXwr(d);         
     MBXrd(d);
     loopcount++;
    }   

asm(" ESTOP0");

}

// Write the passed data to all 32 mailboxes

void MBXwr(long MBXdata) 
	{
	int j;
	volatile struct MBOX *Mailbox  = (void *) 0x6300;   
		
		for(j=0; j<32; j++)								 
		{
		
		Mailbox->MDH.all = MBXdata;
		Mailbox->MDL.all = MBXdata;
		Mailbox = Mailbox + 1; 
		
		}			
	} 

// Check if all 32 mailboxes contain the passed data

void MBXrd(long MBXdata) 
	{	
	int j;
	volatile struct MBOX *Mailbox  = (void *) 0x6300;   
		
		for(j=0; j<32; j++)								 
		{
		
		TestMbox1 = Mailbox->MDL.all;	
		if (TestMbox1 != d)
		 {errorcount++;}
		 
		TestMbox1 = Mailbox->MDH.all;	
		if (TestMbox1 != d) 
		 {errorcount++;}
		 
		Mailbox = Mailbox + 1; 
		
		}	 
	} 
	
/* This code may be used to exercise and check the correct functionality
of the mailbox RAM bits */

