// TI Release: 28xx eCAN programming example
// Release Date: Fri Aug 4 2017
// Copyright:
// Copyright (C) 2017 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/*********************************************************************
* Filename: REMOTE_fr_A.c                                                

 Description: This example illustrates the ability of the CAN module to SEND
 remote frames from (and receive dataframes in) the SAME Mailbox.

Mailboxes 2,3,4,5 in 28xx are configured as Receive mailboxes and their
TRS bits and RTR bits are set. This enables the same mailbox to transmit
a remote frame and receive the corresponding data frame. Mailboxes in 
eCAN-B would transmit DATA frames to the four Rx
mailboxes in 28x, matching the ID of mailboxes.  

*********************************************************************/

//
// Included Files
//
#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File

void MBXwrA(void);                 // This function initializes all 32 MBOXes of CAN-A
void MBXwrB(void);                 // This function initializes all 32 MBOXes of CAN-B

main() 
{

/* Create a shadow register structure for the CAN control registers. This is
 needed, since, only 32-bit access is allowed to these registers. 16-bit access
 to these registers could potentially corrupt the register contents. This is
 especially true while writing to a bit (or group of bits) among bits 16 - 31 */

struct ECAN_REGS ECanaShadow;
struct ECAN_REGS ECanbShadow;

/* Kill Watchdog, Init PLL, Enable peripheral clocks */

	InitSysCtrl();
	
/* Initialize the CAN module */

	InitECan();	
	InitECanGpio();
	
	EALLOW;
	
/* Zero out (or initialize) the entire MBX RAM area */

	MBXwrA();
	MBXwrB();

/* Write to the MSGID fields of both CAN-A & CAN-B  */	
     
   	ECanaMboxes.MBOX2.MSGID.all  = 0x00080000;  // Standard identifier (Will be transmitted as a Remote frame)
    ECanaMboxes.MBOX3.MSGID.all  = 0x000C0000;  // Standard identifier (Will be transmitted as a Remote frame)
    ECanaMboxes.MBOX4.MSGID.all  = 0x00100000;  // Standard identifier (Will be transmitted as a Remote frame)
    ECanaMboxes.MBOX5.MSGID.all  = 0x00140000;  // Standard identifier (Will be transmitted as a Remote frame)

	ECanbMboxes.MBOX28.MSGID.all  = 0x20080000;  // Standard identifier with AAM bit set (will respond as a Data frame)
    ECanbMboxes.MBOX29.MSGID.all  = 0x200C0000;  // Standard identifier with AAM bit set (will respond as a Data frame)
    ECanbMboxes.MBOX30.MSGID.all  = 0x20100000;  // Standard identifier with AAM bit set (will respond as a Data frame)
    ECanbMboxes.MBOX31.MSGID.all  = 0x20140000;  // Standard identifier with AAM bit set (will respond as a Data frame)
        
/* Write to Message Control field - RTR & DLC */
 
    ECanaMboxes.MBOX2.MSGCTRL.bit.RTR = 1;  // RTR bit will be cleared upon successful reception of data
    ECanaMboxes.MBOX3.MSGCTRL.bit.RTR = 1;
    ECanaMboxes.MBOX4.MSGCTRL.bit.RTR = 1;
    ECanaMboxes.MBOX5.MSGCTRL.bit.RTR = 1;
       
    ECanaMboxes.MBOX2.MSGCTRL.bit.DLC = 8;  
    ECanaMboxes.MBOX3.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX4.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX5.MSGCTRL.bit.DLC = 7;	// For this MBX alone, only 7 bytes will be received.

/* Write to the MBX RAM in CAN-B */

     ECanbMboxes.MBOX28.MDL.all = 0x28282828;
	 ECanbMboxes.MBOX28.MDH.all = 0x28282828;
	 
	 ECanbMboxes.MBOX29.MDL.all = 0x29292929;
	 ECanbMboxes.MBOX29.MDH.all = 0x29292929;
	 
	 ECanbMboxes.MBOX30.MDL.all = 0x30303030;
	 ECanbMboxes.MBOX30.MDH.all = 0x30303030;
	 
	 ECanbMboxes.MBOX31.MDL.all = 0x31313131;
	 ECanbMboxes.MBOX31.MDH.all = 0x31313131; 

/* Enable appropriate Mailboxes in CAN-A & CAN-B */
	
	ECanaRegs.CANME.all = 0x0000003C;
	ECanbRegs.CANME.all = 0xF0000000;    
    
/* Configure CAN-A Mailboxes as RX, CAN-B Mailboxes as TX */

	ECanaRegs.CANMD.all = 0x0000003C; 
	ECanbRegs.CANMD.all = 0x00000000;     
          
/* Transmit the remote frames and Wait for data frames.. */

	ECanaShadow.CANTRS.all = 0; 	
    ECanaShadow.CANTRS.all = 0x0000003C;     // Set TRS for *Receive* mailboxes       
    ECanaRegs.CANTRS.all = ECanaShadow.CANTRS.all; 
	
    while(1) {}							
   
}

/* Zero-out the MBX RAM of CAN-A */

void MBXwrA()
    {
    int j;
    volatile struct MBOX *Mailbox  = (void *) 0x6100;

        for(j=0; j<32; j++)
        {
            Mailbox->MSGID.all = 0;
            Mailbox->MSGCTRL.all = 0;
            Mailbox->MDH.all = 0;
            Mailbox->MDL.all = 0;
            Mailbox = Mailbox + 1;

        }
    }

/* Zero-out the MBX RAM of CAN-B */

void MBXwrB()
    {
    int j;
    volatile struct MBOX *Mailbox  = (void *) 0x6300;

        for(j=0; j<32; j++)
        {
            Mailbox->MSGID.all = 0;
            Mailbox->MSGCTRL.bit.DLC = 0;
            Mailbox->MDH.all = 0;
            Mailbox->MDL.all = 0;
            Mailbox = Mailbox + 1;

        }
    }

/* 

Observations:

CAN-A sent remote frames from mailboxes 2,3,4,5 to mailboxes 28,29,30,31 in
CAN-B. The corresponding data frames are received in 
mailboxes 2,3,4,5 of CAN-A.

It is important to correctly configure the DLC value in the remote frame
since only that many bytes will be transmitted in the data frame.

*/

