// TI Release: 28xx eCAN programming example
// Release Date: Fri Aug 4 2017
// Copyright:
// Copyright (C) 2017 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/*********************************************************************
* Filename: RXLOOP.c                                                 *
*                                                                    *
* Description: This is a simple example of how data may be received  	
*
* All mailboxes in CAN-A are configured as receive mailboxes. Each mailbox
* has a different ID. All mailboxes in node B are allowed to transmit
* in a sequence to mailboxes in node A. Once the cycle is complete,
* the cycle is started all over again. 

* This program loops forever. The # of times the receive loop is executed
* is stored in the RXCOUNT value.
*      
*********************************************************************/

//
// Included Files
//
#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File

long      RXCOUNT = 0;
long	  i;

void MBXwrA(void);                 // This function initializes all 32 MBOXes of CAN-A
void MBXwrB(void);                 // This function initializes all 32 MBOXes of CAN-B

main()
{

/* Create a shadow register structure for the CAN control registers. This is
 needed, since, only 32-bit access is allowed to these registers. 16-bit access
 to these registers could potentially corrupt the register contents. This is
 especially true while writing to a bit (or group of bits) among bits 16 - 31 */

struct ECAN_REGS ECanaShadow;
struct ECAN_REGS ECanbShadow;

// Step 1. Initialize System Control:
// PLL, WatchDog, enable Peripheral Clocks
// This example function is found in the DSP280x_SysCtrl.c file.
   InitSysCtrl();

/* Initialize the CAN module */

	InitECan();
	InitECanGpio();
	EALLOW;

/* Zero out (or initialize) the entire MBX RAM area */

	MBXwrA();
	MBXwrB();
    
/* Write to the MSGID field 0f CAN-A - MBX number is written as its MSGID */
	
    ECanaMboxes.MBOX1.MSGID.bit.STDMSGID = 1;
    ECanaMboxes.MBOX2.MSGID.bit.STDMSGID = 2;
    ECanaMboxes.MBOX3.MSGID.bit.STDMSGID = 3;
    ECanaMboxes.MBOX4.MSGID.bit.STDMSGID = 4;
    ECanaMboxes.MBOX5.MSGID.bit.STDMSGID = 5;
    ECanaMboxes.MBOX6.MSGID.bit.STDMSGID = 6;
    ECanaMboxes.MBOX7.MSGID.bit.STDMSGID = 7;
    ECanaMboxes.MBOX8.MSGID.bit.STDMSGID = 8;
    ECanaMboxes.MBOX9.MSGID.bit.STDMSGID = 9;
    ECanaMboxes.MBOX10.MSGID.bit.STDMSGID = 10;
    ECanaMboxes.MBOX11.MSGID.bit.STDMSGID = 11;
    ECanaMboxes.MBOX12.MSGID.bit.STDMSGID = 12;
    ECanaMboxes.MBOX13.MSGID.bit.STDMSGID = 13;
    ECanaMboxes.MBOX14.MSGID.bit.STDMSGID = 14;
    ECanaMboxes.MBOX15.MSGID.bit.STDMSGID = 15;
    ECanaMboxes.MBOX16.MSGID.bit.STDMSGID = 16;
    ECanaMboxes.MBOX17.MSGID.bit.STDMSGID = 17;
    ECanaMboxes.MBOX18.MSGID.bit.STDMSGID = 18;
    ECanaMboxes.MBOX19.MSGID.bit.STDMSGID = 19;
    ECanaMboxes.MBOX20.MSGID.bit.STDMSGID = 20;
    ECanaMboxes.MBOX21.MSGID.bit.STDMSGID = 21;
    ECanaMboxes.MBOX22.MSGID.bit.STDMSGID = 22;
    ECanaMboxes.MBOX23.MSGID.bit.STDMSGID = 23;
    ECanaMboxes.MBOX24.MSGID.bit.STDMSGID = 24;
    ECanaMboxes.MBOX25.MSGID.bit.STDMSGID = 25;
    ECanaMboxes.MBOX26.MSGID.bit.STDMSGID = 26;
    ECanaMboxes.MBOX27.MSGID.bit.STDMSGID = 27;
    ECanaMboxes.MBOX28.MSGID.bit.STDMSGID = 28;
    ECanaMboxes.MBOX29.MSGID.bit.STDMSGID = 29;
    ECanaMboxes.MBOX30.MSGID.bit.STDMSGID = 30;
    ECanaMboxes.MBOX31.MSGID.bit.STDMSGID = 31;
    ECanaMboxes.MBOX0.MSGID.bit.STDMSGID = 32;
    
/* Write to the MSGID field 0f CAN-B - MBX number is written as its MSGID */

    ECanbMboxes.MBOX1.MSGID.bit.STDMSGID = 1;
    ECanbMboxes.MBOX2.MSGID.bit.STDMSGID = 2;
    ECanbMboxes.MBOX3.MSGID.bit.STDMSGID = 3;
    ECanbMboxes.MBOX4.MSGID.bit.STDMSGID = 4;
    ECanbMboxes.MBOX5.MSGID.bit.STDMSGID = 5;
    ECanbMboxes.MBOX6.MSGID.bit.STDMSGID = 6;
    ECanbMboxes.MBOX7.MSGID.bit.STDMSGID = 7;
    ECanbMboxes.MBOX8.MSGID.bit.STDMSGID = 8;
    ECanbMboxes.MBOX9.MSGID.bit.STDMSGID = 9;
    ECanbMboxes.MBOX10.MSGID.bit.STDMSGID = 10;
    ECanbMboxes.MBOX11.MSGID.bit.STDMSGID = 11;
    ECanbMboxes.MBOX12.MSGID.bit.STDMSGID = 12;
    ECanbMboxes.MBOX13.MSGID.bit.STDMSGID = 13;
    ECanbMboxes.MBOX14.MSGID.bit.STDMSGID = 14;
    ECanbMboxes.MBOX15.MSGID.bit.STDMSGID = 15;
    ECanbMboxes.MBOX16.MSGID.bit.STDMSGID = 16;
    ECanbMboxes.MBOX17.MSGID.bit.STDMSGID = 17;
    ECanbMboxes.MBOX18.MSGID.bit.STDMSGID = 18;
    ECanbMboxes.MBOX19.MSGID.bit.STDMSGID = 19;
    ECanbMboxes.MBOX20.MSGID.bit.STDMSGID = 20;
    ECanbMboxes.MBOX21.MSGID.bit.STDMSGID = 21;
    ECanbMboxes.MBOX22.MSGID.bit.STDMSGID = 22;
    ECanbMboxes.MBOX23.MSGID.bit.STDMSGID = 23;
    ECanbMboxes.MBOX24.MSGID.bit.STDMSGID = 24;
    ECanbMboxes.MBOX25.MSGID.bit.STDMSGID = 25;
    ECanbMboxes.MBOX26.MSGID.bit.STDMSGID = 26;
    ECanbMboxes.MBOX27.MSGID.bit.STDMSGID = 27;
    ECanbMboxes.MBOX28.MSGID.bit.STDMSGID = 28;
    ECanbMboxes.MBOX29.MSGID.bit.STDMSGID = 29;
    ECanbMboxes.MBOX30.MSGID.bit.STDMSGID = 30;
    ECanbMboxes.MBOX31.MSGID.bit.STDMSGID = 31;
    ECanbMboxes.MBOX0.MSGID.bit.STDMSGID = 32;
	
/* Configure CAN-A Mailboxes as Receive mailboxes */

	ECanaShadow.CANMD.all = ECanaRegs.CANMD.all;	
	ECanaShadow.CANMD.all = 0xFFFFFFFF;
	ECanaRegs.CANMD.all = ECanaShadow.CANMD.all; 
	
/* Configure CAN-B Mailboxes as Transmit mailboxes */

	ECanbShadow.CANMD.all = ECanbRegs.CANMD.all;
	ECanbShadow.CANMD.all = 0x00000000;
	ECanbRegs.CANMD.all = ECanbShadow.CANMD.all;

/* Enable Mailboxes */
	
	ECanaShadow.CANME.all = ECanaRegs.CANME.all;	
	ECanaShadow.CANME.all = 0xFFFFFFFF;
	ECanaRegs.CANME.all = ECanaShadow.CANME.all; 
	
	ECanbShadow.CANME.all = ECanbRegs.CANME.all;
	ECanbShadow.CANME.all = 0xFFFFFFFF;
	ECanbRegs.CANME.all = ECanbShadow.CANME.all;

/* Begin receiving */

    while(1) 							
    {
     ECanbRegs.CANTRS.all = 0xFFFFFFFF;
     while(ECanbRegs.CANTRS.all != 0x00000000) {}  // Wait for all TRSn to clear
     ECanbRegs.CANTA.all = 0xFFFFFFFF;
     while(ECanaRegs.CANRMP.all != 0xFFFFFFFF) {}  // Wait for all RMPn to be set..
     ECanaRegs.CANRMP.all = 0xFFFFFFFF;			   // Clear all RMPn bits and start 
     RXCOUNT++ ;		                           // all over again...
     if(RXCOUNT==1000){break;}
    }   										   
ESTOP0;
}


/* Zero-out the MBX RAM of CAN-A */

void MBXwrA()
    {
    int j;
    volatile struct MBOX *Mailbox  = (void *) 0x6100;

        for(j=0; j<32; j++)
        {
            Mailbox->MSGID.all = 0;
            Mailbox->MSGCTRL.all = 0;
            Mailbox->MDH.all = 0;
            Mailbox->MDL.all = 0;
            Mailbox = Mailbox + 1;

        }
    }

/* Initialize the MBX RAM of CAN-B */

void MBXwrB()
    {
    int j;
    volatile struct MBOX *Mailbox  = (void *) 0x6300;

        for(j=0; j<32; j++)
        {
            Mailbox->MSGID.all = 0;
            Mailbox->MSGCTRL.bit.DLC = 8;
            Mailbox->MDH.all = 0x01234567;
            Mailbox->MDL.all = 0X89ABCDEF;
            Mailbox = Mailbox + 1;

        }
    }


/*
    Note: If writing only to the 11-bit identifier as by
    "ECanaMboxes.MBOX1.MSGID.bit.STDMSGID = 1;", IDE, AME & AAM bit fields also
    need to be initialized. Otherwise, they may assume random values. This could
    be done by just initializing the entire register to zero first and then writing
    the STD MSG ID.

*/ 
