// TI Release: 28xx eCAN programming example
// Release Date: Fri Aug 4 2017
// Copyright:
// Copyright (C) 2017 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/*********************************************************************
* Filename: TRPRTSTP_A.c
*                                                                    
* Description: This example illustrates the programmable transmit-priority
* and time stamping feature of the CAN module. 
* 
* When a priority is assigned, transmission will be according to the
* assigned transmit priority, not the numerical value of the mailbox ID.
* All mailboxes are configured for transmit operation and all TRS.n bits
* are set at the same time. Transmit priority is assigned randomly. 
* The received data may be monitored on a CAN bus analyzer to check if data was
* transmitted according to the assigned priority. The MOTS registers may 
* also be checked on the transmitting node.
*
*
*********************************************************************/

//
// Included Files
//
#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File

long      i;

void InitECan(void);

main() 
{

/* Kill Watchdog, Init PLL, Enable peripheral clocks */

        InitSysCtrl();

/* Initialize the CAN module */

        InitECan();
        InitECanGpio();

        EALLOW;
 
 /* Write to the MSGID field of TRANSMIT mailboxes MBOX0 - 31 */
    
    ECanaMboxes.MBOX0.MSGID.all = 0x9555AA00; 
    ECanaMboxes.MBOX1.MSGID.all = 0x9555AA01; 
    ECanaMboxes.MBOX2.MSGID.all = 0x9555AA02; 
    ECanaMboxes.MBOX3.MSGID.all = 0x9555AA03; 
    ECanaMboxes.MBOX4.MSGID.all = 0x9555AA04; 
    ECanaMboxes.MBOX5.MSGID.all = 0x9555AA05; 
    ECanaMboxes.MBOX6.MSGID.all = 0x9555AA06; 
    ECanaMboxes.MBOX7.MSGID.all = 0x9555AA07; 
    ECanaMboxes.MBOX8.MSGID.all = 0x9555AA08; 
    ECanaMboxes.MBOX9.MSGID.all = 0x9555AA09; 
    ECanaMboxes.MBOX10.MSGID.all = 0x9555AA10; 
    ECanaMboxes.MBOX11.MSGID.all = 0x9555AA11; 
    ECanaMboxes.MBOX12.MSGID.all = 0x9555AA12; 
    ECanaMboxes.MBOX13.MSGID.all = 0x9555AA13; 
    ECanaMboxes.MBOX14.MSGID.all = 0x9555AA14; 
    ECanaMboxes.MBOX15.MSGID.all = 0x9555AA15; 
    
    ECanaMboxes.MBOX16.MSGID.all = 0x9555AA16; 
    ECanaMboxes.MBOX17.MSGID.all = 0x9555AA17; 
    ECanaMboxes.MBOX18.MSGID.all = 0x9555AA18; 
    ECanaMboxes.MBOX19.MSGID.all = 0x9555AA19; 
    ECanaMboxes.MBOX20.MSGID.all = 0x9555AA20; 
    ECanaMboxes.MBOX21.MSGID.all = 0x9555AA21; 
    ECanaMboxes.MBOX22.MSGID.all = 0x9555AA22; 
    ECanaMboxes.MBOX23.MSGID.all = 0x9555AA23; 
    ECanaMboxes.MBOX24.MSGID.all = 0x9555AA24; 
    ECanaMboxes.MBOX25.MSGID.all = 0x9555AA25; 
    ECanaMboxes.MBOX26.MSGID.all = 0x9555AA26; 
    ECanaMboxes.MBOX27.MSGID.all = 0x9555AA27; 
    ECanaMboxes.MBOX28.MSGID.all = 0x9555AA28; 
    ECanaMboxes.MBOX29.MSGID.all = 0x9555AA29; 
    ECanaMboxes.MBOX30.MSGID.all = 0x9555AA30; 
    ECanaMboxes.MBOX31.MSGID.all = 0x9555AA31; 
 
 /* Configure Mailboxes 0-31 as Tx */

	ECanaRegs.CANMD.all = 0x00000000; 
	
/* Enable all Mailboxes */
	
	ECanaRegs.CANME.all = 0xFFFFFFFF;    

/* Write to Master Control field - DLC */
 
    ECanaMboxes.MBOX0.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX1.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX2.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX3.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX4.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX5.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX6.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX7.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX8.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX9.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX10.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX11.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX12.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX13.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX14.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX15.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX16.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX17.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX18.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX19.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX20.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX21.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX22.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX23.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX24.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX25.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX26.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX27.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX28.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX29.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX30.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX31.MSGCTRL.bit.DLC = 8;        
    
/* Set transmit priority level - Random priorities are assigned 
	Uncomment following block to check out the TPL mechanism */
    
    ECanaMboxes.MBOX20.MSGCTRL.bit.TPL = 31;
    ECanaMboxes.MBOX4.MSGCTRL.bit.TPL = 30;
    ECanaMboxes.MBOX9.MSGCTRL.bit.TPL = 29;
    ECanaMboxes.MBOX26.MSGCTRL.bit.TPL = 28;
    ECanaMboxes.MBOX15.MSGCTRL.bit.TPL = 27;
    ECanaMboxes.MBOX0.MSGCTRL.bit.TPL = 26;
    ECanaMboxes.MBOX7.MSGCTRL.bit.TPL = 25;
    ECanaMboxes.MBOX23.MSGCTRL.bit.TPL = 24;
    ECanaMboxes.MBOX11.MSGCTRL.bit.TPL = 23;
    ECanaMboxes.MBOX17.MSGCTRL.bit.TPL = 22;
    ECanaMboxes.MBOX27.MSGCTRL.bit.TPL = 21;
    ECanaMboxes.MBOX13.MSGCTRL.bit.TPL = 20;
    ECanaMboxes.MBOX18.MSGCTRL.bit.TPL = 19;
    ECanaMboxes.MBOX2.MSGCTRL.bit.TPL = 18;
    ECanaMboxes.MBOX24.MSGCTRL.bit.TPL = 17;
    ECanaMboxes.MBOX29.MSGCTRL.bit.TPL = 16;
    ECanaMboxes.MBOX12.MSGCTRL.bit.TPL = 15;
    ECanaMboxes.MBOX16.MSGCTRL.bit.TPL = 14;
    ECanaMboxes.MBOX31.MSGCTRL.bit.TPL = 13;
    ECanaMboxes.MBOX22.MSGCTRL.bit.TPL = 12;
    ECanaMboxes.MBOX19.MSGCTRL.bit.TPL = 11;
    ECanaMboxes.MBOX21.MSGCTRL.bit.TPL = 10;
    ECanaMboxes.MBOX1.MSGCTRL.bit.TPL = 9;
    ECanaMboxes.MBOX30.MSGCTRL.bit.TPL = 8;
    ECanaMboxes.MBOX28.MSGCTRL.bit.TPL = 7;
    ECanaMboxes.MBOX25.MSGCTRL.bit.TPL = 6;
    ECanaMboxes.MBOX10.MSGCTRL.bit.TPL = 5;
    ECanaMboxes.MBOX3.MSGCTRL.bit.TPL = 4;
    ECanaMboxes.MBOX8.MSGCTRL.bit.TPL = 3;
    ECanaMboxes.MBOX5.MSGCTRL.bit.TPL = 2;
    ECanaMboxes.MBOX14.MSGCTRL.bit.TPL = 1;
    ECanaMboxes.MBOX6.MSGCTRL.bit.TPL = 0;
    
/* If no transmit priority is assigned, transmit sequence will be starting
   with the mailbox with the highest priority, which will be the
   mailbox with the numerically highest ID. 31,30,29.........2,1,0 
   Uncomment the following block to try this out   */
   
    /*ECanaMboxes.MBOX20.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX4.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX9.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX26.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX15.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX0.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX7.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX23.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX11.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX17.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX27.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX13.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX18.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX2.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX24.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX29.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX12.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX16.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX31.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX22.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX19.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX21.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX1.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX30.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX28.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX25.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX10.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX3.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX8.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX5.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX14.MSGCTRL.bit.TPL = 0;
    ECanaMboxes.MBOX6.MSGCTRL.bit.TPL = 0; */
    
/* Write to the mailbox RAM field of MBOX0 - 31 */
    
     ECanaMboxes.MBOX0.MDL.all = 0x00000000;
	 ECanaMboxes.MBOX0.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX1.MDL.all = 0x00000001;
	 ECanaMboxes.MBOX1.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX2.MDL.all = 0x00000002;
	 ECanaMboxes.MBOX2.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX3.MDL.all = 0x00000003;
	 ECanaMboxes.MBOX3.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX4.MDL.all = 0x00000004;
	 ECanaMboxes.MBOX4.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX5.MDL.all = 0x00000005;
	 ECanaMboxes.MBOX5.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX6.MDL.all = 0x00000006;
	 ECanaMboxes.MBOX6.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX7.MDL.all = 0x00000007;
	 ECanaMboxes.MBOX7.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX8.MDL.all = 0x00000008;
	 ECanaMboxes.MBOX8.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX9.MDL.all = 0x00000009;
	 ECanaMboxes.MBOX9.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX10.MDL.all = 0x00000010;
	 ECanaMboxes.MBOX10.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX11.MDL.all = 0x00000011;
	 ECanaMboxes.MBOX11.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX12.MDL.all = 0x00000012;
	 ECanaMboxes.MBOX12.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX13.MDL.all = 0x00000013;
	 ECanaMboxes.MBOX13.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX14.MDL.all = 0x00000014;
	 ECanaMboxes.MBOX14.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX15.MDL.all = 0x00000015;
	 ECanaMboxes.MBOX15.MDH.all = 0x00000000;	 
	 
	 ECanaMboxes.MBOX16.MDL.all = 0x00000016;
	 ECanaMboxes.MBOX16.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX17.MDL.all = 0x00000017;
	 ECanaMboxes.MBOX17.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX18.MDL.all = 0x00000018;
	 ECanaMboxes.MBOX18.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX19.MDL.all = 0x00000019;
	 ECanaMboxes.MBOX19.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX20.MDL.all = 0x00000020;
	 ECanaMboxes.MBOX20.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX21.MDL.all = 0x00000021;
	 ECanaMboxes.MBOX21.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX22.MDL.all = 0x00000022;
	 ECanaMboxes.MBOX22.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX23.MDL.all = 0x00000023;
	 ECanaMboxes.MBOX23.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX24.MDL.all = 0x00000024;
	 ECanaMboxes.MBOX24.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX25.MDL.all = 0x00000025;
	 ECanaMboxes.MBOX25.MDH.all = 0x00000000;	 
	 
	 ECanaMboxes.MBOX26.MDL.all = 0x00000026;
	 ECanaMboxes.MBOX26.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX27.MDL.all = 0x00000027;
	 ECanaMboxes.MBOX27.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX28.MDL.all = 0x00000028;
	 ECanaMboxes.MBOX28.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX29.MDL.all = 0x00000029;
	 ECanaMboxes.MBOX29.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX30.MDL.all = 0x00000030;
	 ECanaMboxes.MBOX30.MDH.all = 0x00000000;
	 
	 ECanaMboxes.MBOX31.MDL.all = 0x00000031;
	 ECanaMboxes.MBOX31.MDH.all = 0x00000000;
		 
	 ECanaRegs.CANMIM.all = 0xFFFFFFFF;
          
/* Begin transmitting */

     ECanaRegs.CANTRS.all = 0xFFFFFFFF;            // Set TRS for all transmit mailboxes
     while(ECanaRegs.CANTA.all != 0xFFFFFFFF ) {}  // Wait for all TAn bits to be set..
     ECanaRegs.CANTA.all = 0xFFFFFFFF;			   // Clear all TAn       

    asm("     ESTOP0");							   // Stop here after transmission

}

/* 

Note 1: If all 32-bits are written to (or read from) in a register, the register
may be written to without using a shadow register, as illustrated
in this code example.



... */ 
