// TI Release: 28xx eCAN programming example
// Release Date: Fri Aug 4 2017
// Copyright:
// Copyright (C) 2017 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/*********************************************************************
* Filename: TXLOOP_A.c                                                 *
*                                                                    *
* Description: TXLOOP - Transmit loop using any mailbox 	
* 
* Mailbox 25 is shown as an example...
* This example TRANSMITS data to another CAN module using MAILBOX25
* This program could either loop forever or transmit "n" # of times,	
* where "n" is the TXCOUNT value.
*          
*********************************************************************/

//
// Included Files
//
#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File

#define TXCOUNT  100000  // Transmission will take place (TXCOUNT) times..

long      i;
long 	  loopcount = 0;

main()
{

/* Create a shadow register structure for the CAN control registers. 

This is needed since only 32-bit access is allowed to these registers. 16-bit access
 to these registers could potentially corrupt the register contents. This is
 especially true while writing to a bit (or group of bits) among bits 16 - 31 */

struct ECAN_REGS ECanaShadow;

/* Kill Watchdog, Init PLL, Enable peripheral clocks */

	InitSysCtrl();
	
/* Initialize the CAN module */

	InitECana();	
	InitECanGpio();
	
	EALLOW;

/* Write to the MSGID field  */
    
    ECanaMboxes.MBOX25.MSGID.all = 0x95555555; // Extended Identifier
       
/* Configure Mailbox under test as a Transmit mailbox */

	ECanaShadow.CANMD.all = ECanaRegs.CANMD.all;	
	ECanaShadow.CANMD.bit.MD25 = 0;
	ECanaRegs.CANMD.all = ECanaShadow.CANMD.all; 
	
/* Enable Mailbox under test */
	
	ECanaShadow.CANME.all = ECanaRegs.CANME.all;	
	ECanaShadow.CANME.bit.ME25 = 1;
	ECanaRegs.CANME.all = ECanaShadow.CANME.all; 
	
/* Write to DLC field in Message Control reg */

	ECanaMboxes.MBOX25.MSGCTRL.bit.DLC = 8;
	
/* Write to the mailbox RAM field */
    
     ECanaMboxes.MBOX25.MDL.all = 0x55555555;
	 ECanaMboxes.MBOX25.MDH.all = 0x55555555;	 
	 	
/* Begin transmitting */

    while(1)     							// Uncomment this line for infinite transmissions
    //for(i=0; i < TXCOUNT; i++)				// Uncomment this line for finite transmissions			  	
    {
     ECanaShadow.CANTRS.all = 0; 	
     ECanaShadow.CANTRS.bit.TRS25 = 1;     // Set TRS for mailbox under test       
     ECanaRegs.CANTRS.all = ECanaShadow.CANTRS.all; 

     ECanaShadow.CANTA.all = ECanaRegs.CANTA.all;
		do {ECanaShadow.CANTA.all = ECanaRegs.CANTA.all;}	// Wait for TA25 bit to be set..
         while(ECanaShadow.CANTA.bit.TA25 == 0 );      
     
     ECanaShadow.CANTA.all = 0; 	
     ECanaShadow.CANTA.bit.TA25 = 1;     	 // Clear TA5       
     ECanaRegs.CANTA.all = ECanaShadow.CANTA.all;
     
     loopcount ++; 			    
    }  
     asm(" ESTOP0"); 
}


/* Notes:
A simple testcase that could be used to transmit data out of a mailbox


Last update: 7/22/2017     (Tested)
*/

