//###########################################################################
//
// FILE:   F2837xD_Sci.c
//
// TITLE:  F2837xD SCI Initialization & Support Functions.
//
//###########################################################################
// $TI Release: F2837xD Support Library v3.02.00.00 $
// $Release Date: Sat Sep 16 15:29:00 CDT 2017 $
// $Copyright:
// Copyright (C) 2013-2017 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING//###########################################################################
//
// FILE:   F2837xD_Sci.c
//
// TITLE:  F2837xD SCI Initialization & Support Functions.
//
//###########################################################################
// $TI Release: F2837xD Support Library v3.02.00.00 $
// $Release Date: Sat Sep 16 15:29:00 CDT 2017 $
// $Copyright:
// Copyright (C) 2013-2017 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//
//   Redistributions of source code must retain the above copyright
//   notice, this list of conditions and the following disclaimer.
//
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the
//   documentation and/or other materials provided with the
//   distribution.
//
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################

#include "F2837xD_device.h"     // F2837xD Headerfile Include File
#include "F2837xD_Examples.h"   // F2837xD Examples Include File
#include <ti/sysbios/knl/Semaphore.h>
#include <xdc/cfg/global.h>


//#include "CSerialDataLink.h"

// Defines
//
#define CPU_FREQ        200E6
#define LSPCLK_FREQ     CPU_FREQ/4
#define SCI_FREQ        115200//100E3
#define SCI_PRD         (LSPCLK_FREQ/(SCI_FREQ*8))-1

Uint16 sdataA[2];    // Send data for SCI-A
Uint16 rdataA[2];    // Received data for SCI-A
Uint16 rdata_pointA; // Used for checking the received data


//    void ISR_PhysicalLayer_rxa(void);
//    void ISR_PhysicalLayer_Tx(void);
//}
#define MAX_SCIA_RECIEVED_CHARS_BUFFER 32

Uint16 uiSciaNextRecievedCharEntry;  // pointer to the entry in the recieved buffer array of the last recieved chrecter data
Uint16 theSciaReceivedCharBuffer[MAX_SCIA_RECIEVED_CHARS_BUFFER];   // scia received characters
Uint16 theSciaTransmitCharBuffer[MAX_SCIA_RECIEVED_CHARS_BUFFER];   // scia transmit character
// pointers to the start and end entry in the transmit buffer array of the last Transmit chrecter data
Uint16 uiSciaTransmitCharStartEntry;
Uint16 uiSciaTransmitCharEndEntry;
Bool bFirstStartTransmmition;

// Prototype statements for functions found within this file.
void InitSciGpio(void);
void InitSciaGpio(void);
void InitScibGpio(void);
void InitScicGpio(void);
void scia_fifo_init(void);
void scib_fifo_init(void);
void scic_fifo_init(void);
void scia_xmit(int a);
void error(void);

void InitSciGpio()
{
    InitSciaGpio();
}

void InitScicGpio()
{

//
//  init the pins for the SCI-C port.
//  GPIO_SetupPinMux() - Sets the GPxMUX1/2 and GPyMUX1/2 register bits
//  GPIO_SetupPinOptions() - Sets the direction and configuration of the GPIOS
// These functions are found in the F2837xD_Gpio.c file.
//
   GPIO_SetupPinMux(139, GPIO_MUX_CPU1, 6);
   GPIO_SetupPinOptions(139, GPIO_INPUT, GPIO_PUSHPULL);
   GPIO_SetupPinMux(140, GPIO_MUX_CPU1, 6);
   GPIO_SetupPinOptions(140, GPIO_OUTPUT, GPIO_ASYNC);
}

void InitScibGpio()
{

//
//  init the pins for the SCI-C port.
//  GPIO_SetupPinMux() - Sets the GPxMUX1/2 and GPyMUX1/2 register bits
//  GPIO_SetupPinOptions() - Sets the direction and configuration of the GPIOS
// These functions are found in the F2837xD_Gpio.c file.
//
   GPIO_SetupPinMux(138, GPIO_MUX_CPU1, 6);
   GPIO_SetupPinOptions(138, GPIO_INPUT, GPIO_PUSHPULL);
   GPIO_SetupPinMux(137, GPIO_MUX_CPU1, 6);
   GPIO_SetupPinOptions(137, GPIO_OUTPUT, GPIO_ASYNC);
}

void InitSciaGpio()
{

//
//  init the pins for the SCI-A port.
//  GPIO_SetupPinMux() - Sets the GPxMUX1/2 and GPyMUX1/2 register bits
//  GPIO_SetupPinOptions() - Sets the direction and configuration of the GPIOS
// These functions are found in the F2837xD_Gpio.c file.
//
   GPIO_SetupPinMux(28, GPIO_MUX_CPU1, 1);
   GPIO_SetupPinOptions(28, GPIO_INPUT, GPIO_PUSHPULL);
   GPIO_SetupPinMux(29, GPIO_MUX_CPU1, 1);
   GPIO_SetupPinOptions(29, GPIO_OUTPUT, GPIO_ASYNC);
}


void scia_fifo_init()
{
   SciaRegs.SCICCR.all = 0x0007;      // 1 stop bit,  No loopback
                                      // No parity,8 char bits,
                                      // async mode, idle-line protocol
   SciaRegs.SCICTL1.all = 0x0003;     // enable TX, RX, internal SCICLK,
                                      // Disable RX ERR, SLEEP, TXWAKE
   SciaRegs.SCICTL2.bit.TXINTENA = 1;
   SciaRegs.SCICTL2.bit.RXBKINTENA = 1;
   SciaRegs.SCIHBAUD.all = 0x0000;
   SciaRegs.SCILBAUD.all = SCI_PRD;
   SciaRegs.SCICCR.bit.LOOPBKENA = 0; // Enable loop back
   SciaRegs.SCIFFTX.all = 0xC022;
   SciaRegs.SCIFFRX.all = 0x0022;
   SciaRegs.SCIFFCT.all = 0x00;

   SciaRegs.SCICTL1.all = 0x0023;     // Relinquish SCI from Reset
   SciaRegs.SCIFFTX.bit.TXFIFORESET = 1;
   SciaRegs.SCIFFRX.bit.RXFIFORESET = 1;
}


void scib_fifo_init()
{
   ScibRegs.SCICCR.all = 0x0007;      // 1 stop bit,  No loopback
                                      // No parity,8 char bits,
                                      // async mode, idle-line protocol
   ScibRegs.SCICTL1.all = 0x0003;     // enable TX, RX, internal SCICLK,
                                      // Disable RX ERR, SLEEP, TXWAKE
   ScibRegs.SCICTL2.bit.TXINTENA = 1;
   ScibRegs.SCICTL2.bit.RXBKINTENA = 1;
   ScibRegs.SCIHBAUD.all = 0x0000;
   ScibRegs.SCILBAUD.all = SCI_PRD;
   ScibRegs.SCICCR.bit.LOOPBKENA = 0; // Enable loop back
   ScibRegs.SCIFFTX.all = 0xC022;
   ScibRegs.SCIFFRX.all = 0x0022;
   ScibRegs.SCIFFCT.all = 0x00;

   ScibRegs.SCICTL1.all = 0x0023;     // Relinquish SCI from Reset
   ScibRegs.SCIFFTX.bit.TXFIFORESET = 1;
   ScibRegs.SCIFFRX.bit.RXFIFORESET = 1;
}

void scic_fifo_init()
{
   ScicRegs.SCICCR.all = 0x0007;      // 1 stop bit,  No loopback
                                      // No parity,8 char bits,
                                      // async mode, idle-line protocol
   ScicRegs.SCICTL1.all = 0x0003;     // enable TX, RX, internal SCICLK,
                                      // Disable RX ERR, SLEEP, TXWAKE

   ScicRegs.SCICTL2.all = 0x0003;

   //ScicRegs.SCICTL2.bit.TXINTENA = 1;
   //ScicRegs.SCICTL2.bit.RXBKINTENA = 1;


   ScicRegs.SCIHBAUD.all = 0x0000;
   ScicRegs.SCILBAUD.all = SCI_PRD;

   ScicRegs.SCICCR.bit.LOOPBKENA = 0; // Enable loop back


   ScicRegs.SCIFFTX.all = 0xC022;
   ScicRegs.SCIFFRX.all = 0x0022;
   ScicRegs.SCIFFCT.all = 0x00;

   ScicRegs.SCICTL1.all = 0x0023;     // Relinquish SCI from Reset
   ScicRegs.SCIFFTX.bit.TXFIFORESET = 1;
   ScicRegs.SCIFFRX.bit.RXFIFORESET = 1;




   Uint16 i;


   for(i = 0; i<2; i++)
    {
       sdataA[i] = i;
    }

    rdata_pointA = sdataA[0];


 }

void ISR_PhysicalLayer_rxa_org(void)     // SCI-C
{
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP8;

    // Must to do in order to resolve errors during start up
    if (ScicRegs.SCIRXST.bit.RXERROR == 1)
    {
        // Error occured
        ScicRegs.SCICTL1.bit.SWRESET = 0;
        ScicRegs.SCICTL1.bit.SWRESET = 1;
        ScicRegs.SCIFFRX.bit.RXFFINTCLR = 1;   // clear Receive interrupt flag
        return;
    }

    // Save the recieved data into the data buffer
//    theSciaReceivedCharBuffer[uiSciaNextRecievedCharEntry] = ScicRegs.SCIRXBUF.all;
    // code from buttom To top
    // Set the new data buffer entry
    uiSciaNextRecievedCharEntry ++;
    if (uiSciaNextRecievedCharEntry == MAX_SCIA_RECIEVED_CHARS_BUFFER)
    {
        uiSciaNextRecievedCharEntry = 0;
    }
    // Signal the lynk layer that a new data byte was recieved
//    Semaphore_post(SEM_SCIA_BYTE_RECEIVED);
    ScicRegs.SCIFFRX.bit.RXFFINTCLR = 1;    // clear Receive interrupt flag
}

void error(void)
{
    asm("     ESTOP0"); // Test failed!! Stop!
    for (;;);
}

void ISR_PhysicalLayer_rxa(void)
{
    Uint16 i;

  //  for(i=0;i<2;i++)
  //  {
  //     rdataA[i]=ScicRegs.SCIRXBUF.all;  // Read data
  //  }

  //  for(i=0;i<2;i++)                     // Check received data
  //  {
  //     if(rdataA[i] != ( (rdata_pointA+i) & 0x00FF) )
  //     {
  //         error();
  //     }
  //  }

  //  rdata_pointA = (rdata_pointA+1) & 0x00FF;


    ScicRegs.SCIFFRX.bit.RXFFOVRCLR=1;   // Clear Overflow flag
    ScicRegs.SCIFFRX.bit.RXFFINTCLR=1;   // Clear Interrupt flag

    PieCtrlRegs.PIEACK.all|=0x80;       // Issue PIE ack
}

/*******************************************************************************
Function Name : ISR_PhysicalLayer_Tx
Description :   Interrupt function for SCI-C transmit byte.
                ISR for PIE INT8.8
                Connected to TXAINT  SCI-C
*******************************************************************************/
void ISR_PhysicalLayer_Tx_org(void)     // SCI-C
{

    if (uiSciaTransmitCharStartEntry != uiSciaTransmitCharEndEntry)
    {
        ScicRegs.SCITXBUF.all = theSciaTransmitCharBuffer[uiSciaTransmitCharStartEntry++];
        if (uiSciaTransmitCharStartEntry == MAX_SCIA_RECIEVED_CHARS_BUFFER)
        {
            uiSciaTransmitCharStartEntry = 0;
        }
    }
    else if (uiSciaTransmitCharStartEntry == uiSciaTransmitCharEndEntry)
    {
        bFirstStartTransmmition = true;
    }
//  ScicRegs.SCIFFTX.bit.TXINTCLR=1;    // Clear SCI Interrupt flag

    PieCtrlRegs.PIEACK.all |= PIEACK_GROUP8;        // Must acknowledge the PIE group
}

void ISR_PhysicalLayer_Tx(void)
{
    Uint16 i;

    for(i=0; i< 2; i++)
    {
       ScicRegs.SCITXBUF.all=sdataA[i];  // Send data
    }

    for(i=0; i< 2; i++)                  // Increment send data for next cycle
    {
       sdataA[i] = (sdataA[i]+1) & 0x00FF;

    }

    ScicRegs.SCIFFTX.bit.TXFFINTCLR=1;   // Clear SCI Interrupt flag
    PieCtrlRegs.PIEACK.all|=PIEACK_GROUP8;//0x80;       // Issue PIE ACK
}


/*******************************************************************************
Function Name : PhysicalLayer_scia_xmit
Description :   This function transmit a character from the SCI-C.
*******************************************************************************/
void scia_xmit(int a) // Not in Use !!!
{
//    while (ScicRegs.SCIFFTX.bit.TXFFST != 0) {}   // wait until the transmit fifo is empty
    while (ScicRegs.SCICTL2.bit.TXRDY != 1) {}  // wait until the SCITXBUF is ready to recieve another set of data
    ScicRegs.SCITXBUF.all = a;
}
//
// End of file


