// **************************************************************************
// *            Constants.h
// **************************************************************************
// **************************************************************************
// *
// * This information is proprietary to Eaton
// *
// **************************************************************************
// *
// *  Copyright (c) 2012 Eaton
// *    ALL RIGHTS RESERVED
// *
// **************************************************************************
/// \file       Constants.h
/// \author     Original by Kevin VanEyll (2/19/2010)
///             Converted to Solar by Eric J. Zimmerman
/// \ingroup    Main
/// \brief      Contains common constants and conditional compile defines.
// **************************************************************************

#ifndef _CONSTANTS_H
#define _CONSTANTS_H

#include <stdint.h>

//#define Thermal_Management 1

//#define USE_VIRTUALGRID
//#define USE_VIRTUALIO
//#define USE_TIMEMEASUREMENT
//#define ENABLE_LVRTTEST
//#define USE_OPTIMIZED_FIR
//#define ENABLE_MEDIUM_CHANNELS
//#define ENABLE_QL_DIVISOR
//#define USE_FLOW_METER
//#define ALLOW_MPPT
#define ENABLE_HS_MONITORING
#define ENABLE_MFIO
#define ENABLE_RECONNECTRAMP_FEATURE
#define STAGGER_PRECHARGE
#define ALLOW_CARRIERFREQ_CHANGE
//#define USE_NEWCALIBRATIONMETHOD

// This is a unique identifier for this application
//#define CPUFrequency            ( 150000000UL )
//#define PWMFrequency            ( 1806UL )
//#define ADCFrequency            ( (PWMFrequency * 16UL) )
//#define DacFrequency            ( (PWMFrequency * 8UL) )
#define CPUFrequency    (         150000000UL )  // Hz
#define PWMFrequency    (             10000UL )  // Hz
#define TRIANGLE_PEAK   (( CPUFrequency / PWMFrequency ) / 2UL)  // counts
#define TRIANGLE_PERIOD (( CPUFrequency / PWMFrequency ) / 2UL)  // counts
//#define OCPWMFrequency  (             15900UL )  // Hz
//#define OCPWM_PERIOD    ( CPUFrequency / OCPWMFrequency )  // counts
#define BDPWMFrequency  (             10000UL )  // Hz
#define BDPWM_PERIOD    ( CPUFrequency / BDPWMFrequency )  // counts

#define SQRT_2                  ( (float)1.414213562 )
#define SQRT_3                  ( (float)1.732050807 )
#define SQRT_3_DIV3             ( (float)0.577350269 )
#define ONE_DIV_SQRT_3          ( (float)0.577350269 )

#define OS_PRD_TICK_MS          1

#define TSK_5_ms                ( 5    / OS_PRD_TICK_MS )
#define TSK_10_ms               ( 10   / OS_PRD_TICK_MS )
#define TSK_20_ms               ( 20   / OS_PRD_TICK_MS )
#define TSK_50_ms               ( 50   / OS_PRD_TICK_MS )
#define TSK_100_ms              ( 100  / OS_PRD_TICK_MS )
#define TSK_200_ms              ( 200  / OS_PRD_TICK_MS )
#define TSK_1000_ms             ( 1000 / OS_PRD_TICK_MS )

// from stdint.h, copied here for reference
//     typedef          int         int16_t;
//     typedef unsigned int         uint16_t;
//     typedef          long        int32_t;
//     typedef unsigned long        uint32_t;
//     typedef          long long   int64_t;
//     typedef unsigned long long   uint64_t;

typedef unsigned char           uint8_t;
typedef signed char             int8_t;
typedef int8_t                  err_t;
typedef uint8_t                 bool_t;
#define ERR_OK                  0
#define ERR_READONLY            -13

typedef struct
{
    float phA;
    float phB;
    float phC;
} stThreePhase;

#define BIT_0                   ( (uint32_t)( 1UL ) )
#define BIT_1                   ( (uint32_t)( 1UL << 1 ) )
#define BIT_2                   ( (uint32_t)( 1UL << 2 ) )
#define BIT_3                   ( (uint32_t)( 1UL << 3 ) )
#define BIT_4                   ( (uint32_t)( 1UL << 4 ) )
#define BIT_5                   ( (uint32_t)( 1UL << 5 ) )
#define BIT_6                   ( (uint32_t)( 1UL << 6 ) )
#define BIT_7                   ( (uint32_t)( 1UL << 7 ) )
#define BIT_8                   ( (uint32_t)( 1UL << 8 ) )
#define BIT_9                   ( (uint32_t)( 1UL << 9 ) )
#define BIT_10                  ( (uint32_t)( 1UL << 10 ) )
#define BIT_11                  ( (uint32_t)( 1UL << 11 ) )
#define BIT_12                  ( (uint32_t)( 1UL << 12 ) )
#define BIT_13                  ( (uint32_t)( 1UL << 13 ) )
#define BIT_14                  ( (uint32_t)( 1UL << 14 ) )
#define BIT_15                  ( (uint32_t)( 1UL << 15 ) )

#define BIT_16                  ( (uint32_t)( BIT_0 << 16 ) )
#define BIT_17                  ( (uint32_t)( BIT_1 << 16 ) )
#define BIT_18                  ( (uint32_t)( BIT_2 << 16 ) )
#define BIT_19                  ( (uint32_t)( BIT_3 << 16 ) )
#define BIT_20                  ( (uint32_t)( BIT_4 << 16 ) )
#define BIT_21                  ( (uint32_t)( BIT_5 << 16 ) )
#define BIT_22                  ( (uint32_t)( BIT_6 << 16 ) )
#define BIT_23                  ( (uint32_t)( BIT_7 << 16 ) )
#define BIT_24                  ( (uint32_t)( BIT_8 << 16 ) )
#define BIT_25                  ( (uint32_t)( BIT_9 << 16 ) )
#define BIT_26                  ( (uint32_t)( BIT_10 << 16 ) )
#define BIT_27                  ( (uint32_t)( BIT_11 << 16 ) )
#define BIT_28                  ( (uint32_t)( BIT_12 << 16 ) )
#define BIT_29                  ( (uint32_t)( BIT_13 << 16 ) )
#define BIT_30                  ( (uint32_t)( BIT_14 << 16 ) )
#define BIT_31                  ( (uint32_t)( BIT_15 << 16 ) )

// [69.44 us]
// 0.001 [ f(2000) --> 100 ]
#define MS_TO_69R4US_TICKS(x)       ((x) * 14)

// 0.01 [ f(200) --> 100 ]
#define CS_TO_69R4US_TICKS(x)       ((x) * 144)

// 0.1 [ f(20) --> 100 ]
#define DS_TO_69R4US_TICKS(x)       ((x) * 1438)

// 1 [ f(2) --> 100 ]
#define SEC_TO_69R4US_TICKS(x)      ((x) * 14384)

// [277.777 us]
// 0.001 [ f(2000) --> 100 ]
#define MS_TO_277R7US_TICKS(x)       ((x) * 4UL)

// 0.01 [ f(200) --> 100 ]
#define CS_TO_277R7US_TICKS(x)       ((x) * 36UL)

// 0.1 [ f(20) --> 100 ]
#define DS_TO_277R7US_TICKS(x)       ((x) * 360UL)

// 1 [ f(2) --> 100 ]
#define SEC_TO_277R7US_TICKS(x)      ((x) * 3600UL)

// [556.173 us]
// 0.001 [ f(2000) --> 100 ]
#define MS_TO_556R7US_TICKS(x)       ((x) * 2UL)

// 0.01 [ f(200) --> 100 ]
#define CS_TO_556R7US_TICKS(x)       ((x) * 18UL)

// 0.1 [ f(20) --> 100 ]
#define DS_TO_556R7US_TICKS(x)       ((x) * 180UL)

// 1 [ f(2) --> 100 ]
#define SEC_TO_556R7US_TICKS(x)      ((x) * 1800UL)

// For High-Speed Monitoring Tick Conversion
#define MS_TO_3MS_TICKS(x)          ((x) / 3)
#define MS_TO_24MS_TICKS(x)         ((x) / 24)
#define MS_TO_72MS_TICKS(x)         ((x) / 72)

// [20 MS]
// 0.001 [ f(2000) --> 100 ]
#define MS_TO_20MS_TICKS(x)         ((x) / 20)

// 0.01 [ f(200) --> 100 ]
#define CS_TO_20MS_TICKS(x)         ((x) / 2)

// 0.1 [ f(20) --> 100 ]
#define DS_TO_20MS_TICKS(x)         ((x) * 5)

// 1 [ f(2) --> 100 ]
#define SEC_TO_20MS_TICKS(x)        ((x) * 50)

// [100 MS]
// 0.001 [ f(2000) --> 20 ]
#define MS_TO_100MS_TICKS(x)        ((x) / 100)

// 0.01 [ f(200) --> 20 ]
#define CS_TO_100MS_TICKS(x)        ((x) / 10)

// 0.1 [ f(20) --> 20 ]
#define DS_TO_100MS_TICKS(x)        ((x) * 1)

// 1 [ f(2) --> 20 ]
#define SEC_TO_100MS_TICKS(x)       ((x) * 10)

// [500 MS]
// 0.001 [ f(2000) --> 4 ]
#define MS_TO_500MS_TICKS(x)        ((x) / 500)

// 0.01 [ f(200) --> 4 ]
#define CS_TO_500MS_TICKS(x)        ((x) / 50)

// 0.1 [ f(20) --> 4 ]
#define DS_TO_500MS_TICKS(x)        ((x) / 5)

// 1 [ f(2) --> 4 ]
#define SEC_TO_500MS_TICKS(x)       ((x) * 2)

// Do not use this one anymore
#define HARDWARE_PIB_PANDA9E        0

// New PIB for Solar
#define HARDWARE_PIB_SOLAR_REVA     1

// Original Panda board with new PLD program as of 8/13/2013
#define HARDWARE_PIB_PANDA9ENEWPLD  2

#define HARDWARE                    HARDWARE_PIB_SOLAR_REVA

#if HARDWARE == HARDWARE_PIB_PANDA9E
    #define RTC_IS_INSTALLED
#elif HARDWARE == HARDWARE_PIB_PANDA9ENEWPLD
    #define RTC_IS_INSTALLED
    #define USE_XI2_ISR
#else
    #define TESTCS_IS_INSTALLED
#endif

// The main control board CAN ID is always 1 (for now)
#define MY_CAN_ID                   1

// Comment out if you don't want any broadcasts on Internal CAN channel (CANA)
#define ENABLE_REMOTEIO_CAN_OUT

// Adds an FIR filter to grid voltages, currents and inverter currents.
#define USE_FIRFILTER_CURRENT
#define USE_FIRFILTER_VOLTAGE

// This is for future, if we need to bring in the additional diagnostics from the CAN board
// for Sync troubleshooting.. or to the HMI.
// For the moment, we can see said signals on the PC test app
//#define USE_SYNCDIAGNOSTICS

#define USE_IINV_PIC
#define USE_IINV_PIC_RAMP

// Comment out to disable all extra test bits that allow
// outer loop PI controller testing.
#define ALLOW_IGRID_PI_TESTING

//#define USE_HIL

#define ACPOWER_AVERAGE     0
#define DCPOWER_AVERAGE     1
#define ACPOWER_FILTER      2

#define MPPT_POWERFEEDBACK      ACPOWER_AVERAGE

#define VDCAVG_METHOD0      0
#define VDCAVG_METHOD1      1
#define VDCAVG_METHOD2      2

#define VDCAVERAGE_METHOD   VDCAVG_METHOD1

#endif
// ******************************************************************************************************
// *            End of Constants.h
// ******************************************************************************************************
