/**
 ********************************************************************************************************
 * @file F28335Epwm.cpp
 * @brief Source file for F28335Epwm.h
 * @copyright 2020 Eaton Corporation. All Rights Reserved.
 *********************************************************************************************************
 */
#include "F28335Epwm.h"


/*
 *****************************************************************************************
 * See header file for function definition.
 *****************************************************************************************
 */
void EPWM_SetTimeBaseCounter( pwm_base_t base, uint16_t prd )
{
	switch ( base )
	{
		case EPWM1:
			EPwm1Regs.TBPRD = prd;
			break;

		case EPWM2:
			EPwm2Regs.TBPRD = prd;
			break;

		case EPWM3:
			EPwm3Regs.TBPRD = prd;
			break;

		case EPWM4:
			EPwm4Regs.TBPRD = prd;
			break;

		case EPWM5:
			EPwm5Regs.TBPRD = prd;
			break;

		case EPWM6:
			EPwm6Regs.TBPRD = prd;
			break;

		default:
			break;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.
 *****************************************************************************************
 */
void EPWM_SetCounterCompareValue( pwm_base_t base, epwm_counter_compare_module_t comp_module,
		                          uint16_t comp_count )
{
	switch ( base )
	{
		case EPWM1:
			SetPWM1_Cmp_Val( comp_module, comp_count );
			break;

		case EPWM2:
			SetPWM2_Cmp_Val( comp_module, comp_count );
			break;

		case EPWM3:
			SetPWM3_Cmp_Val( comp_module, comp_count );
			break;

		case EPWM4:
			SetPWM4_Cmp_Val( comp_module, comp_count );
			break;

		case EPWM5:
			SetPWM5_Cmp_Val( comp_module, comp_count );
			break;

		case EPWM6:
			SetPWM6_Cmp_Val( comp_module, comp_count );
			break;

		default:
			break;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM1_Cmp_Val( epwm_counter_compare_module_t comp_module, uint16_t comp_count )		///< HAL Layer
{
	if ( comp_module == EPWM_COUNTER_COMPARE_A )
	{
		EPwm1Regs.CMPA.half.CMPA = comp_count;
	}
	else
	{
		EPwm1Regs.CMPB = comp_count;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM2_Cmp_Val( epwm_counter_compare_module_t comp_module, uint16_t comp_count )		///< HAL Layer
{
	if ( comp_module == EPWM_COUNTER_COMPARE_A )
	{
		EPwm2Regs.CMPA.half.CMPA = comp_count;
	}
	else
	{
		EPwm2Regs.CMPB = comp_count;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM3_Cmp_Val( epwm_counter_compare_module_t comp_module, uint16_t comp_count )		///< HAL Layer
{
	if ( comp_module == EPWM_COUNTER_COMPARE_A )
	{
		EPwm3Regs.CMPA.half.CMPA = comp_count;
	}
	else
	{
		EPwm3Regs.CMPB = comp_count;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM4_Cmp_Val( epwm_counter_compare_module_t comp_module, uint16_t comp_count )		///< HAL Layer
{
	if ( comp_module == EPWM_COUNTER_COMPARE_A )
	{
		EPwm4Regs.CMPA.half.CMPA = comp_count;
	}
	else
	{
		EPwm4Regs.CMPB = comp_count;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM5_Cmp_Val( epwm_counter_compare_module_t comp_module, uint16_t comp_count )		///< HAL Layer
{
	if ( comp_module == EPWM_COUNTER_COMPARE_A )
	{
		EPwm5Regs.CMPA.half.CMPA = comp_count;
	}
	else
	{
		EPwm5Regs.CMPB = comp_count;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM6_Cmp_Val( epwm_counter_compare_module_t comp_module, uint16_t comp_count )		///< HAL Layer
{
	if ( comp_module == EPWM_COUNTER_COMPARE_A )
	{
		EPwm6Regs.CMPA.half.CMPA = comp_count;
	}
	else
	{
		EPwm6Regs.CMPB = comp_count;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.
 *****************************************************************************************
 */
void EPWM_SetEventTriggerInterruptEnable( pwm_base_t base, epwm_event_trigger_enable_t evnt_trig_enbl,
										  bool enable_value )
{
	switch ( base )
	{
		case EPWM1:
			SetPWM1_Evnt_Trig_Int_Enable( evnt_trig_enbl, enable_value );
			break;

		case EPWM2:
			SetPWM2_Evnt_Trig_Int_Enable( evnt_trig_enbl, enable_value );
			break;

		case EPWM3:
			SetPWM3_Evnt_Trig_Int_Enable( evnt_trig_enbl, enable_value );
			break;

		case EPWM4:
			SetPWM4_Evnt_Trig_Int_Enable( evnt_trig_enbl, enable_value );
			break;

		case EPWM5:
			SetPWM5_Evnt_Trig_Int_Enable( evnt_trig_enbl, enable_value );
			break;

		case EPWM6:
			SetPWM6_Evnt_Trig_Int_Enable( evnt_trig_enbl, enable_value );
			break;

		default:
			break;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.
 *****************************************************************************************
 */
void SetPWM1_Evnt_Trig_Int_Enable( epwm_event_trigger_enable_t evnt_trig_enbl, bool enable_value )
{
	if ( evnt_trig_enbl == EPWM_EVT_TRIG_INT_ENBL )
	{
		EPwm1Regs.ETSEL.bit.INTEN = ( enable_value ) ? 1 : 0;
	}
	else if ( evnt_trig_enbl == EPWM_EVT_TRIG_CONV_A_ENBL )
	{
		EPwm1Regs.ETSEL.bit.SOCAEN = ( enable_value ) ? 1 : 0;
	}
	else if ( evnt_trig_enbl == EPWM_EVT_TRIG_CONV_B_ENBL )
	{
		EPwm1Regs.ETSEL.bit.SOCBEN = ( enable_value ) ? 1 : 0;
	}
	else
	{}
}

/*
 *****************************************************************************************
 * See header file for function definition.
 *****************************************************************************************
 */
void SetPWM2_Evnt_Trig_Int_Enable( epwm_event_trigger_enable_t evnt_trig_enbl, bool enable_value )
{
	if ( evnt_trig_enbl == EPWM_EVT_TRIG_INT_ENBL )
	{
		EPwm2Regs.ETSEL.bit.INTEN = ( enable_value ) ? 1 : 0;
	}
	else if ( evnt_trig_enbl == EPWM_EVT_TRIG_CONV_A_ENBL )
	{
		EPwm2Regs.ETSEL.bit.SOCAEN = ( enable_value ) ? 1 : 0;
	}
	else if ( evnt_trig_enbl == EPWM_EVT_TRIG_CONV_B_ENBL )
	{
		EPwm2Regs.ETSEL.bit.SOCBEN = ( enable_value ) ? 1 : 0;
	}
	else
	{}
}

/*
 *****************************************************************************************
 * See header file for function definition.
 *****************************************************************************************
 */
void SetPWM3_Evnt_Trig_Int_Enable( epwm_event_trigger_enable_t evnt_trig_enbl, bool enable_value )
{
	if ( evnt_trig_enbl == EPWM_EVT_TRIG_INT_ENBL )
	{
		EPwm3Regs.ETSEL.bit.INTEN = ( enable_value ) ? 1 : 0;
	}
	else if ( evnt_trig_enbl == EPWM_EVT_TRIG_CONV_A_ENBL )
	{
		EPwm3Regs.ETSEL.bit.SOCAEN = ( enable_value ) ? 1 : 0;
	}
	else if ( evnt_trig_enbl == EPWM_EVT_TRIG_CONV_B_ENBL )
	{
		EPwm3Regs.ETSEL.bit.SOCBEN = ( enable_value ) ? 1 : 0;
	}
	else
	{}
}

/*
 *****************************************************************************************
 * See header file for function definition.
 *****************************************************************************************
 */
void SetPWM4_Evnt_Trig_Int_Enable( epwm_event_trigger_enable_t evnt_trig_enbl, bool enable_value )
{
	if ( evnt_trig_enbl == EPWM_EVT_TRIG_INT_ENBL )
	{
		EPwm4Regs.ETSEL.bit.INTEN = ( enable_value ) ? 1 : 0;
	}
	else if ( evnt_trig_enbl == EPWM_EVT_TRIG_CONV_A_ENBL )
	{
		EPwm4Regs.ETSEL.bit.SOCAEN = ( enable_value ) ? 1 : 0;
	}
	else if ( evnt_trig_enbl == EPWM_EVT_TRIG_CONV_B_ENBL )
	{
		EPwm4Regs.ETSEL.bit.SOCBEN = ( enable_value ) ? 1 : 0;
	}
	else
	{}
}

/*
 *****************************************************************************************
 * See header file for function definition.
 *****************************************************************************************
 */
void SetPWM5_Evnt_Trig_Int_Enable( epwm_event_trigger_enable_t evnt_trig_enbl, bool enable_value )
{
	if ( evnt_trig_enbl == EPWM_EVT_TRIG_INT_ENBL )
	{
		EPwm5Regs.ETSEL.bit.INTEN = ( enable_value ) ? 1 : 0;
	}
	else if ( evnt_trig_enbl == EPWM_EVT_TRIG_CONV_A_ENBL )
	{
		EPwm5Regs.ETSEL.bit.SOCAEN = ( enable_value ) ? 1 : 0;
	}
	else if ( evnt_trig_enbl == EPWM_EVT_TRIG_CONV_B_ENBL )
	{
		EPwm5Regs.ETSEL.bit.SOCBEN = ( enable_value ) ? 1 : 0;
	}
	else
	{}
}

/*
 *****************************************************************************************
 * See header file for function definition.
 *****************************************************************************************
 */
void SetPWM6_Evnt_Trig_Int_Enable( epwm_event_trigger_enable_t evnt_trig_enbl, bool enable_value )
{
	if ( evnt_trig_enbl == EPWM_EVT_TRIG_INT_ENBL )
	{
		EPwm6Regs.ETSEL.bit.INTEN = ( enable_value ) ? 1 : 0;
	}
	else if ( evnt_trig_enbl == EPWM_EVT_TRIG_CONV_A_ENBL )
	{
		EPwm6Regs.ETSEL.bit.SOCAEN = ( enable_value ) ? 1 : 0;
	}
	else if ( evnt_trig_enbl == EPWM_EVT_TRIG_CONV_B_ENBL )
	{
		EPwm6Regs.ETSEL.bit.SOCBEN = ( enable_value ) ? 1 : 0;
	}
	else
	{}
}

/*
 *****************************************************************************************
 * See header file for function definition.
 *****************************************************************************************
 */
void EPWM_SetEventTriggerSel( pwm_base_t base, epwm_event_trigger_select_t evnt_trig_sel,
							  epwm_event_triggers_sel_t selctn_value  )	///< Interface																													///< Layer
{
	switch ( base )
	{
		case EPWM1:
			SetPWM1_Evnt_Trig_Select( evnt_trig_sel, selctn_value );
			break;

		case EPWM2:
			SetPWM2_Evnt_Trig_Select( evnt_trig_sel, selctn_value );
			break;

		case EPWM3:
			SetPWM3_Evnt_Trig_Select( evnt_trig_sel, selctn_value );
			break;

		case EPWM4:
			SetPWM4_Evnt_Trig_Select( evnt_trig_sel, selctn_value );
			break;

		case EPWM5:
			SetPWM5_Evnt_Trig_Select( evnt_trig_sel, selctn_value );
			break;

		case EPWM6:
			SetPWM6_Evnt_Trig_Select( evnt_trig_sel, selctn_value );
			break;

		default:
			break;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM1_Evnt_Trig_Select( epwm_event_trigger_select_t evnt_trig_sel,
							   epwm_event_triggers_sel_t selctn_value )	///< HAL Layer
{
	switch ( evnt_trig_sel )
	{
		case EPWM_EVT_TRIG_INT_SEL:
			EPwm1Regs.ETSEL.bit.INTSEL = selctn_value;
			break;

		case EPWM_EVT_TRIG_CONV_A_SEL:
			EPwm1Regs.ETSEL.bit.SOCASEL = selctn_value;
			break;

		case EPWM_EVT_TRIG_CONV_B_SEL:
			EPwm1Regs.ETSEL.bit.SOCBSEL = selctn_value;
			break;

		default:
			break;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM2_Evnt_Trig_Select( epwm_event_trigger_select_t evnt_trig_sel,
							   epwm_event_triggers_sel_t selctn_value )		///< HAL Layer
{
	switch ( evnt_trig_sel )
	{
		case EPWM_EVT_TRIG_INT_SEL:
			EPwm2Regs.ETSEL.bit.INTSEL = selctn_value;
			break;

		case EPWM_EVT_TRIG_CONV_A_SEL:
			EPwm2Regs.ETSEL.bit.SOCASEL = selctn_value;
			break;

		case EPWM_EVT_TRIG_CONV_B_SEL:
			EPwm2Regs.ETSEL.bit.SOCBSEL = selctn_value;
			break;

		default:
			break;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM3_Evnt_Trig_Select( epwm_event_trigger_select_t evnt_trig_sel,
							   epwm_event_triggers_sel_t selctn_value )	///< HAL Layer
{
	switch ( evnt_trig_sel )
	{
		case EPWM_EVT_TRIG_INT_SEL:
			EPwm3Regs.ETSEL.bit.INTSEL = selctn_value;
			break;

		case EPWM_EVT_TRIG_CONV_A_SEL:
			EPwm3Regs.ETSEL.bit.SOCASEL = selctn_value;
			break;

		case EPWM_EVT_TRIG_CONV_B_SEL:
			EPwm3Regs.ETSEL.bit.SOCBSEL = selctn_value;
			break;

		default:
			break;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM4_Evnt_Trig_Select( epwm_event_trigger_select_t evnt_trig_sel,
							   epwm_event_triggers_sel_t selctn_value )	///< HAL Layer
{
	switch ( evnt_trig_sel )
	{
		case EPWM_EVT_TRIG_INT_SEL:
			EPwm4Regs.ETSEL.bit.INTSEL = selctn_value;
			break;

		case EPWM_EVT_TRIG_CONV_A_SEL:
			EPwm4Regs.ETSEL.bit.SOCASEL = selctn_value;
			break;

		case EPWM_EVT_TRIG_CONV_B_SEL:
			EPwm4Regs.ETSEL.bit.SOCBSEL = selctn_value;
			break;

		default:
			break;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM5_Evnt_Trig_Select( epwm_event_trigger_select_t evnt_trig_sel,
							   epwm_event_triggers_sel_t selctn_value )	///< HAL Layer
{
	switch ( evnt_trig_sel )
	{
		case EPWM_EVT_TRIG_INT_SEL:
			EPwm5Regs.ETSEL.bit.INTSEL = selctn_value;
			break;

		case EPWM_EVT_TRIG_CONV_A_SEL:
			EPwm5Regs.ETSEL.bit.SOCASEL = selctn_value;
			break;

		case EPWM_EVT_TRIG_CONV_B_SEL:
			EPwm5Regs.ETSEL.bit.SOCBSEL = selctn_value;
			break;

		default:
			break;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM6_Evnt_Trig_Select( epwm_event_trigger_select_t evnt_trig_sel,
							   epwm_event_triggers_sel_t selctn_value )	///< HAL Layer
{
	switch ( evnt_trig_sel )
	{
		case EPWM_EVT_TRIG_INT_SEL:
			EPwm6Regs.ETSEL.bit.INTSEL = selctn_value;
			break;

		case EPWM_EVT_TRIG_CONV_A_SEL:
			EPwm6Regs.ETSEL.bit.SOCASEL = selctn_value;
			break;

		case EPWM_EVT_TRIG_CONV_B_SEL:
			EPwm6Regs.ETSEL.bit.SOCBSEL = selctn_value;
			break;

		default:
			break;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.
 *****************************************************************************************
 */
uint16_t EPWM_GetEventTriggerInterruptStatus( pwm_base_t base, epwm_event_trigger_select_t evnt_trig_sel )
{
	uint16_t evnt_trig_sel_status = 0;

	switch ( base )
	{
		case EPWM1:
			evnt_trig_sel_status = GetPWM1_Evnt_Trig_Status( evnt_trig_sel );
			break;

		case EPWM2:
			evnt_trig_sel_status = GetPWM2_Evnt_Trig_Status( evnt_trig_sel );
			break;

		case EPWM3:
			evnt_trig_sel_status = GetPWM3_Evnt_Trig_Status( evnt_trig_sel );
			break;

		case EPWM4:
			evnt_trig_sel_status = GetPWM4_Evnt_Trig_Status( evnt_trig_sel );
			break;

		case EPWM5:
			evnt_trig_sel_status = GetPWM5_Evnt_Trig_Status( evnt_trig_sel );
			break;

		case EPWM6:
			evnt_trig_sel_status = GetPWM6_Evnt_Trig_Status( evnt_trig_sel );
			break;

		default:
			break;
	}

	return ( evnt_trig_sel_status );
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
uint16_t GetPWM1_Evnt_Trig_Status( epwm_event_trigger_select_t evnt_trig_sel )
{
	uint16_t evnt_trig_select_status = 0;

	switch ( evnt_trig_sel )
	{
		case EPWM_EVT_TRIG_INT_SEL:
			evnt_trig_select_status = EPwm1Regs.ETSEL.bit.INTSEL;
			break;

		case EPWM_EVT_TRIG_CONV_A_SEL:
			evnt_trig_select_status = EPwm1Regs.ETSEL.bit.SOCASEL;
			break;

		case EPWM_EVT_TRIG_CONV_B_SEL:
			evnt_trig_select_status = EPwm1Regs.ETSEL.bit.SOCBSEL;
			break;

		default:
			break;
	}
	return ( evnt_trig_select_status );
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
uint16_t GetPWM2_Evnt_Trig_Status( epwm_event_trigger_select_t evnt_trig_sel )
{
	uint16_t evnt_trig_select_status = 0;

	switch ( evnt_trig_sel )
	{
		case EPWM_EVT_TRIG_INT_SEL:
			evnt_trig_select_status = EPwm2Regs.ETSEL.bit.INTSEL;
			break;

		case EPWM_EVT_TRIG_CONV_A_SEL:
			evnt_trig_select_status = EPwm2Regs.ETSEL.bit.SOCASEL;
			break;

		case EPWM_EVT_TRIG_CONV_B_SEL:
			evnt_trig_select_status = EPwm2Regs.ETSEL.bit.SOCBSEL;
			break;

		default:
			break;
	}
	return ( evnt_trig_select_status );
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
uint16_t GetPWM3_Evnt_Trig_Status( epwm_event_trigger_select_t evnt_trig_sel )
{
	uint16_t evnt_trig_select_status = 0;

	switch ( evnt_trig_sel )
	{
		case EPWM_EVT_TRIG_INT_SEL:
			evnt_trig_select_status = EPwm3Regs.ETSEL.bit.INTSEL;
			break;

		case EPWM_EVT_TRIG_CONV_A_SEL:
			evnt_trig_select_status = EPwm3Regs.ETSEL.bit.SOCASEL;
			break;

		case EPWM_EVT_TRIG_CONV_B_SEL:
			evnt_trig_select_status = EPwm3Regs.ETSEL.bit.SOCBSEL;
			break;

		default:
			break;
	}
	return ( evnt_trig_select_status );
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
uint16_t GetPWM4_Evnt_Trig_Status( epwm_event_trigger_select_t evnt_trig_sel )
{
	uint16_t evnt_trig_select_status = 0;

	switch ( evnt_trig_sel )
	{
		case EPWM_EVT_TRIG_INT_SEL:
			evnt_trig_select_status = EPwm4Regs.ETSEL.bit.INTSEL;
			break;

		case EPWM_EVT_TRIG_CONV_A_SEL:
			evnt_trig_select_status = EPwm4Regs.ETSEL.bit.SOCASEL;
			break;

		case EPWM_EVT_TRIG_CONV_B_SEL:
			evnt_trig_select_status = EPwm4Regs.ETSEL.bit.SOCBSEL;
			break;

		default:
			break;
	}
	return ( evnt_trig_select_status );
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
uint16_t GetPWM5_Evnt_Trig_Status( epwm_event_trigger_select_t evnt_trig_sel )
{
	uint16_t evnt_trig_select_status = 0;

	switch ( evnt_trig_sel )
	{
		case EPWM_EVT_TRIG_INT_SEL:
			evnt_trig_select_status = EPwm5Regs.ETSEL.bit.INTSEL;
			break;

		case EPWM_EVT_TRIG_CONV_A_SEL:
			evnt_trig_select_status = EPwm5Regs.ETSEL.bit.SOCASEL;
			break;

		case EPWM_EVT_TRIG_CONV_B_SEL:
			evnt_trig_select_status = EPwm5Regs.ETSEL.bit.SOCBSEL;
			break;

		default:
			break;
	}
	return ( evnt_trig_select_status );
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
uint16_t GetPWM6_Evnt_Trig_Status( epwm_event_trigger_select_t evnt_trig_sel )
{
	uint16_t evnt_trig_select_status = 0;

	switch ( evnt_trig_sel )
	{
		case EPWM_EVT_TRIG_INT_SEL:
			evnt_trig_select_status = EPwm6Regs.ETSEL.bit.INTSEL;
			break;

		case EPWM_EVT_TRIG_CONV_A_SEL:
			evnt_trig_select_status = EPwm6Regs.ETSEL.bit.SOCASEL;
			break;

		case EPWM_EVT_TRIG_CONV_B_SEL:
			evnt_trig_select_status = EPwm6Regs.ETSEL.bit.SOCBSEL;
			break;

		default:
			break;
	}
	return ( evnt_trig_select_status );
}

/*
 *****************************************************************************************
 * See header file for function definition.
 *****************************************************************************************
 */
void EPWM_SetDeadBandDelayCount( pwm_base_t base, epwm_deadband_delay_mode_t delay_mode, uint16_t deadband_count )
{
	switch ( base )
	{
		case EPWM1:
			SetPWM1_DB_Delay_Count( delay_mode, deadband_count );
			break;

		case EPWM2:
			SetPWM2_DB_Delay_Count( delay_mode, deadband_count );
			break;

		case EPWM3:
			SetPWM3_DB_Delay_Count( delay_mode, deadband_count );
			break;

		case EPWM4:
			SetPWM4_DB_Delay_Count( delay_mode, deadband_count );
			break;

		case EPWM5:
			SetPWM5_DB_Delay_Count( delay_mode, deadband_count );
			break;

		case EPWM6:
			SetPWM6_DB_Delay_Count( delay_mode, deadband_count );
			break;

		default:
			break;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM1_DB_Delay_Count( epwm_deadband_delay_mode_t delay_mode, uint16_t deadband_count )
{
	if ( delay_mode == EPWM_DB_RED )
	{
		EPwm1Regs.DBRED = deadband_count;
	}
	else
	{
		EPwm1Regs.DBFED = deadband_count;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM2_DB_Delay_Count( epwm_deadband_delay_mode_t delay_mode, uint16_t deadband_count )
{
	if ( delay_mode == EPWM_DB_RED )
	{
		EPwm2Regs.DBRED = deadband_count;
	}
	else
	{
		EPwm2Regs.DBFED = deadband_count;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM3_DB_Delay_Count( epwm_deadband_delay_mode_t delay_mode, uint16_t deadband_count )
{
	if ( delay_mode == EPWM_DB_RED )
	{
		EPwm3Regs.DBRED = deadband_count;
	}
	else
	{
		EPwm3Regs.DBFED = deadband_count;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM4_DB_Delay_Count( epwm_deadband_delay_mode_t delay_mode, uint16_t deadband_count )
{
	if ( delay_mode == EPWM_DB_RED )
	{
		EPwm4Regs.DBRED = deadband_count;
	}
	else
	{
		EPwm4Regs.DBFED = deadband_count;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM5_DB_Delay_Count( epwm_deadband_delay_mode_t delay_mode, uint16_t deadband_count )
{
	if ( delay_mode == EPWM_DB_RED )
	{
		EPwm5Regs.DBRED = deadband_count;
	}
	else
	{
		EPwm5Regs.DBFED = deadband_count;
	}
}

/*
 *****************************************************************************************
 * See header file for function definition.,
 *****************************************************************************************
 */
void SetPWM6_DB_Delay_Count( epwm_deadband_delay_mode_t delay_mode, uint16_t deadband_count )
{
	if ( delay_mode == EPWM_DB_RED )
	{
		EPwm6Regs.DBRED = deadband_count;
	}
	else
	{
		EPwm6Regs.DBFED = deadband_count;
	}
}
