#ifndef SYSTEM_TRAP_H
#define SYSTEM_TRAP_H
// ********************************************************************************************************
// *            SystemTrap.h
// ********************************************************************************************************
// ********************************************************************************************************
// *
// *    THIS INFORMATION IS PROPRIETARY TO EATON
// *
// ********************************************************************************************************
// *
// *    Copyright (c) 2003...2007 EATON
// *    ALL RIGHTS RESERVED
// *
// ********************************************************************************************************
// ********************************************************************************************************
// *    FILE NAME: SystemTrap.h
// *
// *    DESCRIPTION: Contains ISR for system traps
// *
// *    ORIGINATOR: Mike Westerfield
// *
// *    DATE: 7/17/2003
// *
// *    HISTORY: See revision control system's history.
// *********************************************************************************************************

// *********************************************************************************************************
// *        INCLUDE FILES (included files must have #ifndef protection)
// *********************************************************************************************************

//#include "Typedefs.h"

// ********************************************************************************************************
// * FUNCTION PROTOTYPES
// ********************************************************************************************************
void WatchdogReset(void);
void FastShutdown(void);
void CheckSysTrap(void);
void KickWatchdog(void);
void DisableWatchdog(void);

#ifdef __cplusplus
extern "C" {
#endif
void InitEPLDWatchdogEcho();
#ifdef __cplusplus
}
#endif

// ********************************************************************************************************
// * GLOBAL VARIABLES
// ********************************************************************************************************

//extern INT16U WatchdogFlags;

// ********************************************************************************************************
// * DEFINED VALUES
// ********************************************************************************************************

#define A2D_WD_FLAG (INT16U) 1
#define PRC_A2D_WD_FLAG (INT16U) 1<<1

// Reasons for reset stored in PLDStorage
#define PRIVATE_XCP_RESET_PARAM 1
#define PRIVATE_XCP_RESET_C9    2
#define ILLEGAL_TRAP            3
#define POWER_NMI               4
#define WATCHDOG_TRIP           5
#define EEP_SYNC_RESET          6
#define CAN_ID_FAILED           7

extern uint16_t  xi2Counter;

// ********************************************************************************************************
// *            END OF SystemTrap.h
// ********************************************************************************************************
#endif
