// TI File $Revision: /main/5 $
// Checkin $Date: October 23, 2007   13:34:09 $
//###########################################################################
//
// FILE:    DSP2833x_Adc.c
//
// TITLE:   DSP2833x ADC Initialization & Support Functions.
//
//###########################################################################
// $TI Release: DSP2833x/DSP2823x C/C++ Header Files V1.31 $
// $Release Date: August 4, 2009 $
//###########################################################################

#include "DSP2833x_Device.h"     // DSP2833x Headerfile Include File
#include "DSP2833x_Examples.h"   // DSP2833x Examples Include File

#define ADC_usDELAY  5000L

#define ADCINA0 0x0
#define ADCINA1 0x1
#define ADCINA2 0x2
#define ADCINA3 0x3
#define ADCINA4 0x4
#define ADCINA5 0x5
#define ADCINA6 0x6
#define ADCINA7 0x7
#define ADCINB0 0x8
#define ADCINB1 0x9
#define ADCINB2 0xA
#define ADCINB3 0xB
#define ADCINB4 0xC
#define ADCINB5 0xD
#define ADCINB6 0xE
#define ADCINB7 0xF

// not TI supplied code
void InitProjectAdc( void );

//---------------------------------------------------------------------------
// InitAdc:
//---------------------------------------------------------------------------
// This function initializes ADC to a known state.
//
void InitAdc(void)
{
    extern void DSP28x_usDelay(Uint32 Count);


    // *IMPORTANT*
    // The ADC_cal function, which  copies the ADC calibration values from TI reserved
    // OTP into the ADCREFSEL and ADCOFFTRIM registers, occurs automatically in the
    // Boot ROM. If the boot ROM code is bypassed during the debug process, the
    // following function MUST be called for the ADC to function according
    // to specification. The clocks to the ADC MUST be enabled before calling this
    // function.
    // See the device data manual and/or the ADC Reference
    // Manual for more information.

    EALLOW;
    SysCtrlRegs.PCLKCR0.bit.ADCENCLK = 1;
    ADC_cal();
    EDIS;

    // To powerup the ADC the ADCENCLK bit should be set first to enable
    // clocks, followed by powering up the bandgap, reference circuitry, and ADC core.
    // Before the first conversion is performed a 5ms delay must be observed
    // after power up to give all analog circuits time to power up and settle

    // Please note that for the delay function below to operate correctly the
    // CPU_RATE define statement in the DSP2833x_Examples.h file must
    // contain the correct CPU clock period in nanoseconds.

    AdcRegs.ADCTRL3.all = 0x00E0;  // Power up bandgap/reference/ADC circuits
    DELAY_US(ADC_usDELAY);         // Delay before converting ADC channels

    InitProjectAdc();
}

//---------------------------------------------------------------------------
// InitProjectAdc:
//---------------------------------------------------------------------------
// Set up A/d for Panda project
//
#define ADC_MODCLK 0x3 // HSPCLK = SYSCLKOUT/2*ADC_MODCLK2 = 150/(2*3)   = 25.0 MHz

void InitProjectAdc( void )
{
	// ADCTRL1 register configuration set up
	AdcRegs.ADCTRL1.bit.RESET = 0;
	AdcRegs.ADCTRL1.bit.SUSMOD = 1;
	AdcRegs.ADCTRL1.bit.ACQ_PS = 1;
	AdcRegs.ADCTRL1.bit.CPS = 0;
	AdcRegs.ADCTRL1.bit.CONT_RUN = 0;
	AdcRegs.ADCTRL1.bit.SEQ_OVRD = 0;
	AdcRegs.ADCTRL1.bit.SEQ_CASC = 1;

    // ADCTRL2 register configuration set up
	AdcRegs.ADCTRL2.bit.EPWM_SOCB_SEQ = 0;
	AdcRegs.ADCTRL2.bit.RST_SEQ1 = 1;
	AdcRegs.ADCTRL2.bit.SOC_SEQ1 = 0;
	AdcRegs.ADCTRL2.bit.INT_ENA_SEQ1 = 1;
	AdcRegs.ADCTRL2.bit.INT_MOD_SEQ1 = 0;
	AdcRegs.ADCTRL2.bit.EPWM_SOCA_SEQ1 = 1;
	AdcRegs.ADCTRL2.bit.EXT_SOC_SEQ1 = 0;
	AdcRegs.ADCTRL2.bit.RST_SEQ2 = 0;
	AdcRegs.ADCTRL2.bit.SOC_SEQ2 = 0;
	AdcRegs.ADCTRL2.bit.INT_ENA_SEQ2 = 0;
	AdcRegs.ADCTRL2.bit.INT_MOD_SEQ2 = 0;
	AdcRegs.ADCTRL2.bit.EPWM_SOCB_SEQ2 = 0;

	// ADCTRL3 register configuration set up
    AdcRegs.ADCTRL3.bit.ADCCLKPS = ADC_MODCLK;

	//ADCMAXCONV register configuration set up
	AdcRegs.ADCMAXCONV.bit.MAX_CONV2 = 0;
	AdcRegs.ADCMAXCONV.bit.MAX_CONV1 = 0x0B;

	//ADCCHSELSEQx register configuration set up
	AdcRegs.ADCCHSELSEQ1.bit.CONV03 = ADCINA3;			// Inv_Vac at MUX(0) and Vdc Bus at MUX(1)
    AdcRegs.ADCCHSELSEQ1.bit.CONV02 = ADCINA2;			// Rec_Vac at MUX(0)
    AdcRegs.ADCCHSELSEQ1.bit.CONV01 = ADCINA1;
    AdcRegs.ADCCHSELSEQ1.bit.CONV00 = ADCINA0;			// PLL_A at MUX(1)

    AdcRegs.ADCCHSELSEQ2.bit.CONV07 = ADCINA7;			//P1.5 V at MUX(0), P5 V at MUX(1), P12 V at MUX(2) and P24 V at MUX(3),
    AdcRegs.ADCCHSELSEQ2.bit.CONV06 = ADCINB1;			//I_P2 at MUX(0)
    AdcRegs.ADCCHSELSEQ2.bit.CONV05 = ADCINA5;			//Inv_Iac at MUX(0)
    AdcRegs.ADCCHSELSEQ2.bit.CONV04 = ADCINA4;			//Rec_Iac at MUX(0)

	AdcRegs.ADCCHSELSEQ3.bit.CONV11 = ADCINB7;			//REC_TEMP at MUX(1), INV_TEMP_A at MUX(2), AMB_TEMP at MUX(4),
	AdcRegs.ADCCHSELSEQ3.bit.CONV10 = ADCINB0;			//I_P1 at MUX(0)
	AdcRegs.ADCCHSELSEQ3.bit.CONV09 = ADCINB3;			// GD_PWR_REC signal at MUX(1)
	AdcRegs.ADCCHSELSEQ3.bit.CONV08 = ADCINB4; 			// GD_PWR_INV_A signal at MUX(1)
}

//===========================================================================
// End of file.
//===========================================================================
