/**
 ********************************************************************************************************
 * @file adc.cpp
 * @brief Source file for adc.h
 * @copyright 2020 Eaton Corporation. All Rights Reserved.
 *********************************************************************************************************
 */
#include <cstring>
#include <math.h>
#include <cmath>
using std::memset;

#include "DSP28x_Project.h"		// Device Headerfile and Examples Include File
#include "Constants.h"
#include "CriticalSection.h"
#include "SystemTrap.h"


#include "F28335Epwm.h"
#include "F28335Adc.h"


using std::memcpy;

#define TIMER_COUNT_50MS        500
#define TIMER_COUNT_499         499
#define SET_TO_ZERO             0

bool g_stopWatchdog = false;
bool ADC_Peak_Conv_Comp = 0;
bool ADC_Valley_Conv_Comp = 0;
bool control_isr_val = false;

/**
 * @brief Global variables to store ADC Values
 */
float32 V_Rec = 0;
float32 V_Inv_A = 0;
float32 I_Rec = 0;
float32 I_Inv_A = 0;
float32 I_Tap_P1 = 0;
float32 I_Tap_P2 = 0;
float32 Temp_Inv_A = 0;
float32 Temp_Amb = 0;
float32 PS_1_5V = 0;
float32 PS_12V = 0;
float32 Phase_Locked_Loop_A = 0;
float32 V_DC = 0;
float32 Temp_Rec = 0;
float32 GD_Pwr_Rec = 0;
float32 GD_Pwr_Inv_A = 0;
float32 PS_5V = 0;
float32 PS_24V = 0;


uint32_t i = 0;
uint32_t initialization_flag = 0;
uint32_t GPIO_test_flag = 0;
//float32 Data_plot1[60];
float32 Data_plot2[100];

// Code modification end


/**
 * @brief Variables to set Mux values
 */
const uint16_t MUX0 = 0;
const uint16_t MUX1 = 1;
const uint16_t MUX2 = 2;

/**
 * @brief Counters and flags to read ADC inputs
 */
uint32_t Peak_Counter_50ms = 0;
uint32_t Valley_Counter_50ms = 0;
bool Peak_50ms_Even_Flag = false;
bool Valley_50ms_Even_Flag = false;

uint32_t Control_Fault_Code;


extern "C"
{
	/**
	 * @brief Control interrupt service routine (Runs at 10.0 kHz)
	 * @return None
	 */
	void control_isr( void );

	/**
	 * @brief ADC EOC interrupt service routine (Runs at 20.0 kHz)
	 * @return None
	 */
	void adc_isr( void );
}

/**
 * @brief Updates input peripherals for Control Section
 * @return None
 */
void Update_Peripheral_Inputs( void );

/**
 * @brief Updates output peripherals obtained from Control Section
 * @return None
 */
void Update_Peripheral_Outputs( void );

/*
 *****************************************************************************************
 * See header file for function definition.
 *****************************************************************************************
 */
#pragma CODE_SECTION( "ramfuncs" );
void Update_Peripheral_Inputs( void )
{

	ADC_Peak_Conv_Comp = false;
	ADC_Valley_Conv_Comp = false;
}

/*
 *****************************************************************************************
 * See header file for function definition.
 *****************************************************************************************
 */
#pragma CODE_SECTION( "ramfuncs" );
void Update_Peripheral_Outputs( void )
{

}

/**
 * @brief Toggles DSP Watch dog timer pin
 * @param[in] None
 * @return None
 */
inline void ToggleDSPWatchDog( void )
{
	 GpioDataRegs.GPBTOGGLE.bit.GPIO40 = 1;
}


/*
 *****************************************************************************************
 * See header file for function definition.
 *****************************************************************************************
 */
#pragma CODE_SECTION( "ramfuncs" );
#pragma FUNC_EXT_CALLED;
void control_isr( void )
{
	CriticalSection enter;

	KickWatchdog();
	if ( !g_stopWatchdog )
	{
		ToggleDSPWatchDog();
	}

	// Control code integration
	// Updating input GPIO and ADC values into Control code class objects
	Update_Peripheral_Inputs();


	 if(i < 99){
//		 Data_plot1[i] = V_Rec;
		 Data_plot2[i] = V_Rec;
		 i++;
	 }else{
//		 Data_plot1[i] = V_Rec;
		 Data_plot2[i] = V_Rec;
	 	 i= 0;
	 }


	// Updating GPIO outputs obtained from Control code class objects
	Update_Peripheral_Outputs();

	EPwm1Regs.ETCLR.bit.INT = 1;
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;		// Acknowledge interrupt to PIE
}

#pragma CODE_SECTION( "ramfuncs" );
#pragma FUNC_EXT_CALLED;

void adc_isr( void )
{
	CriticalSection enter;

	//Condition to check for Peak or Valley signal
	if ( ( EPWM_GetEventTriggerInterruptStatus( EPWM1, EPWM_EVT_TRIG_CONV_A_SEL ) ) == SOCA_PULSE_CTR_ZERO )
	{
		EPWM_SetEventTriggerSel( EPWM1, EPWM_EVT_TRIG_CONV_A_SEL, SOCA_PULSE_CTR_PRD );

		Valley_Counter_50ms++;

		// Reading valley sensing Signals with 0.1ms period
		// For MUXAD123 = XX0
		V_Rec = Get_Rec_Vac();

//		 if (GPIO_test_flag){
//			 DSPOutRegister.GpoB.bit.reservedB51 = 1;
//			 GPIO_test_flag = 0;
//		 }else{
//			 DSPOutRegister.GpoB.bit.reservedB51 = 0;
//			 GPIO_test_flag = 1;
//		 }

		V_Inv_A = Get_Inv_Vac_A();
		I_Rec = Get_Rec_Iac();
		I_Inv_A = Get_Inv_Iac_A();
		I_Tap_P1 = Get_Tap_P1_Iac();
		I_Tap_P2 = Get_Tap_P2_Iac();
		PS_1_5V = Get_IFB_P15();

		if ( ( Valley_50ms_Even_Flag == false ) && ( Valley_Counter_50ms >= TIMER_COUNT_50MS ) )
		{

			//set mux for peak trigger values and read valley triggered adc signals


			Temp_Inv_A = Get_Inv_Temp_A();
			PS_12V = Get_IFB_P12();

			Valley_Counter_50ms = SET_TO_ZERO;
			Valley_50ms_Even_Flag = true;

		}
		// Reading Peak sensing Signals with 50ms Even period
		else if ( ( Valley_50ms_Even_Flag == true ) && ( Valley_Counter_50ms >= TIMER_COUNT_50MS ) )
		{

			Temp_Amb = Get_Amb_Temp(); // read valley sensed input

			Valley_Counter_50ms = SET_TO_ZERO;
			Valley_50ms_Even_Flag = false;
		}
		else
		{
		}

		ADC_Valley_Conv_Comp = true;

	}
	else if ( ( EPWM_GetEventTriggerInterruptStatus( EPWM1, EPWM_EVT_TRIG_CONV_A_SEL ) ) == SOCA_PULSE_CTR_PRD )
	{
		EPWM_SetEventTriggerSel( EPWM1, EPWM_EVT_TRIG_CONV_A_SEL, SOCA_PULSE_CTR_ZERO );

		Peak_Counter_50ms++;

		// For MUXAD123 = XX1
		Phase_Locked_Loop_A = Get_PLL_A();
		V_DC = Get_Vdc();
		GD_Pwr_Rec = Get_IFB_GD_Rec();
		GD_Pwr_Inv_A = Get_IFB_GD_Inv_A();

		if ( ( Peak_50ms_Even_Flag == false ) && ( Peak_Counter_50ms >= TIMER_COUNT_50MS ) )
		{

			PS_5V = Get_IFB_P5();
			Temp_Rec = Get_Rec_Temp(); // Read peak sampled  signals

			Peak_Counter_50ms = SET_TO_ZERO;
			Peak_50ms_Even_Flag = true;
		}
		else if ( ( Peak_50ms_Even_Flag == true ) && ( Peak_Counter_50ms >= TIMER_COUNT_50MS ) )
		{

			PS_24V = Get_IFB_P24(); 	// Reading peak sensed Signals with 50ms Even period

			Peak_Counter_50ms = SET_TO_ZERO;
			Peak_50ms_Even_Flag = false;
		}
		else
		{
		}

		ADC_Peak_Conv_Comp = true;
	}
	else
	{
		// do nothing
	}


	Reset_Seq_1( 1 );						// Reset SEQ1
	Clear_Seq_1_Int( 1 );					// Clear INT SEQ1 bit

	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;	// Acknowledge interrupt to PIE
}

/**
 * END OF adc.cpp
 */
