/**
 *****************************************************************************************
 *	@file main.cpp
 *	@details Systems Initialisation.
 *	@copyright 2020 Eaton Corporation. All Rights Reserved.
 *
 *****************************************************************************************
 */
#include "DSP28x_Project.h"



/*
 *****************************************************************************************
 *		Defines and Constants
 *****************************************************************************************
 */
extern void InitWatchdog(void);


/*
 *****************************************************************************************
 * See header file for function definition.
 *****************************************************************************************
 */
int main(void)
{

    //
    // Step 1. Initialize System Control:
    // PLL, WatchDog, enable Peripheral Clocks
    // This example function is found in the DSP2833x_SysCtrl.c file.
    //
    InitSysCtrl();

    //
    // Step 2. Initialize GPIO:
    // This example function is found in the DSP2833x_Gpio.c file and
    // illustrates how to set the GPIO to it's default state.
    //
    // InitGpio();  // Skipped for this example

    //
    // Step 3. Clear all interrupts and initialize PIE vector table:
    // Disable CPU interrupts
    //
    DINT;

    //
    // Initialize the PIE control registers to their default state.
    // The default state is all PIE interrupts disabled and flags
    // are cleared.
    // This function is found in the DSP2833x_PieCtrl.c file.
    //
    InitPieCtrl();

    //
    // Disable CPU interrupts and clear all CPU interrupt flags:
    //
    IER = 0x0000;
    IFR = 0x0000;

    //
    // Initialize the PIE vector table with pointers to the shell Interrupt
    // Service Routines (ISR).
    // This will populate the entire table, even if the interrupt
    // is not used in this example.  This is useful for debug purposes.
    // The shell ISR routines are found in DSP2833x_DefaultIsr.c.
    // This function is found in DSP2833x_PieVect.c.
    //
    InitPieVectTable();

    InitGpio();

	/**
	 * @brief   Disable CPU interrupts
	 * @n Clear all interrupts and initialize PIE vector table
	 */
    DINT;

	/**
	 * @brief Initialise PIE control registers to their default state
	 * @n Clear all interrupts and initialise PIE vector table
	 */
    InitPieCtrl();

	/**
	 * @brief Disable CPU interrupts and clear all CPU interrupt flags
	 */
    IER = 0x0000;
    IFR = 0x0000;

	/**
	 * @brief Initialise CPU Timers
	 */
    InitCpuTimers();
    StartCpuTimer0();
     
	/**
	 * @brief Call Flash Initialization to setup flash waitstates
	 */
    InitFlash();

	/**
	 * @brief Project initialization
	 */
    InitAdc();
    InitEPwm();
    InitWatchdog();

	/**
	 * @brief Enable Peripheral interrupts
	 */
    PieCtrlRegs.PIEIER1.bit.INTx6 = 1;  // ADC complete isr
    PieCtrlRegs.PIEIER1.bit.INTx8 = 1;  // watchdog overflow isr
    PieCtrlRegs.PIEIER3.bit.INTx1 = 1;  // PWM ISR

    IER |= ( M_INT1  | M_INT3 );  // Enable CPU Interrupts

	/**
	 * @brief start timers
	 */
    StartePWMTimers();

	/**
	 * @brief Exit to DSP/BIOS
	 */
    return 0;
}
