/* =============================================================================
    PROJECT NAME:
    ITEM TYPE:
    ITEM NAME:
    ITEM REFERENCE:
    CURRENT VERSION:
    DATE:
    ITEM DESCRIPTION:
    DOC REFERENCES:
    AUTHOR(S):
    COPYRIGHT:
    REVISION HISTORY:
============================================================================= */
#ifndef EEPROM_H
#define EEPROM_H

/* =============================================================================
    Defines
============================================================================= */
#define DSC_MUSK    	    0xA0			// Device select code musk

#define	EEP_PAR_PAGE0	    0x0000
#define	EEP_PAR_PAGE1	    0x0100
#define	FLASH_OFFSET	    0x0400

#define EEPROM_WRITE_TIME   200             // 200ms
/* =============================================================================
    Types
============================================================================= */

/* =============================================================================
    Globals
============================================================================= */
#ifdef  EEPROM_GLOBALS
#define EEPROM_EXT
#else
#define EEPROM_EXT extern
#endif

EEPROM_EXT uint32_t eeimg[128];

/* =============================================================================
    Module procedures
============================================================================= */
EEPROM_EXT bool eeprom_write(uint32_t address, int16_t n_writes, uint16_t *data);
EEPROM_EXT bool eeprom_read(uint32_t address, int16_t n_reads, uint16_t *data);
EEPROM_EXT bool eeprom_polling(void);
EEPROM_EXT uint32_t byte_to_long(uint16_t *add);
EEPROM_EXT void long_to_byte(uint32_t ulval, uint16_t *add);

#endif
