/* =============================================================================
    PROJECT NAME:
    ITEM TYPE:
    ITEM NAME:
    ITEM REFERENCE:
    CURRENT VERSION:
    DATE:
    ITEM DESCRIPTION:
    DOC REFERENCES:
    AUTHOR(S):
    COPYRIGHT:
    REVISION HISTORY:
============================================================================= */
#ifndef I2CA_H
#define I2CA_H

/* =============================================================================
    Defines
============================================================================= */
#define	SCLA_GPIO		33
#define	SCLA_PHER		1

#define SDAA_GPIO		32
#define SDAA_PHER		1

#define I2CA_MAX_SIZE   256
#define EEPROM_ADD_LEN	2

/* =============================================================================
    Types
============================================================================= */
typedef enum
{
    I2C_NOP,
    I2C_WRITING,
    I2C_READING,
    EEPROM_POLLING,
} I2C_STATES;

typedef enum
{
    I2C_WRITE,
    I2C_WRITE_READ,
    I2C_READ,
    I2C_POLLING,
} I2C_OPERATION;

typedef struct
{
    I2C_STATES      state;
//
    volatile bool   done;
    volatile bool   nack;
    volatile bool   stop;
//
    int16_t         n_reads;
    int16_t         n_writes;
    uint16_t        rx_buf[I2CA_MAX_SIZE];
    uint16_t        tx_buf[I2CA_MAX_SIZE+EEPROM_ADD_LEN];
//
    uint16_t        sar;
    int16_t         trx_ptr;
    int16_t         retry;
} I2CA_DATA_TAG;

/* =============================================================================
    Globals
============================================================================= */
#ifdef  I2CA_GLOBALS
#define I2CA_EXT
#else
#define I2CA_EXT extern
#endif

I2CA_EXT I2CA_DATA_TAG i2ca;
I2CA_EXT uint16_t r_data[I2CA_MAX_SIZE];
I2CA_EXT uint16_t w_data[I2CA_MAX_SIZE];

/* =============================================================================
    Module procedures
============================================================================= */
void SetUpI2CA(void);
void i2ca_start_transfer(int16_t sadd, int16_t n_wr, int16_t n_rd, int16_t op);
bool i2ca_tx_rx(uint16_t sadd, int16_t n_writes, int16_t n_reads);
interrupt void i2ca_isr(void);
bool eeprom_write(uint32_t address, int16_t n_writes, uint16_t *data);
bool eeprom_read(uint32_t address, int16_t n_reads, uint16_t *data);
bool eeprom_polling(void);

#endif
