/* =============================================================================
    PROJECT NAME:
    ITEM TYPE:
    ITEM NAME:
    ITEM REFERENCE:
    CURRENT VERSION:
    DATE:
    ITEM DESCRIPTION:
    DOC REFERENCES:
    AUTHOR(S):
    COPYRIGHT:
    REVISION HISTORY:
============================================================================= */
#include "includes.h"

extern void ebss_start;
extern void ebss_size;

/* ============================================================================
    FUNCTION NAME:
    PURPOSE:
    DESCRIPTION:
    DOMAIN:
    ACCURACY:
    NOTES:
 ============================================================================ */
int main(void)
{
int16_t i;

    DINT;
    /*  */
    InitSysCtrl();
    /*  initialize .ebss section to 0                                         */
    memset((uint16_t*)_symval(&ebss_start), 0, _symval(&ebss_size));
    /*  */
    InitGpio();
    /*  */
    InitPieCtrl();
    /*  Disable CPU interrupts and clear all CPU interrupt flags:             */
    IER = 0x0000;
    IFR = 0x0000;
    /*  */
    InitPieVectTable();
    /*  */
    EALLOW;
    PieVectTable.I2CA_INT = &i2ca_isr;
    EDIS;
    /*  */
    SetUpI2CA();
    /*  Enable I2CA in the PIE Group 8 interrupt 1                            */
    PieCtrlRegs.PIEIER8.bit.INTx1 = 1;
    /*  Enable CPU INT8                                                       */
    IER |= M_INT8;
    /*  Enable global Interrupts and higher priority real-time debug events:  */
    EINT;
    ERTM;
    /*                                                                        */
    for(i=0; i<256; i++)
    {
        w_data[i] = i;
    }
    eeprom_write(0, 256, w_data);
    /*  wait for write operation to occur                                     */
    while( !eeprom_read(0, 2, r_data) );
    eeprom_read(0, 256, r_data);

    do
    {

    } while( true );

    return 0;
}
