/* =============================================================================
    PROJECT NAME:
    ITEM TYPE:
    ITEM NAME:
    ITEM REFERENCE:
    CURRENT VERSION:
    DATE:
    ITEM DESCRIPTION:
    DOC REFERENCES:
    AUTHOR(S):
    COPYRIGHT:
    REVISION HISTORY:
============================================================================= */
#define EEPROM_GLOBALS
#include "includes.h"

/* ============================================================================
    FUNCTION NAME:
    PURPOSE:
    DESCRIPTION:
    DOMAIN:
    ACCURACY:
    NOTES:
 ============================================================================ */
bool eeprom_write(uint32_t address, int16_t n_writes, uint16_t *data)
{
int16_t i;
bool esito;

    //  Prepare SAR
    i2ca.sar = (address & 0x3FFFF) >> 16;
    i2ca.sar = i2ca.sar << 1;
    i2ca.sar = (i2ca.sar | DSC_MUSK) >> 1;
    //
    i2ca.tx_buf[0] = (address >> 8) & 0xFF;
    i2ca.tx_buf[1] = address & 0xFF;
    //
    for (i=0; i<n_writes; i++)
    {
        i2ca.tx_buf[EEPROM_ADD_LEN+i] = data[i];
    }
    //
    esito = i2ca_tx_rx(i2ca.sar, n_writes+2, 0);
    //
    return (esito);
}

/* ============================================================================
    FUNCTION NAME:
    PURPOSE:
    DESCRIPTION:
    DOMAIN:
    ACCURACY:
    NOTES:
 ============================================================================ */
bool eeprom_read(uint32_t address, int16_t n_reads, uint16_t *data)
{
int16_t i;
bool esito;

    //  Prepare SAR
    i2ca.sar = (address & 0x3FFFF) >> 16;
    i2ca.sar = i2ca.sar << 1;
    i2ca.sar = (i2ca.sar | DSC_MUSK) >> 1;
    //
    i2ca.tx_buf[0] = (address >> 8) & 0xFF;
    i2ca.tx_buf[1] = address & 0xFF;
    //
    esito = i2ca_tx_rx(i2ca.sar, 2, n_reads);
    //
    if( esito )
    {
        for (i=0; i<n_reads; i++)
        {
            data[i] = i2ca.rx_buf[i];
        }
    }
    //
    return (esito);
}

/* ============================================================================
    FUNCTION NAME:
    PURPOSE:
    DESCRIPTION:
    DOMAIN:
    ACCURACY:
    NOTES:
 ============================================================================ */
bool eeprom_polling(void)
{
bool esito = false;

    i2ca.retry = 0;
    do
    {
        //
        i2ca.retry++;
        //
        i2ca.tx_buf[0] = 0;
        i2ca.tx_buf[1] = 0;
        i2ca_start_transfer(DSC_MUSK >> 1, 2, 0, I2C_POLLING);
        while( !i2ca.done );
        if( i2ca.stop )
        {
            esito = true;
            i2ca.done = false;
            i2ca.stop = false;
        }
    } while( !esito );

    return( esito );
}

/* ============================================================================
    FUNCTION NAME:
    PURPOSE:
    DESCRIPTION:
    DOMAIN:
    ACCURACY:
    NOTES:
 ============================================================================ */
uint32_t byte_to_long(uint16_t *add)
{
int16_t i;
uint32_t res = 0;

	add = add + 3;
	for(i=0; i<4; i++)
	{
		res = (res << 8) | *add--;
	}

	return( res );
}

/* ============================================================================
    FUNCTION NAME:
    PURPOSE:
    DESCRIPTION:
    DOMAIN:
    ACCURACY:
    NOTES:
 ============================================================================ */
void long_to_byte(uint32_t ulval, uint16_t *add)
{
int16_t i;

	for(i=0; i<4; i++)
	{
		*add++ = ulval & 0xFF;
		ulval = ulval >> 8;
	}
}
