/* =============================================================================
    PROJECT NAME:
    ITEM TYPE:
    ITEM NAME:
    ITEM REFERENCE:
    CURRENT VERSION:
    DATE:
    ITEM DESCRIPTION:
    DOC REFERENCES:
    AUTHOR(S):
    COPYRIGHT:
    REVISION HISTORY:
============================================================================= */
#define I2CA_GLOBALS
#include "includes.h"

/* ============================================================================
    FUNCTION NAME:
    PURPOSE:
    DESCRIPTION:
    DOMAIN:
    ACCURACY:
    NOTES:
 ============================================================================ */
void SetUpI2CA(void)
{

	GPIO_SetupPinMux(SCLA_GPIO, GPIO_MUX_CPU1, SCLA_PHER);
    GPIO_SetupPinOptions(SCLA_GPIO, GPIO_INPUT, GPIO_ASYNC | GPIO_PULLUP);

    GPIO_SetupPinMux(SDAA_GPIO, GPIO_MUX_CPU1, SDAA_PHER);
    GPIO_SetupPinOptions(SDAA_GPIO, GPIO_INPUT, GPIO_ASYNC | GPIO_PULLUP);

    //	Reset the module
    I2caRegs.I2CMDR.all = 0;
    //	200MHz/(19+1) = 10MHz
    I2caRegs.I2CPSC.bit.IPSC = 19;
    //	Minimum low time for slave is 1.3us (program 1.5us)
    I2caRegs.I2CCLKL = 15;
    //	Minimum high time for slave is 0.6us (program 1us)
    I2caRegs.I2CCLKH = 10;
    //	Module stops in breakpoint
    I2caRegs.I2CMDR.bit.FREE = 1;
    //	Module operate as master
    I2caRegs.I2CMDR.bit.MST = 1;
    //	Enables interrupts
    I2caRegs.I2CIER.bit.ARDY = 1;
    I2caRegs.I2CIER.bit.NACK = 1;
    I2caRegs.I2CIER.bit.RRDY = 1;
    I2caRegs.I2CIER.bit.SCD = 1;
    I2caRegs.I2CIER.bit.XRDY = 1;
    //	Remove module from reset condition
    I2caRegs.I2CMDR.bit.IRS = 1;
}

/* ============================================================================
    FUNCTION NAME:
    PURPOSE:
    DESCRIPTION:
    DOMAIN:
    ACCURACY:
    NOTES:
 ============================================================================ */
void i2ca_start_transfer(int16_t sadd, int16_t n_wr, int16_t n_rd, int16_t op)
{
union I2CMDR_REG cmdr;

    i2ca.stop = false;
    i2ca.nack = false;
    i2ca.done = false;
    i2ca.sar = sadd;
    i2ca.n_writes = n_wr;
    i2ca.n_reads = n_rd;

    DELAY_US(10);

    cmdr.all = 0;
    cmdr.bit.FREE = 1;
    cmdr.bit.IRS = 1;
    cmdr.bit.MST = 1;
    switch( op )
    {
    case I2C_WRITE:
        i2ca.state = I2C_WRITING;
        i2ca.trx_ptr = 0;
        I2caRegs.I2CSAR.bit.SAR = sadd;
        I2caRegs.I2CCNT = n_wr;
        cmdr.bit.TRX = 1;
        cmdr.bit.STP = 1;
        cmdr.bit.STT = 1;
        break;

    case I2C_WRITE_READ:
        i2ca.state = I2C_WRITING;
        i2ca.trx_ptr = 0;
        I2caRegs.I2CSAR.bit.SAR = sadd;
        I2caRegs.I2CCNT = n_wr;
        cmdr.bit.TRX = 1;
        cmdr.bit.STP = 0;
        cmdr.bit.STT = 1;
        break;

    case I2C_READ:
        i2ca.state = I2C_READING;
        i2ca.trx_ptr = 0;
        I2caRegs.I2CSAR.bit.SAR = sadd;
        I2caRegs.I2CCNT = n_rd;
        cmdr.bit.TRX = 0;
        cmdr.bit.STP = 1;
        cmdr.bit.STT = 1;
        break;

    case I2C_POLLING:
        i2ca.state = EEPROM_POLLING;
        i2ca.trx_ptr = 0;
        I2caRegs.I2CSAR.bit.SAR = sadd;
        I2caRegs.I2CCNT = n_wr;
        cmdr.bit.TRX = 1;
        cmdr.bit.STP = 1;
        cmdr.bit.STT = 1;
        break;

    default:
        break;
    }

    I2caRegs.I2CMDR.all = cmdr.all;
}

/* ============================================================================
    FUNCTION NAME:
    PURPOSE:
    DESCRIPTION:
    DOMAIN:
    ACCURACY:
    NOTES:
 ============================================================================ */
bool i2ca_tx_rx(uint16_t sadd, int16_t n_writes, int16_t n_reads)
{
bool esito;

    if( n_reads == 0 )
    {
        //  Start write only transfer
        i2ca_start_transfer(sadd, n_writes, n_reads, I2C_WRITE);
    }
    else
    {
        if( n_writes == 0 )
        {
            //  start read only transfer
            i2ca_start_transfer(sadd, n_writes, n_reads, I2C_READ);
        }
        else
        {
            //  start a read after write transfer
            i2ca_start_transfer(sadd, n_writes, n_reads, I2C_WRITE_READ);
        }
    }

    //  wait for end of operation
    while( !(i2ca.done /*|| i2ca.nack*/) );
    if( i2ca.nack )
    {
        esito = false;
    }
    else
    {
        esito = true;
    }

    return ( esito );
}

/* ============================================================================
    FUNCTION NAME:
    PURPOSE:
    DESCRIPTION:
    DOMAIN:
    ACCURACY:
    NOTES:
 ============================================================================ */
interrupt void i2ca_isr(void)
{
uint16_t ius;
uint16_t tmp;

    // Insert ISR Code here.......
    ius = I2caRegs.I2CISRC.all;
    switch( ius  )
    {
    case I2C_NO_ISRC:
        tmp = 0;
        break;

    case I2C_ARB_ISRC:
        tmp = 0;
        break;

    case I2C_NACK_ISRC:
        I2caRegs.I2CSTR.all = I2C_CLR_NACK_BIT;
        I2caRegs.I2CMDR.bit.STP = 1;
        i2ca.nack = true;
        while(!I2caRegs.I2CSTR.bit.SCD);
        break;

    case I2C_ARDY_ISRC:
        I2caRegs.I2CSTR.all = I2C_CLR_ARDY_BIT;
        if( (i2ca.state == EEPROM_POLLING) || i2ca.nack )
        {
            i2ca.done = true;
        }
        else
        {
            if( i2ca.state == I2C_WRITING )
            {
                i2ca_start_transfer(i2ca.sar, 0, i2ca.n_reads, I2C_READ);
            }
        }
        break;

    case I2C_RX_ISRC:
        I2caRegs.I2CSTR.all = I2C_CLR_RRDY_BIT;
        i2ca.rx_buf[i2ca.trx_ptr++] = I2caRegs.I2CDRR.bit.DATA;
        break;

    case I2C_TX_ISRC:
        I2caRegs.I2CDXR.bit.DATA = i2ca.tx_buf[i2ca.trx_ptr++];
        break;

    case I2C_SCD_ISRC:
        i2ca.state = I2C_NOP;
        i2ca.stop = true;
        i2ca.done = true;
        break;

    case I2C_AAS_ISRC:
        tmp = 0;
        break;

    default:
        tmp = 0;
        break;
    }

    PieCtrlRegs.PIEACK.all = PIEACK_GROUP8;
}
