//###########################################################################

// FILE:   upp_sdr_tx_cpu01.c

// TITLE:  upp transmit example for F2837xD.

//

//! \addtogroup cpu01_example_list

//! <h1> upp_sdr_tx </h1>

//!

//

//###########################################################################

// $TI Release: F2837xD Support Library v180 $

// $Release Date: Fri Nov  6 16:19:46 CST 2015 $

// $Copyright: Copyright (C) 2013-2015 Texas Instruments Incorporated -
//             http://www.ti.com/ ALL RIGHTS RESERVED $
//###########################################################################


// To run this example user need to have two soprano boards and connect all upp pins from one board to other with comman ground.
// On one of the board user need to load this example code and on other board load example "upp_sdr_rx" and run together.
//
//				|-----------|				|-----------|
//				|			|=====D0-D7=====|			|
//				|  F28377xD	|-----CLK-------|   F2837xD	|
//				|  Board-1	|				|	Board-2	|
//				|	TX		|-----ENABLE----|	RX		|
//				|			|-----START-----|			|
//				|-----------|				|-----------|
//
// Following are the steps to run the test -
// Load the example code upp_sdr_tx on the board-1
// Load the example code upp_sdr_rx on the board-2
// Run the code upp_sdr_rx (this need to be run before running tx code)
// Run the code upp_sdr_tx

#include "F28x_Project.h"     // Device Headerfile (CPU1) and Examples Include File
#include "F2837xD_Upp_defines.h" // uPP defines

#define TEST_PASS 0xABCDABCD
#define TEST_FAIL 0xDEADDEAD

#define LINE_CNT  4
#define BYTE_CNT  64
#define WIN_CNT  8
#define WIN_BYTE_CNT   256
#define WIN_WORD_CNT   128

extern void InitUpp1Gpio(void);
extern void SoftResetUpp(void);

interrupt void local_UPPA_ISR(void);

volatile long int ErrCount;
volatile long int TEST_STATUS = TEST_FAIL;
volatile long int eow_int_cnt = 0;
volatile long int eol_int_cnt = 0;
volatile long int RdValue = 0;
volatile long int WrValue = 0;
volatile int InitTxMsgRam = 0;



void main(void)
{

	int i;

	TEST_STATUS = TEST_FAIL;
	ErrCount = 0x0;
	
	InitSysCtrl();

 	DINT;
 	
//  Initialize the PIE control registers to their default state.
//  The default state is all PIE interrupts disabled and flaLS
//  are cleared.
//  This function is found in the DSP2833x_PieCtrl.c file.
    InitPieCtrl();

// Disable CPU interrupts and clear all CPU interrupt flaLS:
    EALLOW;   
      IER = 0x0000;
      IFR = 0x0000;
    EDIS;
	
	
// Initialize the PIE vector table with pointers to the shell Interrupt
// LService Routines (ISR).
// This will populate the entire table, even if the interrupt
// is not used in this example.  This is useful for debug purposes.
// The shell ISR routines are found in DSP2833x_DefaultIsr.c.
// This function is found in DSP2833x_PieVect.c.
   InitPieVectTable();

   EALLOW;   
   PieVectTable.UPPA_INT = &local_UPPA_ISR;
// Enable the Interrupt No 8.
   IER = M_INT8 ;	
// Enable Interrupt for UPPA Interrupt.
   PieCtrlRegs.PIEIER8.bit.INTx15=1;

// Enable PIE & CPU level Interrupts.
   EnableInterrupts();

// Issue Soft Reset (internal) to uPP.
   SoftResetUpp();

// Configure the GPIO muxing for uPP pins.
   InitUpp1Gpio();

// Initialize the TX MSG RAM.
  for (i = 0; i < uPP_TX_MSGRAM_SIZE/2 ; i+=2)
  {
	  WrValue = WrValue + 0x12345678;
	  *(Uint32 *)(uPP_TX_MSGRAM_ADDR + i) = WrValue;
  }

// Configure uPP for TX
   UppRegs.IFCFG.bit.CLKDIVA = 0x4; // Div8.
   UppRegs.IFCFG.bit.CLKINVA = 1;  //
   UppRegs.CHCTL.bit.MODE = uPP_TX_MODE; // Setup for TX.
   UppRegs.CHCTL.bit.DRA = uPP_SDR; // SDR mode
   UppRegs.IFIVAL.all = 0x0000; //Idle Value

//Enable EOL/EOW interrupt
   UppRegs.INTENSET.bit.EOLI = 1;
   UppRegs.INTENSET.bit.EOWI = 1;
   UppRegs.GINTEN.bit.GINTEN = 1;

   UppRegs.PERCTL.bit.PEREN = 1;

   UppRegs.CHIDESC0 = uPP_TX_MSGRAM_ADDR;
   UppRegs.CHIDESC1.bit.LCNT = LINE_CNT;
   UppRegs.CHIDESC1.bit.BCNT = BYTE_CNT;
   UppRegs.CHIDESC2.all = BYTE_CNT;

   while (eow_int_cnt < WIN_CNT);

// Disable the uPP to stop transmission after expected window count is done.
   UppRegs.PERCTL.bit.PEREN = 0;

   if (ErrCount == 0x0) {
   	TEST_STATUS = TEST_PASS;
   }

 //TEST DONE
   asm("          ESTOP0");
   for(;;);

}

// INT8.16
interrupt void local_UPPA_ISR(void)     // DMA Channel 1
{
   // To receive more interrupts from this PIE group, acknowledge this interrupt
	int i;
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP8;
   
   	 if (UppRegs.GINTFLG.all != 0x0) {
   	 	 if(UppRegs.ENINTST.bit.EOWI == 0x1) { //Check for EOW Interrupt flag
   	 		eow_int_cnt++;
   	 		if (eow_int_cnt < (WIN_CNT - 1)) InitTxMsgRam = 1;
   	 		//Enable EOL interrupt
   	 	    UppRegs.INTENSET.bit.EOLI = 1;
   	 		//Clear the Status for EOW Interrupt
   	 	    UppRegs.ENINTST.all = uPP_INT_EOWI; // Can't use header file because RMW will clear all other status.
   	 	    if (UppRegs.ENINTST.bit.EOWI != 0)
   	 	    {
   	 	    	ErrCount++;
   	   			asm ("      ESTOP0");
   	   			for(;;);
   	 	    }
   	 	 }
   	 	 if(UppRegs.ENINTST.bit.EOLI == 0x1) { // Check for EOL Interrupt Flag
   	 		eol_int_cnt++;
   	 		// Disable EOL Interrupt.
   	 	    UppRegs.ENINTST.all = uPP_INT_EOLI; // Can't use header file beacuse RMW will clear all other status.
   	 	    if (UppRegs.ENINTST.bit.EOLI != 0)
   	 	    {
   	 	    	ErrCount++;
   	   			asm ("      ESTOP0");
   	   			for(;;);
   	 	    }
   	 	    UppRegs.INTENCLR.all = uPP_INT_EOLI;
   	 	    if (UppRegs.INTENSET.bit.EOLI != 0)
   	 	    {
   	 	    	ErrCount++;
   	   			asm ("      ESTOP0");
   	   			for(;;);
   	 	    }
   	 	    // Initialize the Channel Descriptor for Next window transfer.
   	 	    if (eow_int_cnt < (WIN_CNT -1))
   	 	    {
   	 	    	if (eow_int_cnt%2)
   	 	    	{
   				   if(InitTxMsgRam == 1)
   				   {
						for (i = 0; i < WIN_WORD_CNT ; i+=2)
						{
						   WrValue = WrValue + 0x12345678;
						   *(Uint32 *)(uPP_TX_MSGRAM_ADDR + i) = WrValue;
						}
						InitTxMsgRam = 0;
   				   }
   	 	    		UppRegs.CHIDESC0 = uPP_TX_MSGRAM_ADDR;
   	 	    		UppRegs.CHIDESC1.bit.LCNT = LINE_CNT;
   	 	    		UppRegs.CHIDESC1.bit.BCNT = BYTE_CNT;
   	 	    		UppRegs.CHIDESC2.all = BYTE_CNT;
   	 	    	} else {
   	 	    		if(InitTxMsgRam == 1)
   	 	    		{
						for (i = 0; i < WIN_WORD_CNT ; i+=2)
						{
							WrValue = WrValue + 0x12345678;
							*(Uint32 *)((uPP_TX_MSGRAM_ADDR + WIN_WORD_CNT) + i) = WrValue;
						}
						InitTxMsgRam = 0;
   	 	    		}
					UppRegs.CHIDESC0 = uPP_TX_MSGRAM_ADDR + (LINE_CNT * BYTE_CNT);
					UppRegs.CHIDESC1.bit.LCNT = LINE_CNT;
					UppRegs.CHIDESC1.bit.BCNT = BYTE_CNT;
					UppRegs.CHIDESC2.all = BYTE_CNT;
				}
   	 	    }
   	 	 }
   		 // Clear Global Interrupt.
   	 	 RdValue = UppRegs.ENINTST.all;
   	 	 UppRegs.GINTCLR.bit.GINTCLR = 1;
   		 if (UppRegs.GINTFLG.all != 0x0)
   		 {
   			ErrCount++;
   			asm ("      ESTOP0");
   			for(;;);
   		 }
   	 }
}
