/*---------------------------------------------------------------------------*/
/* This example demonstrates the use of add_device and freopen to redirect   */
/* stdout to a user-defined device; in this case, the UART.                  */
/*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <file.h>
#include "uart_drv.h"

int main()
{
    FILE *uart = NULL;

    /*-----------------------------------------------------------------------*/
    /* Add the UART device.  When fopen is called with a filename that       */
    /* begins "uart:", the UART device will be used to handle the file.      */
    /*-----------------------------------------------------------------------*/
    add_device("uart",
               _SSA, 
               UART_open,
               UART_close,
               UART_read,
               UART_write,
               UART_lseek,
               UART_unlink,
               UART_rename);

    /*-----------------------------------------------------------------------*/
    /* Open a UART file.  Because the "uart" device is _SSA, only one UART   */
    /* file may be open at once.                                             */
    /*-----------------------------------------------------------------------*/
    uart = fopen("uart:", "w");
    assert(uart != NULL);

    /*-----------------------------------------------------------------------*/
    /* Now, write something to the UART device                               */
    /*-----------------------------------------------------------------------*/
    fputs("hello, world on UART\n", uart);

    /*-----------------------------------------------------------------------*/
    /* We must close the UART file before opening another with freopen,      */
    /* below.  Closing a file will flush the buffer automatically.           */
    /*-----------------------------------------------------------------------*/
    fclose(uart);

    /*-----------------------------------------------------------------------*/
    /* Show that stdout still works.                                         */
    /*-----------------------------------------------------------------------*/
    puts("hello, world on stdout");

    /*-----------------------------------------------------------------------*/
    /* Now reassign stdout to be a UART device!                              */
    /*-----------------------------------------------------------------------*/
    assert(freopen("uart:", "w", stdout) != NULL);
    
    /*-----------------------------------------------------------------------*/
    /* Now, writing to stdout actually writes to UART                        */
    /*-----------------------------------------------------------------------*/
    puts("hello, world on the new UART stdout");

    /*-----------------------------------------------------------------------*/
    /* All files are flushed when the program exits.                         */
    /*-----------------------------------------------------------------------*/
    return 0;
}
