/*
 * Con_Var.h
 *
 *  Created on: Aug 17, 2019
 *      Author: Charles Chen
 */

#ifndef CON_VAR_H_
#define CON_VAR_H_

#include <stdint.h>

#define WRT_CMD 0x3AA
#define CASCADE_NUM 12

#define CPU_F ((double)48000000)
#define delay_us(x) __delay_cycles((long)(CPU_F*(double)x/1000000.0))
#define delay_ms(x) __delay_cycles((long)(CPU_F*(double)x/1000.0))

extern uint8_t bit_i, Device_j, Frame_k;
extern uint8_t delay_i;
extern uint8_t up_down_mode;

extern uint16_t breath_i;

extern uint64_t GSout0[CASCADE_NUM];
extern uint64_t GSout1[CASCADE_NUM];
extern uint64_t GSout2[CASCADE_NUM];

extern uint64_t SDI_Data;

extern uint16_t GS_exp[256];

extern void Con_Var_init();

#endif
/* CON_VAR_H_ */
