/*
 * main.c
 *
 *  Created on: Aug 17, 2019
 *      Author: Charles Chen
 */

#include <ti/devices/msp432p4xx/driverlib/driverlib.h>
#include <ti/devices/msp432p4xx/inc/msp.h>
#include <stdint.h>
#include "IO_INIT.h"
#include "Con_Var.h"

//uint32_t aclk, mclk, smclk, hsmclk, bclk;

void LED_breath();

void main(void)
{

	WDT_A->CTL = WDT_A_CTL_PW    // Stop WDT
	        | WDT_A_CTL_HOLD;

/*
//used for debugging
    aclk = CS_getACLK();
    mclk = CS_getMCLK();
    smclk = CS_getSMCLK();
    hsmclk = CS_getHSMCLK();
    bclk = CS_getBCLK();
*/

	IO_init();
	Con_Var_init();

	while(1)
	{
	    for(Device_j=0;Device_j<CASCADE_NUM;Device_j++)//N-1 cascaded device data
        {
            SDI_Data=(((uint64_t)WRT_CMD)<<36)+(GSout0[Device_j]<<24)+(GSout1[Device_j]<<12)+GSout2[Device_j];

            for(bit_i=0;bit_i<48;bit_i++)//write Data
            {
                SDI_H();
                SDI_L();
                if((SDI_Data>>(47-bit_i))&(0x0001))
                {
                    SDI_H();
                    SDI_L();
                    for (delay_i = 0; delay_i < 1; delay_i++);
                }
                else
                {
                    SDI_L();
                    for (delay_i = 0; delay_i < 2; delay_i++);
                }
            }
            delay_us(9);//wait for 4.5 tcycle to generate EOS
        }

	    delay_us(600);//wait for 8 tcycle to generate LATCH
	    LED_breath();

	}

}

void LED_breath()
{
    if(breath_i==0)
    {
        up_down_mode =1;
    }
    if(breath_i==255)
    {
        up_down_mode =0;
    }

    for(Frame_k=0; Frame_k<12; Frame_k++)
    {
        GSout0[Frame_k] = GS_exp[breath_i];
        GSout1[Frame_k] = GS_exp[breath_i];
        GSout2[Frame_k] = GS_exp[breath_i];
    }

    if(up_down_mode==1)
    {
        breath_i++;
    }
    else
    {
        breath_i--;
    }
}
