#include "_f2mc8fx.h"
#include "TypeDef.h"   
#include "Beep.h"		

__direct uint8  PlayMusicIndex; 
uint8 PlayMusicTime;
/*------------------------------ Function --------------------------------------
    Function:       PlayMusicREQ
    Description:    Play music request
    Calls:
    Called By:
    Table Accessed:
    Table Updated:
    Input:
    Output:         PlayMusicIndex,F_PlayMusicREQ
    Return:
    Others:
------------------------------------------------------------------------------*/
void PlayMusicREQ(uint8 ReqNum)
{
     PlayMusicIndex = ReqNum;  
	 PlayMusicTime = 0;
}

/******************************************************************************
ƣPPG_Init
ܣʼPPG

أ

***************************************************************************/
void Beep_Init(void)
{
 IO_Beep     = FALSE;
 IODDR_Beep  = TRUE;
 IOPUL_Beep  = FALSE;
}

/*------------------------------ Function --------------------------------------
    Function:       MusicProcess
    Description:    Music proecess
    Calls:
    Called By:      Timer3INT
    Table Accessed:
    Table Updated:
    Input:
    Output:
    Return:
    Others:
------------------------------------------------------------------------------*/
void MusicProcess(void)
{
	#define DV_PlayMusicTime 25
	#define DV_PlayMusicTimeLength 50
	if(PlayMusicIndex > 0)
	{
		PlayMusicTime ++ ;
		if(PlayMusicTime < DV_PlayMusicTime)
		{
			IO_Beep = TRUE;
		}
		else if(PlayMusicTime < DV_PlayMusicTimeLength)
		{
			IO_Beep = FALSE;
		}
		else
		{
			PlayMusicTime = 0;
			PlayMusicIndex --;
		}
	}
	else
	{
		IO_Beep = FALSE;
		PlayMusicTime = 0;
	}	
}
