#include "_f2mc8fx.h"
#include "TypeDef.h"   
#include "Key.h"	
#include "LED.h"	

__direct Flag_Group   Switch_Flag;

void Key_Init(void)
{
 IO_Key2        = TRUE;
 IODDR_Key2     = FALSE;
 IOPUL_Key2     = TRUE;

 IO_Key4        = TRUE;
 IODDR_Key4     = FALSE;
 IOPUL_Key4     = TRUE;
}

void DetectKey(void)
{
	static UINT8  	FilterKey1Pressed = 0;
	static UINT8  	FilterKey2Pressed = 0;
	static UINT8  	FilterKey3Pressed = 0;
	static UINT8  	FilterKey4Pressed = 0;

	if(!IO_Key2)
	{
		if (FilterKey2Pressed++ == KEY_FILTER_TIMES)   // Filter
		{
			F_Key2 = TRUE;                      // Generate key flag
		}
		if(FilterKey2Pressed > KEY_FILTER_TIMES)
		{
			FilterKey2Pressed = KEY_FILTER_TIMES+1;      // Prevent overflow
		}
	}
	else
	{
		FilterKey2Pressed = 0;
		F_Key2 = FALSE;                      // Generate key flag
	}

	if(!IO_Key4)
	{
		if (FilterKey4Pressed++ == KEY_FILTER_TIMES)   // Filter
		{
			F_Key4 = TRUE;                      // Generate key flag
		}
		if(FilterKey4Pressed > KEY_FILTER_TIMES)
		{
			FilterKey4Pressed = KEY_FILTER_TIMES+1;      // Prevent overflow
		}
	}
	else
	{
		FilterKey4Pressed = 0;
		F_Key4 = FALSE;                      // Generate key flag
	}
}

void KeyProcess(void)
{
	if(F_Key1)
	{
		F_Key1 = FALSE;
		DisplayStep = DisplayStep_None;
		if(DisplayMode != Mode_LEDAllLight)
		{
			DisplayMode = Mode_LEDAllLight; // 1£ʾΪȫģʽ
		}
		else
		{
			DisplayMode = Mode_LEDNoLight; // 1£ʾΪȫģʽ
		}
		DisplaySpeed = DisplaySpeed0;  //==ʱѭٶ
	}
	if(F_Key2)
	{
		F_Key2 = FALSE;
		if(DisplayMode != Mode_LEDFlashLight)
		{
			DisplayMode = Mode_LEDFlashLight; // 2£ʾΪѭģʽ
			DisplayStep = DisplayStep_None;
			DisplaySpeed = DisplaySpeed7;
		}
		else
		{
			switch(DisplaySpeed)
			{
				case DisplaySpeed1 : {DisplaySpeed = DisplaySpeed1;break;}
				case DisplaySpeed2 : {DisplaySpeed = DisplaySpeed1;break;}
				case DisplaySpeed3 : {DisplaySpeed = DisplaySpeed2;break;}
				case DisplaySpeed4 : {DisplaySpeed = DisplaySpeed3;break;}
				case DisplaySpeed5 : {DisplaySpeed = DisplaySpeed4;break;}
				case DisplaySpeed6 : {DisplaySpeed = DisplaySpeed5;break;}
				case DisplaySpeed7 : {DisplaySpeed = DisplaySpeed6;break;}
				default : {DisplaySpeed = DisplaySpeed7;break;}
			}
		}
	}
	if(F_Key3)
	{
		F_Key3 = FALSE;
		if(DisplayMode != Mode_LEDFlashLight)
		{
			DisplayMode = Mode_LEDFlashLight; // 2£ʾΪѭģʽ
			DisplayStep = DisplayStep_None;
			DisplaySpeed = DisplaySpeed1;
		}
		else
		{
			switch(DisplaySpeed)
			{
				case DisplaySpeed1 : {DisplaySpeed = DisplaySpeed2;break;}
				case DisplaySpeed2 : {DisplaySpeed = DisplaySpeed3;break;}
				case DisplaySpeed3 : {DisplaySpeed = DisplaySpeed4;break;}
				case DisplaySpeed4 : {DisplaySpeed = DisplaySpeed5;break;}
				case DisplaySpeed5 : {DisplaySpeed = DisplaySpeed6;break;}
				case DisplaySpeed6 : {DisplaySpeed = DisplaySpeed7;break;}
				case DisplaySpeed7 : {DisplaySpeed = DisplaySpeed7;break;}
				default : {DisplaySpeed = DisplaySpeed1;break;}
			}
		}
	}
	if(F_Key4)
	{
		F_Key4 = FALSE;
		if(DisplayMode != Mode_LEDPauseLight)
		{
			DisplayMode = Mode_LEDPauseLight; // 2£ʾΪѭģʽ
		}
		else
		{
			DisplayStep ++; 
			if(DisplayStep >= DisplayStep_End)
			{
				DisplayStep = DisplayStep_None;
			}
		}
		DisplaySpeed = DisplaySpeed0;  //==ʱѭٶ
	}
}

