#include "_f2mc8fx.h"
#include "TypeDef.h"   
#include "LED.h"
#include "Key.h"
#include "UART.h"


enum DisplayModeDefine DisplayMode;

UINT16 DisplaySpeed;

UINT8 DisplayStep;

void DisplayDataProcess(void);
void RefreshLEDDriver(void);

Flag_Group   DisplayBuf[16];

//===============================DSGͶ붨()=====================
// 
#define F_LED_Dot1			DisplayBuf[8].Bits.Flag_0	
#define F_LED_Dot2			DisplayBuf[8].Bits.Flag_1	
#define F_LED_Dot3			DisplayBuf[8].Bits.Flag_2	
#define F_LED_Dot4			DisplayBuf[8].Bits.Flag_3	
#define F_LED_Dot5			DisplayBuf[8].Bits.Flag_4	
// м
#define F_LED_Dot6			DisplayBuf[10].Bits.Flag_1
#define F_LED_Dot7			DisplayBuf[10].Bits.Flag_2
#define F_LED_Dot8			DisplayBuf[10].Bits.Flag_3
#define F_LED_Dot9			DisplayBuf[10].Bits.Flag_4

// 
#define F_LED_Dot10			DisplayBuf[10].Bits.Flag_0
#define F_LED_Dot11			DisplayBuf[8].Bits.Flag_5

//ܵһ8
#define F_Digital_DotA11			DisplayBuf[0].Bits.Flag_0  	//== A		
#define F_Digital_DotB11			DisplayBuf[0].Bits.Flag_1	//== B
#define F_Digital_DotC11			DisplayBuf[0].Bits.Flag_2  	//== C	
#define F_Digital_DotD11			DisplayBuf[0].Bits.Flag_3  	//== D	
#define F_Digital_DotE11			DisplayBuf[0].Bits.Flag_4  	//== E		
#define F_Digital_DotF11			DisplayBuf[0].Bits.Flag_5  	//== F		
#define F_Digital_DotG11			DisplayBuf[1].Bits.Flag_3	//== G

//ܵڶ8
#define F_Digital_DotA12			DisplayBuf[2].Bits.Flag_0  	//== A		
#define F_Digital_DotB12			DisplayBuf[2].Bits.Flag_1	//== B
#define F_Digital_DotC12			DisplayBuf[2].Bits.Flag_2  	//== C	
#define F_Digital_DotD12			DisplayBuf[2].Bits.Flag_3  	//== D	
#define F_Digital_DotE12			DisplayBuf[2].Bits.Flag_4  	//== E		
#define F_Digital_DotF12			DisplayBuf[2].Bits.Flag_5  	//== F		
#define F_Digital_DotG12			DisplayBuf[3].Bits.Flag_3	//== G		

//ܵ8
#define F_Digital_DotA13			DisplayBuf[4].Bits.Flag_0  	//== A		
#define F_Digital_DotB13			DisplayBuf[4].Bits.Flag_1	//== B
#define F_Digital_DotC13			DisplayBuf[4].Bits.Flag_2  	//== C	
#define F_Digital_DotD13			DisplayBuf[4].Bits.Flag_3  	//== D	
#define F_Digital_DotE13			DisplayBuf[4].Bits.Flag_4  	//== E		
#define F_Digital_DotF13			DisplayBuf[4].Bits.Flag_5  	//== F		
#define F_Digital_DotG13			DisplayBuf[5].Bits.Flag_3	//== G	

//ܵĸ8
#define F_Digital_DotA14			DisplayBuf[6].Bits.Flag_0  	//== A		
#define F_Digital_DotB14			DisplayBuf[6].Bits.Flag_1	//== B
#define F_Digital_DotC14			DisplayBuf[6].Bits.Flag_2  	//== C	
#define F_Digital_DotD14			DisplayBuf[6].Bits.Flag_3  	//== D	
#define F_Digital_DotE14			DisplayBuf[6].Bits.Flag_4  	//== E		
#define F_Digital_DotF14			DisplayBuf[6].Bits.Flag_5  	//== F		
#define F_Digital_DotG14			DisplayBuf[7].Bits.Flag_3	//== G	

Flag_Group   LED_Flag;
     #define F_FlashOn0_5                       LED_Flag.Bits.Flag_0
	 #define F_FlashOn0_25                      LED_Flag.Bits.Flag_1


/*------------------------------ Function --------------------------------------
    Function:    LED_DRV_TransmitByteProcess
    Description: Transmit a byte
    Calls:
    Called By:
    Table Accessed:
    Table Updated:
    Input:
    Output:
    Return:
    Others:
------------------------------------------------------------------------------*/
void LED_Init(void)
{
 IO_LED_SDA		= FALSE;
 IODDR_LED_SDA	= TRUE;
 IOPUL_LED_SIN	= FALSE;

 IO_LED_SCLK		= FALSE;
 IODDR_LED_SCLK	= TRUE;
 IOPUL_LED_SCLK	= FALSE;

 IODDR_SOUT = FALSE;
 IOPUL_SOUT= FALSE;

 IO_LED_LAT	= FALSE;
 IODDR_LED_LAT=TRUE;
 IOPUL_LED_LAT=FALSE;

 IO_BLANK = FALSE;
 IODDR_BLANK = TRUE;
 IOPUL_BLANK = FALSE;

 IO_LED1        = FALSE;
 IODDR_LED1     = TRUE;
 IOPUL_LED1     = FALSE;

 IO_LED2        = FALSE;
 IODDR_LED2     = TRUE;
 IOPUL_LED2     = FALSE;

 IO_LED3        = FALSE;
 IODDR_LED3     = TRUE;
 IOPUL_LED3     = FALSE;
}

/*------------------------------ Function --------------------------------------
    Function:    LED_DRV_TransmitByteProcess
    Description: Transmit a byte
    Calls:
    Called By:
    Table Accessed:
    Table Updated:
    Input:
    Output:
    Return:
    Others:
------------------------------------------------------------------------------*/
void LED_DRV_TransmitByteProcess_Com(void)
{
    UINT8 i,Data_Temp;
	IODDR_LED_LAT=TRUE;
    IODDR_LED_SCLK = TRUE;
    IODDR_LED_SDA  = TRUE;
	IODDR_BLANK = TRUE;
	IODDR_SOUT = FALSE;
	// =============ݴ========================
	IO_LED_LAT = FALSE;
    ASM_NOP();ASM_NOP();
	IO_LED_LAT = TRUE;
    ASM_NOP();ASM_NOP();
	IO_LED_LAT = FALSE;
    ASM_NOP();ASM_NOP();
    IO_LED_SCLK = FALSE;//==λߵ£ʱس֣Ϊģʽ
	IO_LED_SDA = TRUE;
    ASM_NOP();ASM_NOP();
    IO_LED_SCLK = TRUE;                          // Rinsing edge.
    ASM_NOP();ASM_NOP();

	Data_Temp = 0x96;//==дֽ 0x96==8λ
    for (i=0; i<8; i++)
    {
        IO_LED_SCLK = 0;                          // Clock falling edge.
        ASM_NOP();ASM_NOP();
		if((Data_Temp & 0x80) == 0x80)
		{
			IO_LED_SDA = TRUE;
		}
		else
		{
			IO_LED_SDA = FALSE;
		}
        Data_Temp = Data_Temp << 1;                        // Shift
        IO_LED_SCLK = 1;                          // Rinsing edge.
        ASM_NOP();ASM_NOP();
    }
	
	Data_Temp = 0x00;//==ͱʾ 0x00 == 2λ
	Data_Temp = Data_Temp <<6;
    for (i=0; i<2; i++)
    {
        IO_LED_SCLK = 0;                          // Clock falling edge.
        ASM_NOP();ASM_NOP();
		if((Data_Temp & 0x80) == 0x80)
		{
			IO_LED_SDA = TRUE;
		}
		else
		{
			IO_LED_SDA = FALSE;
		}
        Data_Temp = Data_Temp << 1;                        // Shift
        IO_LED_SCLK = 1;                          // Rinsing edge.
        ASM_NOP();ASM_NOP();
    }
	Data_Temp = 0x00;//==Ϳ·ֵѹֵ 0x04 == 3λ
	Data_Temp = Data_Temp <<5;
    for (i=0; i<3; i++)
    {
        IO_LED_SCLK = 0;                          // Clock falling edge.
        ASM_NOP();ASM_NOP();
		if((Data_Temp & 0x80) == 0x80)
		{
			IO_LED_SDA = TRUE;
		}
		else
		{
			IO_LED_SDA = FALSE;
		}
        Data_Temp = Data_Temp << 1;                        // Shift
        IO_LED_SCLK = 1;                          // Rinsing edge.
        ASM_NOP();ASM_NOP();
    }
	Data_Temp = 0x00;//==Ͷ·ֵѹֵ 0x00 == 2λ
	Data_Temp = Data_Temp <<6;
    for (i=0; i<2; i++)
    {
        IO_LED_SCLK = 0;                          // Clock falling edge.
        ASM_NOP();ASM_NOP();
		if((Data_Temp & 0x80) == 0x80)
		{
			IO_LED_SDA = TRUE;
		}
		else
		{
			IO_LED_SDA = FALSE;
		}
        Data_Temp = Data_Temp << 1;                        // Shift
        IO_LED_SCLK = 1;                          // Rinsing edge.
        ASM_NOP();ASM_NOP();
    }
	Data_Temp = 0x00;//==ʡģʽֵ 0x00 == 2λ
	Data_Temp = Data_Temp <<6;
    for (i=0; i<2; i++)
    {
        IO_LED_SCLK = 0;                          // Clock falling edge.
        ASM_NOP();ASM_NOP();
		if((Data_Temp & 0x80) == 0x80)
		{
			IO_LED_SDA = TRUE;
		}
		else
		{
			IO_LED_SDA = FALSE;
		}
        Data_Temp = Data_Temp << 1;                        // Shift
        IO_LED_SCLK = 1;                          // Rinsing edge.
        ASM_NOP();ASM_NOP();
    }
	Data_Temp = 0x00;//==Ԥλ 0x00 == 7λ
	Data_Temp = Data_Temp <<1;
    for (i=0; i<7; i++)
    {
        IO_LED_SCLK = 0;                          // Clock falling edge.
        ASM_NOP();ASM_NOP();
		if((Data_Temp & 0x80) == 0x80)
		{
			IO_LED_SDA = TRUE;
		}
		else
		{
			IO_LED_SDA = FALSE;
		}
        Data_Temp = Data_Temp << 1;                        // Shift
        IO_LED_SCLK = 1;                          // Rinsing edge.
        ASM_NOP();ASM_NOP();
    }
	Data_Temp = 0x3F;//==Rɫȿֵ 0x3F == 7λ
	Data_Temp = Data_Temp <<1;
    for (i=0; i<7; i++)
    {
        IO_LED_SCLK = 0;                          // Clock falling edge.
        ASM_NOP();ASM_NOP();
		if((Data_Temp & 0x80) == 0x80)
		{
			IO_LED_SDA = TRUE;
		}
		else
		{
			IO_LED_SDA = FALSE;
		}
        Data_Temp = Data_Temp << 1;                        // Shift
        IO_LED_SCLK = 1;                          // Rinsing edge.
        ASM_NOP();ASM_NOP();
    }
	Data_Temp = 0x3F;//==Gɫȿֵ 0x3F == 7λ
	Data_Temp = Data_Temp <<1;
    for (i=0; i<7; i++)
    {
        IO_LED_SCLK = 0;                          // Clock falling edge.
        ASM_NOP();ASM_NOP();
		if((Data_Temp & 0x80) == 0x80)
		{
			IO_LED_SDA = TRUE;
		}
		else
		{
			IO_LED_SDA = FALSE;
		}
        Data_Temp = Data_Temp << 1;                        // Shift
        IO_LED_SCLK = 1;                          // Rinsing edge.
        ASM_NOP();ASM_NOP();
    }
	Data_Temp = 0x3F;//==Bɫȿֵ 0x3F == 7λ
	Data_Temp = Data_Temp <<1;
    for (i=0; i<7; i++)
    {
        IO_LED_SCLK = 0;                          // Clock falling edge.
        ASM_NOP();ASM_NOP();
		if((Data_Temp & 0x80) == 0x80)
		{
			IO_LED_SDA = TRUE;
		}
		else
		{
			IO_LED_SDA = FALSE;
		}
        Data_Temp = Data_Temp << 1;                        // Shift
        IO_LED_SCLK = 1;                          // Rinsing edge.
        ASM_NOP();ASM_NOP();
    }
	Data_Temp = 0x06;//== 0x06 == 3λ
	Data_Temp = Data_Temp <<5;
    for (i=0; i<3; i++)
    {
        IO_LED_SCLK = 0;                          // Clock falling edge.
        ASM_NOP();ASM_NOP();
		if((Data_Temp & 0x80) == 0x80)
		{
			IO_LED_SDA = TRUE;
		}
		else
		{
			IO_LED_SDA = FALSE;
		}
        Data_Temp = Data_Temp << 1;                        // Shift
        IO_LED_SCLK = 1;                          // Rinsing edge.
        ASM_NOP();ASM_NOP();
    }
    ASM_NOP();ASM_NOP();
	IO_LED_LAT = TRUE;
    ASM_NOP();ASM_NOP();
	IO_LED_LAT = FALSE;
    ASM_NOP();ASM_NOP();
}

/*------------------------------ Function --------------------------------------
    Function:    LED_DRV_TransmitByteProcess
    Description: Transmit a byte
    Calls:
    Called By:
    Table Accessed:
    Table Updated:
    Input:
    Output:
    Return:
    Others:
------------------------------------------------------------------------------*/
void LED_DRV_TransmitByteProcess_Data(UINT16 H_BGR,UINT16 M_BGR,UINT16 L_BGR)
{
    UINT16 i,Data_Temp;
	IODDR_LED_LAT=TRUE;
    IODDR_LED_SCLK = TRUE;
    IODDR_LED_SDA  = TRUE;
	IODDR_BLANK = TRUE;
	IODDR_SOUT = FALSE;
	// =============ݴ========================
	IO_LED_LAT = FALSE;
    ASM_NOP();ASM_NOP();
	IO_LED_LAT = TRUE;
    ASM_NOP();ASM_NOP();
	IO_LED_LAT = FALSE;
    ASM_NOP();ASM_NOP();
    IO_LED_SCLK = FALSE;//==λߵ£ʱس֣Ϊģʽ
	IO_LED_SDA = FALSE;
    ASM_NOP();ASM_NOP();
    IO_LED_SCLK = TRUE;                          // Rinsing edge.
    ASM_NOP();ASM_NOP();

	Data_Temp = H_BGR;
    for (i=0; i<16; i++)
    {
        IO_LED_SCLK = 0;                          // Clock falling edge.
        ASM_NOP();ASM_NOP();
		if((Data_Temp & 0x8000) == 0x8000)
		{
			IO_LED_SDA = TRUE;
		}
		else
		{
			IO_LED_SDA = FALSE;
		}
        ASM_NOP();ASM_NOP();
        Data_Temp = Data_Temp << 1;                        // Shift
        IO_LED_SCLK = 1;                          // Rinsing edge.
        ASM_NOP();ASM_NOP();
    }
	
	Data_Temp = M_BGR;
    for (i=0; i<16; i++)
    {
        IO_LED_SCLK = 0;                          // Clock falling edge.
        ASM_NOP();ASM_NOP();
		if((Data_Temp & 0x8000) == 0x8000)
		{
			IO_LED_SDA = TRUE;
		}
		else
		{
			IO_LED_SDA = FALSE;
		}
        ASM_NOP();ASM_NOP();
        Data_Temp = Data_Temp << 1;                        // Shift
        IO_LED_SCLK = 1;                          // Rinsing edge.
        ASM_NOP();ASM_NOP();
    }

	Data_Temp = L_BGR;
    for (i=0; i<16; i++)
    {
        IO_LED_SCLK = 0;                          // Clock falling edge.
        ASM_NOP();ASM_NOP();
		if((Data_Temp & 0x8000) == 0x8000)
		{
			IO_LED_SDA = TRUE;
		}
		else
		{
			IO_LED_SDA = FALSE;
		}
        ASM_NOP();ASM_NOP();
        Data_Temp = Data_Temp << 1;                        // Shift
        IO_LED_SCLK = 1;                          // Rinsing edge.
        ASM_NOP();ASM_NOP();
    }
	IO_BLANK = TRUE;
    ASM_NOP();ASM_NOP();
	IO_LED_LAT = TRUE;
    ASM_NOP();ASM_NOP();
	IO_LED_LAT = FALSE;
    ASM_NOP();ASM_NOP();
	IO_BLANK = FALSE;
    ASM_NOP();ASM_NOP();
}
/*------------------------------ Function --------------------------------------
    Function:    RefreshLEDDriver
    Description: Refresh LED to Draiver
    Calls:
    Called By:   Timer Interrupt
    Table Accessed:
    Table Updated:
    Input:
    Output:
    Return:
    Others:
------------------------------------------------------------------------------*/

void RefreshLEDDriver(void)
{    
	LED_DRV_TransmitByteProcess_Data(0x5555,0xAAAA,0x5555);
	LED_DRV_TransmitByteProcess_Data(0xFFFF,0xFFFF,0xFFFF);
}
/*------------------------------ Function --------------------------------------
    Function:       DisplayDataProcess
    Description:    Vision Process for aptitude
    Calls:
    Called By:      Timer Interrupt
    Table Accessed:
    Table Updated:
    Input:
    Output:
    Return:
    Others:
------------------------------------------------------------------------------*/
void DisplayDataProcess(void)
{
	#define TIMER_ChangeSeg    10//UNIT 20mS
	static UINT16 ChangeSegTimer=0;
	Flag_Group DigitalDot11,DigitalDot12,DigitalDot13,DigitalDot14,DigitalDot21,DigitalDot22,DigitalDot23,DigitalDot24,DigitalDot25,DigitalDot26;
	UINT8 DigitalLED; 
	
	static const UINT8 DigitalDLEDTable[] =
	{
		0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x6F,\
		//    0    1     2       3    4       5      6    7      8      9  
		0x77,0x7C,0x39,0x5E,0x79,0x71,0x00,0x40,0x5C,0x3E,0x38,0x54,0x76,0x78,0x6E,0x5C,0x54,0x38,0x3E,0x63,0x73,
	//   A     b   C    d     E   F    " "  -   "o" "U"  "L"  "n"  "H" "t"  "y"   "o" "n"  "L"  "U" "o"  "P"
	};
			
	switch(DisplayMode)
	{
		case Mode_LEDNoLight :
		{
			DisplayBuf[0].Flag_Byte = 0;
			DisplayBuf[1].Flag_Byte = 0;
			DisplayBuf[2].Flag_Byte = 0;
			DisplayBuf[3].Flag_Byte = 0;
			DisplayBuf[4].Flag_Byte = 0;
			DisplayBuf[5].Flag_Byte = 0;
			DisplayBuf[6].Flag_Byte = 0;
			DisplayBuf[7].Flag_Byte = 0;
			DisplayBuf[8].Flag_Byte = 0;
			DisplayBuf[9].Flag_Byte = 0;
			DisplayBuf[10].Flag_Byte = 0;
			DisplayBuf[11].Flag_Byte = 0;
			return;			
		}
		case Mode_LEDAllLight :
		{
			DisplayBuf[0].Flag_Byte = 0xFF;
			DisplayBuf[1].Flag_Byte = 0xFF;
			DisplayBuf[2].Flag_Byte = 0xFF;
			DisplayBuf[3].Flag_Byte = 0xFF;
			DisplayBuf[4].Flag_Byte = 0xFF;
			DisplayBuf[5].Flag_Byte = 0xFF;
			DisplayBuf[6].Flag_Byte = 0xFF;
			DisplayBuf[7].Flag_Byte = 0xFF;
			DisplayBuf[8].Flag_Byte = 0xFF;
			DisplayBuf[9].Flag_Byte = 0xFF;
			DisplayBuf[10].Flag_Byte = 0xFF;
			DisplayBuf[11].Flag_Byte = 0xFF;
			return;	
		}
		case Mode_LEDFlashLight :
		{
			if(ChangeSegTimer++ > DisplaySpeed*TIMER_ChangeSeg)
			{
				ChangeSegTimer = 0;
				DisplayStep ++; 
				if(DisplayStep >= DisplayStep_End)
				{
					DisplayStep = DisplayStep_None;
				}	
			}
			break;
		}
		case Mode_LEDPauseLight :
		{
			break;
		}
		default :
		{
			break;
		}
	}
	
	DisplayBuf[0].Flag_Byte = 0;
	DisplayBuf[1].Flag_Byte = 0;
	DisplayBuf[2].Flag_Byte = 0;
	DisplayBuf[3].Flag_Byte = 0;
	DisplayBuf[4].Flag_Byte = 0;
	DisplayBuf[5].Flag_Byte = 0;
	DisplayBuf[6].Flag_Byte = 0;
	DisplayBuf[7].Flag_Byte = 0;
	DisplayBuf[8].Flag_Byte = 0;
	DisplayBuf[9].Flag_Byte = 0;
	DisplayBuf[10].Flag_Byte = 0;
	DisplayBuf[11].Flag_Byte = 0;
	switch(DisplayStep)
	{
		case DisplayStep_Num0:    {DigitalLED = 0;break;}
		case DisplayStep_Num1:    {DigitalLED = 1;break;}
		case DisplayStep_Num2:    {DigitalLED = 2;break;}
		case DisplayStep_Num3:    {DigitalLED = 3;break;}
		case DisplayStep_Num4:    {DigitalLED = 4;break;}
		case DisplayStep_Num5:    {DigitalLED = 5;break;}
		case DisplayStep_Num6:    {DigitalLED = 6;break;}
		case DisplayStep_Num7:    {DigitalLED = 7;break;}
		case DisplayStep_Num8:    {DigitalLED = 8;break;}
		case DisplayStep_Num9:    {DigitalLED = 9;break;}
		case DisplayStep_Num10:   {DigitalLED = 0x10;F_LED_Dot1 = TRUE;break;}
		case DisplayStep_Num11:   {DigitalLED = 0x10;F_LED_Dot2 = TRUE;break;}
		case DisplayStep_Num12:   {DigitalLED = 0x10;F_LED_Dot3 = TRUE;break;}
		case DisplayStep_Num13:   {DigitalLED = 0x10;F_LED_Dot4 = TRUE;break;}
		case DisplayStep_Num14:   {DigitalLED = 0x10;F_LED_Dot5 = TRUE;break;}
		case DisplayStep_Num15:   {DigitalLED = 0x10;F_LED_Dot6 = TRUE;break;}
		case DisplayStep_Num16:   {DigitalLED = 0x10;F_LED_Dot7 = TRUE;break;}
		case DisplayStep_Num17:   {DigitalLED = 0x10;F_LED_Dot8 = TRUE;break;}
		case DisplayStep_Num18:   {DigitalLED = 0x10;F_LED_Dot9 = TRUE;break;}
		case DisplayStep_Num19:   {DigitalLED = 0x10;F_LED_Dot10 = TRUE;break;}
		case DisplayStep_Num20:   {DigitalLED = 0x10;F_LED_Dot11 = TRUE;break;}
		default : {DigitalLED = 0x10;break;}
	}
	
	DigitalDot11.Flag_Byte= DigitalDLEDTable[DigitalLED];//=====һʾ
	F_Digital_DotA11=DigitalDot11.Bits.Flag_0;
	F_Digital_DotB11=DigitalDot11.Bits.Flag_1;
	F_Digital_DotC11=DigitalDot11.Bits.Flag_2;
	F_Digital_DotD11=DigitalDot11.Bits.Flag_3;
	F_Digital_DotE11=DigitalDot11.Bits.Flag_4;
	F_Digital_DotF11=DigitalDot11.Bits.Flag_5;
	F_Digital_DotG11=DigitalDot11.Bits.Flag_6;
    DigitalDot12.Flag_Byte= DigitalDLEDTable[DigitalLED];//=====ڶʾ
	F_Digital_DotA12=DigitalDot12.Bits.Flag_0;
	F_Digital_DotB12=DigitalDot12.Bits.Flag_1;
	F_Digital_DotC12=DigitalDot12.Bits.Flag_2;
 	F_Digital_DotD12=DigitalDot12.Bits.Flag_3;
	F_Digital_DotE12=DigitalDot12.Bits.Flag_4;
	F_Digital_DotF12=DigitalDot12.Bits.Flag_5;
	F_Digital_DotG12=DigitalDot12.Bits.Flag_6;	
	DigitalDot13.Flag_Byte= DigitalDLEDTable[DigitalLED];//=====ʾ
	F_Digital_DotA13=DigitalDot13.Bits.Flag_0;
	F_Digital_DotB13=DigitalDot13.Bits.Flag_1;
	F_Digital_DotC13=DigitalDot13.Bits.Flag_2;
	F_Digital_DotD13=DigitalDot13.Bits.Flag_3;
	F_Digital_DotE13=DigitalDot13.Bits.Flag_4;
	F_Digital_DotF13=DigitalDot13.Bits.Flag_5;
	F_Digital_DotG13=DigitalDot13.Bits.Flag_6;
    DigitalDot14.Flag_Byte= DigitalDLEDTable[DigitalLED];//=====ĸʾ
	F_Digital_DotA14=DigitalDot14.Bits.Flag_0;
	F_Digital_DotB14=DigitalDot14.Bits.Flag_1;
	F_Digital_DotC14=DigitalDot14.Bits.Flag_2;
 	F_Digital_DotD14=DigitalDot14.Bits.Flag_3;
	F_Digital_DotE14=DigitalDot14.Bits.Flag_4;
	F_Digital_DotF14=DigitalDot14.Bits.Flag_5;
	F_Digital_DotG14=DigitalDot14.Bits.Flag_6;		
}

void LEDDisplayProcess(void)
{
	IO_LED1 = FALSE;
	IO_LED2 = FALSE;
	IO_LED3 = FALSE;
	switch(DisplaySpeed)   // LED7ʾ 
	{
		case DisplaySpeed1 :{IO_LED1 = TRUE;break;}
		case DisplaySpeed2 :{IO_LED2 = TRUE;break;}
		case DisplaySpeed3 :{IO_LED1 = TRUE;IO_LED2 = TRUE;break;}
		case DisplaySpeed4 :{IO_LED3 = TRUE;break;}
		case DisplaySpeed5 :{IO_LED3 = TRUE;IO_LED1 = TRUE;break;}
		case DisplaySpeed6 :{IO_LED3 = TRUE;IO_LED2 = TRUE;break;}
		case DisplaySpeed7 :{IO_LED3 = TRUE;IO_LED2 = TRUE;IO_LED1 = TRUE;break;}
		default : {break;}
	}
}

