#ifndef IIC_DRIVER_H
#define IIC_DRIVER_H
//====================ʹõĳ궨======================
#define CMD_READ_DATA       0x42        // Read Data from driver command
#define CMD_WRITE_DATA      0x40		//0x40        // Write Data to driver
#define CMD_TURN_ON_LED     0x88+5		//0x88+2      // Turn on LED,Duty is 1/16
#define CMD_TURN_OFF_LED    0x80        // Turn off LED
#define CMD_SET_ADDRESS     0xC0        // Set Address for write.
#define	CMD_SET_MODE		0x02

#define	DD_BYTE_END			0x00        // ݴ
#define	DD_BYTE_CMD 		0x01		// ֽ
#define	DD_BYTE_SET			0x02		// ֽ
#define	DD_BYTE_DATA		0x03		// ʾ
//====================ʹõı(IO )궨==============
#define IO_LED_SDA				PDR0_P04
#define IODDR_LED_SDA			DDR0_P04
#define IOPUL_LED_SIN			PUL0_P04

#define IO_LED_SCLK				PDR0_P00
#define IODDR_LED_SCLK			DDR0_P00
#define IOPUL_LED_SCLK			PUL0_P00

#define IO_LED_LAT				PDR0_P03
#define IODDR_LED_LAT			DDR0_P03
#define IOPUL_LED_LAT			PUL0_P03

#define IO_BLANK       			PDR0_P06
#define IODDR_BLANK        		DDR0_P06
#define IOPUL_BLANK        		PUL0_P06

#define IO_SOUT        			PDR1_P10
#define IODDR_SOUT        		DDR1_P10
#define IOPUL_SOUT        		PUL1_P10

#define IO_LED1        			PDR6_P67
#define IODDR_LED1        		DDR6_P67
#define IOPUL_LED1        		PUL6_P67

#define IO_LED2        			PDRG_PG2
#define IODDR_LED2        		DDRG_PG2
#define IOPUL_LED2        		PULG_PG2

#define IO_LED3        			PDRG_PG1
#define IODDR_LED3        		DDRG_PG1
#define IOPUL_LED3        		PULG_PG1

enum DisplayModeDefine
{
Mode_LEDNoLight=0,
Mode_LEDAllLight,
Mode_LEDFlashLight,
Mode_LEDPauseLight
};

enum DisplaySpeedDefine
{
DisplaySpeed0=0,
DisplaySpeed1,
DisplaySpeed2,
DisplaySpeed3,
DisplaySpeed4,
DisplaySpeed5,
DisplaySpeed6,
DisplaySpeed7
};

enum
{
DisplayStep_None=0,
DisplayStep_Num0,
DisplayStep_Num1,
DisplayStep_Num2,
DisplayStep_Num3,
DisplayStep_Num4,
DisplayStep_Num5,
DisplayStep_Num6,
DisplayStep_Num7,
DisplayStep_Num8,
DisplayStep_Num9,
DisplayStep_Num10,
DisplayStep_Num11,
DisplayStep_Num12,
DisplayStep_Num13,
DisplayStep_Num14,
DisplayStep_Num15,
DisplayStep_Num16,
DisplayStep_Num17,
DisplayStep_Num18,
DisplayStep_Num19,
DisplayStep_Num20,
DisplayStep_Num21,
DisplayStep_End
};

extern enum DisplayModeDefine DisplayMode;
extern UINT16 DisplaySpeed;
extern UINT8 DisplayStep;
	
extern void LED_Init(void);
extern void LED_DRV_TransmitByteProcess_Com(void);
extern void DisplayDataProcess(void);
extern void RefreshLEDDriver(void);
#endif
