#include "mcu.h"
#include "TypeDef.h"   
#include "UART.h"  
uint8 UART_SendFramNum;
uint8 *UART_SendFramPoint;
__direct UART_SendDataFrameType SendDataFrame;
__direct UART_SendComFrameType SendComFrame;

/*---------------------------------------------------------------------------
-- Name		:	void Init_UART(void)
-- Input	:   NO
-- Output	:	NO
-- Description:	9600/8//1
-----------------------------------------------------------------------------*/

void Init_UART(void)
{
	IODDR_Tx = TRUE;	  //Output
 //	IODDR_Rx = FALSE;	  //InPUT

	SCR = 0xD0;
	SMR = 0x01;
	SSR = 0x00;
	//TDR0ΪҪ͵ 
	ESCR = 0x80;
	ECCR = 0x00;
	
	BGR1 = 0x00;
	BGR0 = 0xCF;
	
    ILR2 &= 0xFC;		//  ILR2_IRQ8
						//  IRQ8:  LIN-UART (transmission)
                      	//  IRQ9:  8/16-bit PPG ch1 (lower) | UART/SIO ch1
                      	//  IRQ10: 8/16-bit PPG ch1 (upper) | I2C ch1
                      	//  IRQ11: 16-bit reload timer ch0
//    ILR2 |= 0x00;		//  ȼ1


}

void UART_SendDataProcess(void)
{
	uint16 DelayLongTime=0;
	F_SendDataChange = !F_SendDataChange;
//	for(DelayLongTime=0;DelayLongTime<110;DelayLongTime++);// ҪʱֵΪ100
//  10----50uS    110ʹݷͼΪ50uS  120ʹֽݷͼΪ100uS
	SSR_TIE = FALSE;// رշж
	SCR |= 0x04;  //־ 
	if(F_SendDataChange)  // 
	{
		SendDataFrame.FrameHeader = Frame_DataHeader;
		SCR |= 0x04;  //־ 
		RDR_TDR=SendDataFrame.FrameHeader;
		SCR |= 0x01;
		for(DelayLongTime=0;DelayLongTime<110;DelayLongTime++);
		SCR |= 0x04;  //־ 
		RDR_TDR=SendDataFrame.Data1.Flag_Byte;
		SCR |= 0x01;
		for(DelayLongTime=0;DelayLongTime<110;DelayLongTime++);
		//while(!SSR_TDRE);
		SCR |= 0x04;  //־ 
		RDR_TDR=SendDataFrame.Data2.Flag_Byte;
		SCR |= 0x01;
		for(DelayLongTime=0;DelayLongTime<110;DelayLongTime++);
		//while(!SSR_TDRE);
		SCR |= 0x04;  //־ 
		RDR_TDR=SendDataFrame.Data3.Flag_Byte;
		SCR |= 0x01;
		for(DelayLongTime=0;DelayLongTime<110;DelayLongTime++);
		//while(!SSR_TDRE);
		SCR |= 0x04;  //־ 
		RDR_TDR=SendDataFrame.Data4.Flag_Byte;
		SCR |= 0x01;
		for(DelayLongTime=0;DelayLongTime<110;DelayLongTime++);
		//while(!SSR_TDRE);
		SCR |= 0x04;  //־ 
		RDR_TDR=SendDataFrame.Data5.Flag_Byte;
		SCR |= 0x01;
		for(DelayLongTime=0;DelayLongTime<110;DelayLongTime++);
		//while(!SSR_TDRE);
		SCR &= 0xFE;
	}
	else // ʾģʽ
	{
		SendComFrame.FrameHeader = Frame_ComHeader;
		SendComFrame.CommandType = Display_ComData;
		SCR |= 0x04;  //־ 
		RDR_TDR=SendComFrame.FrameHeader;
		SCR |= 0x01;
		//while(!SSR_TDRE);
		for(DelayLongTime=0;DelayLongTime<110;DelayLongTime++);
		SCR |= 0x04;  //־ 
		RDR_TDR=SendComFrame.CommandType;
		SCR |= 0x01;
		for(DelayLongTime=0;DelayLongTime<110;DelayLongTime++);
		//while(!SSR_TDRE);
		SCR &= 0xFE;	
	}
}


