

/* Includes ------------------------------------------------------------------*/
#include "stm32f4xx_ll_system.h"
#include "stm32f4xx_ll_exti.h"
#include "stm32f4xx_ll_cortex.h"
#include "stm32f4xx_ll_gpio.h"
#include "stm32f4xx.h"
#include "i2c.h"
#include "printf.h"

/* USER CODE BEGIN Private defines */

unsigned char address_select_volt[32][3]={      //Write，Read，PMBUS Address                          
            {0xB0,0xB1,0x58},                   //<=0.039V
            {0xB2,0xB3,0x59},                   //0.073V ± 15mV
            {0xB4,0xB5,0x5A},                   //0.122V ± 15mV
            {0xB6,0xB7,0x5B},                   //0.171V ± 15mV
            {0xB8,0xB9,0x5C},                   //0.219V ± 15mV
            {0xBA,0xBB,0x5D},                   //0.268V ± 15mV
            {0xBC,0xBD,0x5E},                   //0.317V ± 15mV
            {0xBE,0xBF,0x5F},                   //0.366V ± 15mV
            {0xC0,0xC1,0x60},                   //0.415V ± 15mV
            {0xC2,0xC3,0x61},                   //0.464V ± 15mV
            {0xC4,0xC5,0x62},                   //0.513V ± 15mV
            {0xC6,0xC7,0x63},                   //0.562V ± 15mV
            {0xC8,0xC9,0x64},                   //0.610V ± 15mV
            {0xCA,0xCB,0x65},                   //0.660V ± 15mV
            {0xCC,0xCD,0x66},                   //0.708V ± 15mV
            {0xCE,0xCF,0x67},                   //0.757V ± 15mV
            {0xD0,0xD1,0x68},                   //0.806V ± 15mV
            {0xD2,0xD3,0x69},                   //0.854V ± 15mV
            {0xD4,0xD5,0x6A},               
            {0xD6,0xD7,0x6B},               
            {0xD8,0xD9,0x6C},               
            {0xDA,0xDB,0x6D},               
            {0xDC,0xDD,0x6E},               
            {0xDE,0xDF,0x6F},               
            {0xE0,0xE1,0x70},               
            {0xE2,0xE3,0x71},               
            {0xE4,0xE5,0x72},               
            {0xE6,0xE7,0x73},               
            {0xE8,0xE9,0x74},               
            {0xEA,0xEB,0x75},               
            {0xEC,0xED,0x76},               
            {0xEE,0xEF,0x77}                           
        };

void i2c_gpio_init(void)
{
    /* 
    * PB8  -- IIC_SCL
    * PB9  -- IIC_SDA
    */

	LL_GPIO_InitTypeDef GPIO_InitStruct;
	LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_8);
	LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_9);

	GPIO_InitStruct.Pin = LL_GPIO_PIN_8|LL_GPIO_PIN_9;
	GPIO_InitStruct.Mode = LL_GPIO_MODE_OUTPUT;
	GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_LOW;
	GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
	GPIO_InitStruct.Pull = LL_GPIO_PULL_UP;
	LL_GPIO_Init(GPIOB, &GPIO_InitStruct);
	
    LL_GPIO_SetPinMode(GPIOB, LL_GPIO_PIN_8, LL_GPIO_MODE_OUTPUT);
    LL_GPIO_SetPinMode(GPIOB, LL_GPIO_PIN_9, LL_GPIO_MODE_OUTPUT);
    LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_8);
	LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_9);
}

void I2C_Delay(int ms)
{
   LL_mDelay(ms);

}   
            
void I2C_Start(void)
{
      I2C_SDA_OUT();

      I2C_SCL_LOW();
      I2C_Delay(1);
      
      I2C_SDA_HIGH();
      I2C_Delay(1);
      I2C_SCL_HIGH();
      I2C_Delay(1);
      I2C_SDA_LOW();
      I2C_Delay(1);
      I2C_SCL_LOW();
}        
        
void I2C_Stop(void)
{    
     I2C_SDA_OUT();
     I2C_SCL_LOW();
     I2C_Delay(1);              
     I2C_SDA_LOW();        
     I2C_Delay(1);          
     I2C_SCL_HIGH();
     I2C_Delay(2);        
     I2C_SDA_HIGH();
     //I2C_SDA_IN();
     //I2C_SDA_READ();
     I2C_Delay(1);
}

uint8_t I2C_WaitAck(void)
{
    uint8_t re;    
    
    I2C_SCL_LOW(); 
    I2C_Delay(1);
    I2C_SDA_IN();

    if(I2C_SDA_READ())
        re = 1;
    else
        re = 0;

    I2C_Delay(1);           
    I2C_SCL_HIGH();
    I2C_Delay(2);          

    return re;
}
        

void I2C_Ack(void)
{ 
    I2C_SCL_LOW();
    I2C_SDA_OUT();
    I2C_SDA_LOW(); 
    I2C_Delay(2);
    I2C_SCL_HIGH(); 
    I2C_Delay(2);
    I2C_SCL_LOW();
    I2C_Delay(1);
}
        

void I2C_NAck(void)
{
    I2C_SCL_LOW();
    I2C_SDA_OUT();
    I2C_SDA_HIGH();
    I2C_Delay(2);
    I2C_SCL_HIGH(); 
    I2C_Delay(2);
    I2C_SCL_LOW(); 
    I2C_Delay(1);
}

void I2C_SendByte(uint8_t Byte)
{
       uint8_t i;
        
       /* First send bit7 */
        I2C_SDA_OUT();
        I2C_SCL_LOW();
        
        for (i = 0; i < 8; i++)
        { 
           I2C_SCL_LOW();
           I2C_Delay(1);     
           if(Byte&0x80)
           {
                I2C_SDA_HIGH();
           }else
           {
                I2C_SDA_LOW();
           }

           Byte<<=1;
           
          
           I2C_Delay(1);
           I2C_SCL_HIGH();
           I2C_Delay(2);
          
       }

}
        
        
uint8_t I2C_ReadByte(void)
{
    uint8_t i;
    uint8_t value;

    /* first read data is bit7 */
    I2C_SDA_IN();
    //I2C_SDA_HIGH();
    value = 0;
    for (i = 0; i < 8; i++)
    {
        value <<= 1;
        I2C_SCL_LOW();
        I2C_Delay(1);
        
        value |= (uint8_t)I2C_SDA_READ();
        I2C_Delay(1);
        I2C_SCL_HIGH();
        I2C_Delay(2);
    }
    I2C_SCL_LOW();
    return value;
}       

 void I2C_InitGPIO(void)
{
  I2C_Stop();
}

uint8_t I2C_CheckDevice(uint8_t _Address)
{
    uint8_t ucAck;

    I2C_Start();        
    I2C_SendByte(_Address);
    I2C_WaitAck();
    I2C_Stop();        
    return ucAck;
}

uint8_t I2C_CheckOk(void)
{
     if(I2C_CheckDevice(TPS53681_DEV_ADDR_W) == 0)
    {
        return 1;
    }
    else
    {
        I2C_Stop();     
        return 0;
    }
}
        
uint8_t I2C_ReadBytes(uint8_t *ReadBuf, uint8_t Address, uint8_t Size)
{
    uint16_t i;
    
    I2C_Start();    
  
    I2C_SendByte(TPS53681_DEV_ADDR_W);    
  
    if (I2C_WaitAck() != 0)
    {
        goto cmd_fail; 
    }
    I2C_SendByte((uint8_t)Address); 
    if (I2C_WaitAck() != 0)
    {
        goto cmd_fail;  
    }

    I2C_Start();    
  
    I2C_SendByte(TPS53681_DEV_ADDR_R);

    if (I2C_WaitAck() != 0)
    {
        goto cmd_fail;  
    }
    
    for (i = 0; i < Size; i++)
    {
        ReadBuf[i] = I2C_ReadByte();    

        //I2C_Ack();
      
        if (i != Size - 1)
        {
            I2C_Ack(); 
        }
        else
        {
            I2C_NAck(); 
        }
    }
    I2C_Stop();
    return 1;   

cmd_fail:
  
    I2C_Stop();
    return 0;
}

uint8_t I2C_WriteBytes(uint8_t *WriteBuf, uint8_t Address, uint8_t Size)
{
        uint16_t i=0;
        uint8_t usAddr;
        
        usAddr = Address;
        I2C_Start();
        
        I2C_SendByte(TPS53681_DEV_ADDR_W); /* 此处是写指令 */
        
        if (I2C_WaitAck() != 0)
        {
            goto cmd_fail;
        }

        I2C_SendByte(usAddr);
        if (I2C_WaitAck() != 0)
        {
            goto cmd_fail;
        }  
        
        for (i = 0; i < Size; i++)
        {
            I2C_SendByte(WriteBuf[i]);
        
            if (I2C_WaitAck() != 0)
            {
                goto cmd_fail;  
            }
        }

        
        I2C_Stop();
        return 1;
    
    cmd_fail: 
        I2C_Stop();
        return 0;
    }

void tps_power_en(int val)
    {
        uint8_t read_buf[16];
        uint8_t addr = 0;
        uint8_t len = 0;
        uint8_t send_buf[16];
        uart_printf("==============START==========\r\n");
    
        int i = 0x78;
        for(i=0x78;i<0x81;i++)
        {
            if(i==0x79)
            {
                memset(read_buf,0,sizeof(read_buf));  
                I2C_ReadBytes(read_buf, i, 2);
                uart_printf("(0x%02x) ReadBuf: 0x%02x,0x%02x\r\n",i,read_buf[1],read_buf[0]);
                LL_mDelay(100);
            }
            else{
                memset(read_buf,0,sizeof(read_buf));  
                I2C_ReadBytes(read_buf, i, 1);
                uart_printf("(0x%02x) ReadBuf: 0x%02x\r\n",i,read_buf[0]);
                LL_mDelay(100);
            }
        }
    
        memset(send_buf,0,sizeof(send_buf));
        send_buf[0]=0x00;
        I2C_WriteBytes(send_buf, TPS53681_ON_OFF_CONFIG, 1);    
    
    
        memset(send_buf,0,sizeof(send_buf));
        send_buf[0]=0x00;
        I2C_WriteBytes(send_buf, TPS53681_PAGE, 1);             
    
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_PAGE, 1);
        uart_printf("TPS53681_PAGE(0x00) ReadBuf: 0x%02x\r\n",read_buf[0]);
        LL_mDelay(100);
    
        memset(send_buf,0,sizeof(send_buf));
        send_buf[0]=0xFF;
        I2C_WriteBytes(send_buf, TPS53681_PHASE, 1);             
    
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_PHASE, 1);
        uart_printf("TPS53681_PHASE(0x04) ReadBuf: 0x%02x\r\n",read_buf[0]);
        LL_mDelay(100);
    
        memset(send_buf,0,sizeof(send_buf));
        send_buf[0]=0x23;
        I2C_WriteBytes(send_buf, TPS53681_VBOOT, 1);             
    
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_VBOOT, 1);
        uart_printf("TPS53681_VBOOT(0xDB) ReadBuf: 0x%02x\r\n",read_buf[0]);
        LL_mDelay(100);
    
        memset(send_buf,0,sizeof(send_buf));
        send_buf[0]=0x23;
        send_buf[1]=0x00;
        I2C_WriteBytes(send_buf, TPS53681_VOUT_COMMAND, 2);             
    
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_VOUT_COMMAND, 2);
        uart_printf("TPS53681_VOUT_COMMAND(0x21) ReadBuf: 0x%02x,0x%02x\r\n",read_buf[1],read_buf[0]);
        LL_mDelay(100);
    
        memset(send_buf,0,sizeof(send_buf));
        send_buf[0]=0x1D;                                
        send_buf[1]=0x00;
        I2C_WriteBytes(send_buf, TPS53681_VOUT_MIN, 2); 
    
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_VOUT_MIN, 2);
        uart_printf("TPS53681_VOUT_MIN(0x2B) ReadBuf: 0x%02x, 0x%02x\r\n",read_buf[1],read_buf[0]);
        LL_mDelay(100);
        
        memset(send_buf,0,sizeof(send_buf));
        send_buf[0]=0xFF;                                
        send_buf[1]=0x00;
        I2C_WriteBytes(send_buf, TPS53681_VOUT_MAX, 2); 
    
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_VOUT_MAX, 2);
        uart_printf("TPS53681_VOUT_MAX(0x24) ReadBuf: 0x%02x, 0x%02x\r\n",read_buf[1],read_buf[0]);
        LL_mDelay(100);
    
        memset(send_buf,0,sizeof(send_buf));
        send_buf[0]=0x18;                                            
        I2C_WriteBytes(send_buf, TPS53681_ON_OFF_CONFIG, 1);             
        
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_ON_OFF_CONFIG, 1);
        uart_printf("TPS53681_ON_OFF_CONFIG(0x02) ReadBuf: 0x%02x\r\n",read_buf[0]);
        LL_mDelay(100);
        
        memset(send_buf,0,sizeof(send_buf));
        send_buf[0]=0x80;
        I2C_WriteBytes(send_buf, TPS53681_OPERATE, 1);             
        
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_OPERATE, 1);
        uart_printf("TPS53681_OPERATE(0x01) ReadBuf: 0x%02x\r\n",read_buf[0]);
        LL_mDelay(100);

    while(1)
    {
         for(i=0x78;i<0x81;i++)
        {
            if(i==0x79)
            {
                memset(read_buf,0,sizeof(read_buf));  
                I2C_ReadBytes(read_buf, i, 2);
                uart_printf("(0x%02x) ReadBuf: 0x%02x,0x%02x\r\n",i,read_buf[1],read_buf[0]);
                LL_mDelay(100);
            }
            else{
                memset(read_buf,0,sizeof(read_buf));  
                I2C_ReadBytes(read_buf, i, 1);
                uart_printf("(0x%02x) ReadBuf: 0x%02x\r\n",i,read_buf[0]);
                LL_mDelay(100);
            }
        }
         LL_mDelay(3000);
         uart_printf("\r\n\r\n");
    }
        
#if 0  
#if 1
        memset(send_buf,0,sizeof(send_buf));
        send_buf[0]=0x00;
        I2C_WriteBytes(send_buf, TPS53681_PAGE, 1);             //Set Channel A
    
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_PAGE, 1);
        uart_printf("TPS53681_PAGE(0x00) ReadBuf: 0x%02x\r\n",read_buf[0]);
        LL_mDelay(100);
#endif
    
#if 1
            memset(send_buf,0,sizeof(send_buf));
            send_buf[0]=0x00;
            I2C_WriteBytes(send_buf, TPS53681_CLEAR_FAULT, 1);            
        
            //memset(read_buf,0,sizeof(read_buf));  
            //I2C_ReadBytes(read_buf, MCP9801_CLEAR_FAULT, 1);
            //uart_printf("MCP9801_CLEAR_FAULT(0x03) ReadBuf: 0x%02x\r\n",read_buf[0]);
            LL_mDelay(100);
#endif
    
#if 1
        memset(send_buf,0,sizeof(send_buf));
        send_buf[0]=0x02;
        I2C_WriteBytes(send_buf, TPS53681_PHASE, 1);             
    
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_PHASE, 1);
        uart_printf("TPS53681_PHASE(0x04) ReadBuf: 0x%02x\r\n",read_buf[0]);
        LL_mDelay(100);
#endif
    
    
#if 1
        memset(send_buf,0,sizeof(send_buf));
        send_buf[0]=0x80;
        I2C_WriteBytes(send_buf, TPS53681_OPERATE, 1);             
        
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_OPERATE, 1);
        uart_printf("TPS53681_OPERATE(0x01) ReadBuf: 0x%02x\r\n",read_buf[0]);
        LL_mDelay(100);
#endif
    
#if 1
        memset(send_buf,0,sizeof(send_buf));
        send_buf[0]=0x1B;                                            
        I2C_WriteBytes(send_buf, TPS53681_ON_OFF_CONFIG, 1);             
        
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_ON_OFF_CONFIG, 1);
        uart_printf("TPS53681_ON_OFF_CONFIG(0x02) ReadBuf: 0x%02x\r\n",read_buf[0]);
        LL_mDelay(100);
#endif
    
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_MFR_SPECIFIC_13, 2);
        uart_printf("TPS53681_MFR_SPECIFIC_13(0xDD) ReadBuf: 0x%02x, 0x%02x\r\n",read_buf[1],read_buf[0]);
        LL_mDelay(100);
        
#if 1
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_VOUT_MODE, 1);
        uart_printf("TPS53681_VOUT_MODE(0x20) ReadBuf: 0x%02x\r\n",read_buf[0]);    //5-mV DAC Mode
        LL_mDelay(100);
#endif
    
#if 1
        memset(send_buf,0,sizeof(send_buf));
        send_buf[0]=0x29;                                
        send_buf[1]=0x00;
        I2C_WriteBytes(send_buf,TPS53681_VOUT_MAX, 2); 
    
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_VOUT_MAX, 2);
        uart_printf("TPS53681_VOUT_MAX(0x24) ReadBuf: 0x%02x, 0x%02x\r\n",read_buf[1],read_buf[0]);
        LL_mDelay(100);
#endif
    
#if 1
        memset(send_buf,0,sizeof(send_buf));
        send_buf[0]=0x1B;                                
        send_buf[1]=0x00;
        I2C_WriteBytes(send_buf, TPS53681_VOUT_MIN, 2); 
    
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_VOUT_MIN, 2);
        uart_printf("TPS53681_VOUT_MAX(0x2B) ReadBuf: 0x%02x, 0x%02x\r\n",read_buf[1],read_buf[0]);
        LL_mDelay(100);
#endif
    
    
#if 1
        memset(send_buf,0,sizeof(send_buf));
        send_buf[0]=0x1D;                                //0x83--0.9v    //0x1D---0.39V
        send_buf[1]=0x00;
        I2C_WriteBytes(send_buf, TPS53681_VOUT_COMMAND, 2); 
    
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_VOUT_COMMAND, 2);
        uart_printf("TPS53681_VOUT_COMMAND(0x21) ReadBuf: 0x%02x, 0x%02x\r\n",read_buf[1],read_buf[0]);
        LL_mDelay(100);
#endif
    
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_MFR_SPECIFIC_02, 2);
        uart_printf("TPS53681_MFR_SPECIFIC_02(0xD2) ReadBuf: 0x%02x, 0x%02x\r\n",read_buf[1],read_buf[0]);
        LL_mDelay(100);
    
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_READ_VOUT, 2);
        uart_printf("TPS53681_READ_VOUT(0x8B) ReadBuf: 0x%02x, 0x%02x\r\n",read_buf[1],read_buf[0]);
        LL_mDelay(100);
    
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_MFR_SPECIFIC_05, 1);
        uart_printf("TPS53681_MFR_SPECIFIC_05(0xD5) ReadBuf: 0x%02x\r\n",read_buf[0]);
        LL_mDelay(100);
    
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_STATUS_INPUT, 1);
        uart_printf("TPS53681_MFR_SPECIFIC_05(0x7C) ReadBuf: 0x%02x\r\n",read_buf[0]);
        LL_mDelay(100);
    
         memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, TPS53681_READ_VIN, 2);
        uart_printf("TPS53681(0x88) ReadBuf: 0x%02x, 0x%02x\r\n",read_buf[0],read_buf[1]);
        LL_mDelay(100);
 #endif   
        uart_printf("==============END=========\r\n\r\n");
          
    }



int main(void)
{
    //int delay = 10;
	int i = 0;
	
    hardware_init();
	LL_mDelay(10);
	i2c_gpio_init();
	  
    tps_power_en(1);
    LL_mDelay(3000);
}

