

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __i2c_H
#define __i2c_H
#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32f4xx_ll_dma.h"
#include "stm32f4xx.h"
#include "stm32f4xx_ll_i2c.h"
#include "stm32f4xx_ll_rcc.h"
#include "stm32f4xx_ll_bus.h"
#include "stm32f4xx_ll_system.h"
#include "stm32f4xx_ll_exti.h"
#include "stm32f4xx_ll_cortex.h"
#include "stm32f4xx_ll_utils.h"
#include "stm32f4xx_ll_pwr.h"
#include "stm32f4xx_ll_spi.h"
#include "stm32f4xx_ll_tim.h"
#include "stm32f4xx_ll_usart.h"
#include "stm32f4xx_ll_gpio.h"

/*PB8 PB9*/
#define I2C_SCL_HIGH()                      LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_8);    // HIGH
#define I2C_SCL_LOW()                       LL_GPIO_ResetOutputPin(GPIOB, LL_GPIO_PIN_8);  // LOW
#define I2C_SDA_HIGH()                      LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_9);    // HIGH
#define I2C_SDA_LOW()                       LL_GPIO_ResetOutputPin(GPIOB, LL_GPIO_PIN_9);  // LOW
#define I2C_SDA_READ()                      LL_GPIO_IsInputPinSet(GPIOB, LL_GPIO_PIN_9)
#define I2C_SDA_OUT()                       LL_GPIO_SetPinMode(GPIOB, LL_GPIO_PIN_9, LL_GPIO_MODE_OUTPUT);
#define I2C_SDA_IN()                        LL_GPIO_SetPinMode(GPIOB, LL_GPIO_PIN_9, LL_GPIO_MODE_INPUT);

#define TPS53681_DEV_ADDR			   address_select_volt[17][2]	    	/* iic的设备地址 */
#define TPS53681_DEV_ADDR_R            address_select_volt[17][1]
#define TPS53681_DEV_ADDR_W            address_select_volt[17][0]

#define TPS53681_PAGE               0x00
#define TPS53681_OPERATE            0x01
#define TPS53681_ON_OFF_CONFIG      0x02
#define TPS53681_CLEAR_FAULT        0x03
#define TPS53681_PHASE              0x04
#define TPS53681_VOUT_MODE          0x20
#define TPS53681_VOUT_COMMAND       0x21
#define TPS53681_VOUT_MAX           0x24
#define TPS53681_VOUT_MARGIN_HIGH   0x25
#define TPS53681_VOUT_MARGIN_LOW    0x26
#define TPS53681_VOUT_MIN           0x2B
#define TPS53681_STATUS_INPUT       0x7C
#define TPS53681_READ_VIN           0x88
#define TPS53681_READ_VOUT          0x8B
#define TPS53681_MFR_SPECIFIC_02    0xD2
#define TPS53681_MFR_SPECIFIC_05    0xD5
#define TPS53681_VBOOT              0xDB
#define TPS53681_MFR_SPECIFIC_13    0xDD
#define TPS53681_READVIN            0x88

/* PB8 PB9
*/
void I2C_Delay(int ms);

void i2c_gpio_init(void);
void I2C_Start(void);
void I2C_Stop(void);
uint8_t I2C_WaitAck(void);
void I2C_Ack(void);
void I2C_NAck(void);
void I2C_SendByte(uint8_t Byte);
uint8_t I2C_ReadByte(void);
void I2C_InitGPIO(void);

void I2C_Write(unsigned char Address,unsigned char Data);
unsigned char I2C_Read(unsigned char Address);
uint8_t I2C_CheckDevice(uint8_t _Address);
uint8_t I2C_CheckOk(void);
uint8_t I2C_ReadBytes(uint8_t *ReadBuf, uint8_t Address, uint8_t Size);

uint8_t I2C_WriteBytes(uint8_t *WriteBuf, uint8_t Address, uint8_t Size);

void tps_power_en(int val);

#ifdef __cplusplus
}
#endif
#endif /*__ i2c_H */

