//************************************************
/*
 * Con_Data.h
 *
 *  Created on: Jun 10, 2020
 *      Author: Charles Chen
 */
//************************************************

#ifndef SYSTEM_HEAD_CON_DATA_H_
#define SYSTEM_HEAD_CON_DATA_H_

#include <System_head/System_Init.h>

#define DETECT_BLANK_TIME 5
#define UPDATE_RATE 20    //20ms
#define SCLK_FRE 24 //  48M/(24+1)
#define GCLK_FRE_D 4 //  2/4
#define GCLK_FRE_P 8 //  48M/(4)

#define RGB_R_ON()  P2->OUT |= BIT0
#define RGB_R_OFF()  P2->OUT &= ~BIT0

#define RGB_G_ON()  P2->OUT |= BIT1
#define RGB_G_OFF()  P2->OUT &= ~BIT1

#define RGB_B_ON()  P2->OUT |= BIT2
#define RGB_B_OFF()  P2->OUT &= ~BIT2

#define RED_LED_ON() P1->OUT |= BIT0
#define RED_LED_OFF() P1->OUT &= ~BIT0

//48 bytes of Dot Correction Data
extern uint8_t DC_data[40][48];
//DC_data[0] = DCR0[6:0],
//DC_data[1] = DCG0[6:0],
//DC_data[2] = DCB0[6:0],
//DC_data[3] = DCR1[6:0],
//...,
//DC_data[47] = DCB15[6:0]

//3 bytes of Maximum Current Control Data
extern uint8_t MC_data[40][3]; //MC_data[0] = MCR[2:0], MC_data[1] = MCG[2:0], MC_data[2] = MCB[2:0]

//3 bytes of Global Brightness Control Data
extern uint8_t BC_data[40][3]; //BC_data[0] = BCR[6:0], BC_data[1] = BCG[6:0], BC_data[2] = BCB[6:0]

//5 bits of Function Control Data
extern uint8_t FUNC_data[40]; //LSDVLT(bit4), ESPWM(bit3), RFRESH(bit2), TMGRST(bit1), DSPRPT(bit0)

extern uint8_t Control_Data_Latch[40][97]; //Control data

//96 bytes of Gray scale Data
extern uint8_t GS_Data_Latch[40][97]; //GS data
//GS_data[0] = GSR0[7:0], GS_data[1] = GSR0[15:8],
//GS_data[2] = GSG0[7:0], GS_data[3] = GSG0[15:8],
//GS_data[4] = GSB0[7:0], GS_data[5] = GSB0[15:8],
//GS_data[6] = GSR1[7:0], GS_data[7] = GSR1[15:8],
//...,
//GS_data[94] = GSB15[7:0], GS_data[95] = GSB15[15:8]
extern uint8_t SID_Data[40][97]; //SID data read back
//extern uint8_t SID_Data_Latch[40][97]; //SID data format for user

extern uint8_t Data_Cat;
extern uint8_t read_en;
extern uint8_t GS_Data[40][6];

extern int8_t send_byte_cnt;
extern int8_t send_device_cnt;

extern uint8_t LED_MODE;
extern uint8_t LED_i,LED_j;
extern uint8_t Detec_data_H,Detec_data_L;
extern uint8_t detect_blank_cnt;
//extern uint16_t LSD_fault_cnt_Latch;
//extern uint16_t LOD_fault_cnt_Latch;
extern uint8_t com_fault_cnt_Latch;

extern void Con_Data_Init(void);
extern void Control_data_merge(uint8_t DC[][48], uint8_t MC[][3], uint8_t BC[][3], uint8_t FUNC[]);
extern void GS_data_merge(void);
extern void SID_data_merge(void);
extern void Data_send(uint8_t Data_flag,uint8_t sid_read_en);

extern void Sys_Init(void);
extern void IO_init(void);
extern void Timer_Init(void);
extern void SPI_Init(void);
extern void Single_Configure_Test(void);
extern void SPI_send_ISR(void);
extern void GSCLK_enable(void);
extern void GSCLK_disable(void);
extern void Data_Update_enalble(void);
extern void Fault_Detect(void);
extern void Brightness_Switch(void);
extern void PORT1_ISR(void);

#define CPU_F ((double)48000000)
#define delay_us(x) __delay_cycles((long)(CPU_F*(double)x/1000000.0))
#define delay_ms(x) __delay_cycles((long)(CPU_F*(double)x/1000.0))

#endif /* SYSTEM_HEAD_CON_DATA_H_ */
